/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.points;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasItem;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class DuplicateLocationInPolyLineCheck
extends BaseCheck<Long> {
    private static final List<String> FALLBACK_INSTRUCTIONS = Collections.singletonList("Repeated location found at {0} for feature id {1,number,#} ");
    private static final long serialVersionUID = 7403488805532662065L;

    public DuplicateLocationInPolyLineCheck(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Edge || object instanceof Area || object instanceof Line;
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        HashSet<Location> visitedLocations = new HashSet<Location>();
        Iterator locations = ((AtlasItem)object).getRawGeometry().iterator();
        int firstHit = 0;
        Location first = null;
        while (locations.hasNext()) {
            Location currentLocation = (Location)locations.next();
            if (first == null) {
                first = currentLocation;
            } else if (first.equals((Object)currentLocation)) {
                ++firstHit;
            }
            if (visitedLocations.contains(currentLocation) && !this.isFlagged(object.getOsmIdentifier()) && (!first.equals((Object)currentLocation) && locations.hasNext() || object instanceof Area || firstHit > 1)) {
                this.markAsFlagged(object.getOsmIdentifier());
                return Optional.of(this.createFlag(object, this.getLocalizedInstruction(0, currentLocation.toString(), object.getOsmIdentifier()), Collections.singletonList(currentLocation)));
            }
            visitedLocations.add(currentLocation);
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }
}

