/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.linear.edges;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.tags.AccessTag;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.SyntheticBoundaryNodeTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class ValenceOneImportantRoadCheck
extends BaseCheck<Long> {
    public static final String DEAD_END = "This road dead ends at node {0,number,#}.";
    public static final String FLOATING = "Both entry {0,number,#} and exit {1,number,#} nodes are disconnected.";
    public static final String NO_ENTRY = "There is no way to enter this road at node {0,number,#}.";
    public static final String PREFACE = "Road [highway={0}] {1,number,#} is not connected with the surrounding road network.";
    public static final String REVERSE_HINT = "Hint: This portion of the road may be digitally reversed.";
    private static final String CONSTRUCTION_HINT = "Hint: This road may be connected to roads with highway=construction or highway=proposed.";
    private static final String ACCESS_HINT = "Hint: This road may be connected to roads with restrictive access tags.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("Road [highway={0}] {1,number,#} is not connected with the surrounding road network.", "Both entry {0,number,#} and exit {1,number,#} nodes are disconnected.", "Hint: This portion of the road may be digitally reversed.", "There is no way to enter this road at node {0,number,#}.", "This road dead ends at node {0,number,#}.", "Hint: This road may be connected to roads with highway=construction or highway=proposed.", "Hint: This road may be connected to roads with restrictive access tags.");
    private static final EnumSet<HighwayTag> IMPORTANT_ROADS = EnumSet.of(HighwayTag.MOTORWAY, HighwayTag.TRUNK);
    private static final boolean OUTWARD = true;
    private static final boolean INWARD = false;
    private static final int ONE = 1;
    private static final int THREE = 3;
    private static final int FOUR = 4;
    private static final int FIVE = 5;
    private static final int SIX = 6;
    private static final long serialVersionUID = 3216643318716503627L;

    public ValenceOneImportantRoadCheck(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Edge && IMPORTANT_ROADS.contains(((Edge)object).highwayTag());
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        boolean endsWithValence1;
        Edge edge = (Edge)object;
        boolean beginsWithValence1 = this.inboundValence(edge) == 1L;
        boolean bl = endsWithValence1 = this.outboundValence(edge) == 1L;
        if (beginsWithValence1 || endsWithValence1) {
            List<Location> locations;
            StringList instructions = new StringList(new String[]{this.getLocalizedInstruction(0, edge.highwayTag().toString().toLowerCase(), edge.getIdentifier())});
            boolean construction = false;
            boolean accessNo = false;
            if (beginsWithValence1) {
                this.markAsFlagged(edge.start().getOsmIdentifier());
                if (endsWithValence1) {
                    this.markAsFlagged(edge.end().getOsmIdentifier());
                    locations = Arrays.asList(edge.start().getLocation(), edge.end().getLocation());
                    instructions.add(this.getLocalizedInstruction(1, edge.start().getIdentifier(), edge.end().getIdentifier()));
                    if (this.reverseOutboundValence(edge) >= 1L && this.reverseInboundValence(edge) >= 1L) {
                        instructions.add(this.getLocalizedInstruction(2, new Object[0]));
                    }
                    construction = this.hasConstructionConnection(edge.end());
                    accessNo = this.hasNoAccessConnection(edge.end());
                } else {
                    locations = Collections.singletonList(edge.start().getLocation());
                    instructions.add(this.getLocalizedInstruction(3, edge.start().getIdentifier()));
                }
                if (!construction) {
                    construction = this.hasConstructionConnection(edge.start());
                }
                if (!accessNo) {
                    accessNo = this.hasNoAccessConnection(edge.start());
                }
            } else {
                this.markAsFlagged(edge.end().getOsmIdentifier());
                locations = Collections.singletonList(edge.end().getLocation());
                instructions.add(this.getLocalizedInstruction(4, edge.end().getIdentifier()));
                construction = this.hasConstructionConnection(edge.end());
                accessNo = this.hasNoAccessConnection(edge.end());
            }
            if (construction) {
                instructions.add(this.getLocalizedInstruction(5, new Object[0]));
            }
            if (accessNo) {
                instructions.add(this.getLocalizedInstruction(6, new Object[0]));
            }
            return Optional.of(this.createFlag((AtlasObject)edge, instructions.join(" "), locations));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private long directionalValence(Node node, Boolean outward) {
        if (this.isFlagged(node.getOsmIdentifier()) || SyntheticBoundaryNodeTag.isBoundaryNode((Taggable)node)) {
            return Long.MAX_VALUE;
        }
        Set<Node> candidates = Collections.singleton(node);
        return node.connectedEdges().stream().filter(otherEdge -> otherEdge.isConnectedAtStartTo(candidates) == outward.booleanValue()).count() + 1L;
    }

    private boolean hasConstructionConnection(Node node) {
        return node.getAtlas().linesContaining(node.getLocation(), line -> Validators.isOfType((Taggable)line, HighwayTag.class, (Enum[])new HighwayTag[]{HighwayTag.CONSTRUCTION, HighwayTag.PROPOSED})).iterator().hasNext();
    }

    private boolean hasNoAccessConnection(Node node) {
        return node.getAtlas().linesContaining(node.getLocation(), line -> Validators.hasValuesFor((Taggable)line, (Class[])new Class[]{HighwayTag.class}) && Validators.isOfType((Taggable)line, AccessTag.class, (Enum[])new AccessTag[]{AccessTag.NO})).iterator().hasNext();
    }

    private long inboundValence(Edge edge) {
        return this.directionalValence(edge.start(), false);
    }

    private long outboundValence(Edge edge) {
        return this.directionalValence(edge.end(), true);
    }

    private long reverseInboundValence(Edge edge) {
        return this.directionalValence(edge.end(), false);
    }

    private long reverseOutboundValence(Edge edge) {
        return this.directionalValence(edge.start(), true);
    }
}

