/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.linear.edges;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import org.openstreetmap.atlas.checks.atlas.predicates.TypePredicates;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.walker.OsmWayWalker;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.JunctionTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class SuddenHighwayTypeChangeCheck
extends BaseCheck<Long> {
    private static final String SUDDEN_HIGHWAY_TYPE_CHANGE_INSTRUCTION = "Way {0,number,#} has a connected edge which jumps significantly in highway classification. Please make sure the highway tag is not suspicious.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Collections.singletonList("Way {0,number,#} has a connected edge which jumps significantly in highway classification. Please make sure the highway tag is not suspicious.");
    private static final String HIGHWAY_MINIMUM_DEFAULT = HighwayTag.RESIDENTIAL.toString();
    private static final long serialVersionUID = -4091313755808560402L;
    private final HighwayTag minHighwayType;

    public SuddenHighwayTypeChangeCheck(Configuration configuration) {
        super(configuration);
        String highwayType = this.configurationValue(configuration, "minHighwayType", HIGHWAY_MINIMUM_DEFAULT);
        this.minHighwayType = Enum.valueOf(HighwayTag.class, highwayType.toUpperCase());
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        if (TypePredicates.IS_EDGE.test(object) && ((Edge)object).isMainEdge() && !this.isFlagged(object.getOsmIdentifier())) {
            Edge edge = (Edge)object;
            return HighwayTag.isCarNavigableHighway((Taggable)edge) && edge.highwayTag().isMoreImportantThanOrEqualTo(this.minHighwayType) && !JunctionTag.isRoundabout((Taggable)edge) && !JunctionTag.isCircular((Taggable)edge);
        }
        return false;
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Edge edgeBeingVerified = (Edge)object;
        ArrayList completeWayEdges = new ArrayList(new OsmWayWalker(edgeBeingVerified).collectEdges());
        Node firstEdgeStartNode = ((Edge)completeWayEdges.get(0)).start();
        Node lastEdgeEndNode = ((Edge)completeWayEdges.get(completeWayEdges.size() - 1)).end();
        SortedSet firstEdgeStartNodeEdges = firstEdgeStartNode.connectedEdges();
        firstEdgeStartNodeEdges.removeIf(edge -> edge.getOsmIdentifier() == edgeBeingVerified.getOsmIdentifier());
        SortedSet lastEdgeEndNodeEdges = lastEdgeEndNode.connectedEdges();
        lastEdgeEndNodeEdges.removeIf(edge -> edge.getOsmIdentifier() == edgeBeingVerified.getOsmIdentifier());
        HighwayTag edgeBeingVerifiedHighwayTag = HighwayTag.highwayTag((Taggable)edgeBeingVerified).orElse(HighwayTag.NO);
        Set<HighwayTag> firstEdgeStartNodeEdgesHighwayTags = this.getHighwayTags(firstEdgeStartNodeEdges);
        Set<HighwayTag> lastEdgeEndNodeEdgesHighwayTags = this.getHighwayTags(lastEdgeEndNodeEdges);
        if (this.firstEdgeStartNodeEdgesHighwayTags(edgeBeingVerifiedHighwayTag, firstEdgeStartNodeEdges, firstEdgeStartNodeEdgesHighwayTags) || this.lastEdgeEndNodeEdgesHighwayTage(edgeBeingVerifiedHighwayTag, lastEdgeEndNodeEdges, lastEdgeEndNodeEdgesHighwayTags)) {
            this.markAsFlagged(object.getOsmIdentifier());
            return Optional.of(this.createFlag(object, this.getLocalizedInstruction(0, object.getOsmIdentifier())));
        }
        this.markAsFlagged(edgeBeingVerified.getOsmIdentifier());
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean edgeBeingVerifiedCaseOne(HighwayTag edgeHighwayTag) {
        return HighwayTag.MOTORWAY.equals((Object)edgeHighwayTag) || HighwayTag.PRIMARY.equals((Object)edgeHighwayTag) || HighwayTag.TRUNK.equals((Object)edgeHighwayTag);
    }

    private boolean edgeBeingVerifiedCaseThree(HighwayTag edgeHighwayTag) {
        return HighwayTag.TERTIARY.equals((Object)edgeHighwayTag) || HighwayTag.TERTIARY_LINK.equals((Object)edgeHighwayTag);
    }

    private boolean edgeBeingVerifiedCaseTwo(HighwayTag edgeHighwayTag) {
        return HighwayTag.MOTORWAY_LINK.equals((Object)edgeHighwayTag) || HighwayTag.PRIMARY_LINK.equals((Object)edgeHighwayTag) || HighwayTag.TRUNK_LINK.equals((Object)edgeHighwayTag) || HighwayTag.SECONDARY.equals((Object)edgeHighwayTag) || HighwayTag.SECONDARY_LINK.equals((Object)edgeHighwayTag);
    }

    private boolean edgeCheckedAgainstCaseOne(HighwayTag edgeHighwayTag) {
        return HighwayTag.TERTIARY.equals((Object)edgeHighwayTag) || HighwayTag.UNCLASSIFIED.equals((Object)edgeHighwayTag) || HighwayTag.RESIDENTIAL.equals((Object)edgeHighwayTag) || HighwayTag.SERVICE.equals((Object)edgeHighwayTag);
    }

    private boolean edgeCheckedAgainstCaseThree(HighwayTag edgeHighwayTag) {
        return HighwayTag.LIVING_STREET.equals((Object)edgeHighwayTag) || HighwayTag.TRACK.equals((Object)edgeHighwayTag) || HighwayTag.SERVICE.equals((Object)edgeHighwayTag);
    }

    private boolean edgeCheckedAgainstCaseTwo(HighwayTag edgeHighwayTag) {
        return HighwayTag.UNCLASSIFIED.equals((Object)edgeHighwayTag) || HighwayTag.RESIDENTIAL.equals((Object)edgeHighwayTag) || HighwayTag.SERVICE.equals((Object)edgeHighwayTag);
    }

    private boolean edgeIsRoundaboutOrCircular(Edge edge) {
        return JunctionTag.isCircular((Taggable)edge) || JunctionTag.isRoundabout((Taggable)edge);
    }

    private boolean firstEdgeStartNodeEdgesHighwayTags(HighwayTag edgeBeingVerifiedHighwayTag, Set<Edge> firstEdgeStartNodeEdges, Set<HighwayTag> firstEdgeStartNodeEdgesHighwayTags) {
        for (Edge firstEdgeEdge : firstEdgeStartNodeEdges) {
            HighwayTag firstEdgeEdgeHighwayTag = HighwayTag.highwayTag((Taggable)firstEdgeEdge).orElse(HighwayTag.NO);
            if (edgeBeingVerifiedHighwayTag.equals((Object)HighwayTag.NO) || firstEdgeEdgeHighwayTag.equals((Object)HighwayTag.NO) || firstEdgeStartNodeEdgesHighwayTags.contains(edgeBeingVerifiedHighwayTag) || this.edgeIsRoundaboutOrCircular(firstEdgeEdge) || !this.isCaseOne(edgeBeingVerifiedHighwayTag, firstEdgeEdgeHighwayTag) && !this.isCaseTwo(edgeBeingVerifiedHighwayTag, firstEdgeEdgeHighwayTag) && !this.isCaseThree(edgeBeingVerifiedHighwayTag, firstEdgeEdgeHighwayTag)) continue;
            return true;
        }
        return false;
    }

    private Set<HighwayTag> getHighwayTags(Set<Edge> edges) {
        HashSet<HighwayTag> highwayTags = new HashSet<HighwayTag>();
        for (Edge edge : edges) {
            Optional highwayTagOptional = HighwayTag.highwayTag((Taggable)edge);
            if (!highwayTagOptional.isPresent()) continue;
            HighwayTag highwayTag = (HighwayTag)highwayTagOptional.get();
            highwayTags.add(highwayTag);
        }
        return highwayTags;
    }

    private boolean isCaseOne(HighwayTag edgeHighwayTag1, HighwayTag edgeHighwayTag2) {
        return this.edgeBeingVerifiedCaseOne(edgeHighwayTag1) && this.edgeCheckedAgainstCaseOne(edgeHighwayTag2);
    }

    private boolean isCaseThree(HighwayTag edgeHighwayTag1, HighwayTag edgeHighwayTag2) {
        return this.edgeBeingVerifiedCaseThree(edgeHighwayTag1) && this.edgeCheckedAgainstCaseThree(edgeHighwayTag2);
    }

    private boolean isCaseTwo(HighwayTag edgeHighwayTag1, HighwayTag edgeHighwayTag2) {
        return this.edgeBeingVerifiedCaseTwo(edgeHighwayTag1) && this.edgeCheckedAgainstCaseTwo(edgeHighwayTag2);
    }

    private boolean lastEdgeEndNodeEdgesHighwayTage(HighwayTag edgeBeingVerifiedHighwayTag, Set<Edge> lastEdgeEndNodeEdges, Set<HighwayTag> lastEdgeEndNodeEdgesHighwayTags) {
        for (Edge lastEdgeEdge : lastEdgeEndNodeEdges) {
            HighwayTag lastEdgeEdgeHighwayTag = HighwayTag.highwayTag((Taggable)lastEdgeEdge).orElse(HighwayTag.NO);
            if (lastEdgeEdgeHighwayTag.equals((Object)HighwayTag.NO) || edgeBeingVerifiedHighwayTag.equals((Object)HighwayTag.NO) || lastEdgeEndNodeEdgesHighwayTags.contains(edgeBeingVerifiedHighwayTag) || this.edgeIsRoundaboutOrCircular(lastEdgeEdge) || !this.isCaseOne(edgeBeingVerifiedHighwayTag, lastEdgeEdgeHighwayTag) && !this.isCaseTwo(edgeBeingVerifiedHighwayTag, lastEdgeEdgeHighwayTag) && !this.isCaseThree(edgeBeingVerifiedHighwayTag, lastEdgeEdgeHighwayTag)) continue;
            return true;
        }
        return false;
    }
}

