/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.linear.edges;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Triple;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.tags.BarrierTag;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.SyntheticBoundaryNodeTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public class ShortSegmentCheck
extends BaseCheck<Long> {
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("This segment from startNode {0,number,#} to endNode {1,number,#} on way {2,number,#} is short (length < {3} m) and node {4,number,#} has less than {5} connections.");
    private static final double MAXIMUM_LENGTH_DEFAULT = Distance.ONE_METER.asMeters();
    private static final long MINIMUM_VALENCE_DEFAULT = 3L;
    private static final String MINIMUM_HIGHWAY_PRIORITY_DEFAULT = HighwayTag.SERVICE.toString();
    private static final long serialVersionUID = 6916628316458828018L;
    private final Distance maximumLength;
    private final long minimumValence;
    private final HighwayTag minimumHighwayPriority;

    private static Optional<Triple<Node, Node, Node>> getConnectedNodesWithValenceLessThan(Edge edge, long valence) {
        for (Node node : edge.connectedNodes()) {
            List mainEdges = node.connectedEdges().stream().filter(Edge::isMainEdge).collect(Collectors.toList());
            if ((long)mainEdges.size() >= valence || mainEdges.size() == 2 && mainEdges.stream().filter(connectedEdge -> connectedEdge.getOsmIdentifier() == edge.getOsmIdentifier()).count() > 1L) continue;
            Triple edgeNodes = Triple.of((Object)edge.start(), (Object)edge.end(), (Object)node);
            return Optional.of(edgeNodes);
        }
        return Optional.empty();
    }

    public ShortSegmentCheck(Configuration configuration) {
        super(configuration);
        this.maximumLength = this.configurationValue(configuration, "edge.length.maximum.meters", MAXIMUM_LENGTH_DEFAULT, Distance::meters);
        this.minimumValence = this.configurationValue(configuration, "node.valence.minimum", 3L);
        this.minimumHighwayPriority = Enum.valueOf(HighwayTag.class, this.configurationValue(configuration, "highway.priority.minimum", MINIMUM_HIGHWAY_PRIORITY_DEFAULT).toUpperCase());
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Edge && ((Edge)object).highwayTag().isMoreImportantThanOrEqualTo(this.minimumHighwayPriority) && ((Edge)object).isMainEdge() && ((Edge)object).length().isLessThan(this.maximumLength);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Edge edge = (Edge)object;
        Optional<Triple<Node, Node, Node>> lowValenceNodes = ShortSegmentCheck.getConnectedNodesWithValenceLessThan(edge, this.minimumValence);
        if (lowValenceNodes.isPresent() && !this.isGateLike((Edge)object) && !this.isEdgeWithSyntheticBoundaryNode(edge)) {
            return Optional.of(this.createFlag(object, this.getLocalizedInstruction(0, ((Node)lowValenceNodes.get().getLeft()).getOsmIdentifier(), ((Node)lowValenceNodes.get().getMiddle()).getOsmIdentifier(), object.getOsmIdentifier(), this.maximumLength.asMeters(), ((Node)lowValenceNodes.get().getRight()).getOsmIdentifier(), this.minimumValence), Collections.singletonList(((Node)lowValenceNodes.get().getRight()).getLocation())));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean isEdgeWithSyntheticBoundaryNode(Edge edge) {
        return edge.connectedNodes().stream().anyMatch(SyntheticBoundaryNodeTag::isSyntheticBoundaryNode);
    }

    private boolean isGateLike(Edge object) {
        return object.start().connectedEdges().stream().filter(Edge::isMainEdge).count() > 1L && Validators.hasValuesFor((Taggable)object.end(), (Class[])new Class[]{BarrierTag.class}) || object.end().connectedEdges().stream().filter(Edge::isMainEdge).count() > 1L && Validators.hasValuesFor((Taggable)object.start(), (Class[])new Class[]{BarrierTag.class});
    }
}

