/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.linear.edges;

import avro.shaded.com.google.common.collect.Range;
import avro.shaded.com.google.common.collect.Ranges;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.Heading;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Segment;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.walker.OsmWayWalker;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.LayerTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.oneway.OneWayTag;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Angle;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public class SeparateSidewalkTagCheck
extends BaseCheck<Long> {
    private static final String INSTRUCTION_FORMAT = "Way {0,number,#} is tagged as sidewalk={1} but separately mapped sidewalks were detected that are not consistent with the way's sidewalk tag. Verify that the sidewalk tag for this way is correct and consistent with separately mapped ways for the entirety of the way.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Collections.singletonList("Way {0,number,#} is tagged as sidewalk={1} but separately mapped sidewalks were detected that are not consistent with the way's sidewalk tag. Verify that the sidewalk tag for this way is correct and consistent with separately mapped ways for the entirety of the way.");
    private static final Double SIDEWALK_SEARCH_DISTANCE_DEFAULT = 15.0;
    private static final Double EDGE_LENGTH_DEFAULT = 20.0;
    private static final Range<Double> HEADING_DEGREE_RANGE = Ranges.closed((Comparable)Double.valueOf(-20.0), (Comparable)Double.valueOf(20.0));
    private static final String MAXIMUM_HIGHWAY_DEFAULT = HighwayTag.PRIMARY.toString();
    private static final String ALTERNATIVE_SIDEWALK_TAG_VALUE = "separate";
    private final Distance searchDistance;
    private final Distance defaultEdgeLength;
    private final HighwayTag maximumHighwayType;

    public SeparateSidewalkTagCheck(Configuration configuration) {
        super(configuration);
        this.searchDistance = this.configurationValue(configuration, "sidewalk.search.distance", SIDEWALK_SEARCH_DISTANCE_DEFAULT, Distance::meters);
        this.defaultEdgeLength = this.configurationValue(configuration, "edge.length", EDGE_LENGTH_DEFAULT, Distance::meters);
        this.maximumHighwayType = this.configurationValue(configuration, "maximum.highway.type", MAXIMUM_HIGHWAY_DEFAULT, str -> Enum.valueOf(HighwayTag.class, str.toUpperCase()));
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Edge && !this.isFlagged(object.getOsmIdentifier()) && ((Edge)object).isMainEdge() && HighwayTag.isCarNavigableHighway((Taggable)object) && this.validSidewalkFilter((Edge)object);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Edge edge = (Edge)object;
        Location edgeMidPoint = edge.start().getLocation().midPoint(edge.end().getLocation());
        String sidewalkTagValue = this.getSeparateSidewalkTagValue(edge);
        Set separatedSidewalks = Iterables.stream((Iterable)edge.getAtlas().edgesIntersecting((GeometricSurface)this.closestSegmentToPoint(edge.asPolyLine(), edgeMidPoint).middle().boxAround(this.searchDistance))).filter(this::validFootwayFilter).collectToSet();
        int rightSidewalkCount = 0;
        int leftSidewalkCount = 0;
        if (!separatedSidewalks.isEmpty()) {
            for (Edge sidewalk : separatedSidewalks) {
                Segment closestSidewalkSegment = this.closestSegmentToPoint(sidewalk.asPolyLine(), edgeMidPoint);
                if (this.isCrossing(edge.asPolyLine(), sidewalk.asPolyLine()) || !LayerTag.areOnSameLayer((Taggable)edge, (Taggable)sidewalk)) continue;
                if (this.isRightOf(edge.asPolyLine(), closestSidewalkSegment.middle())) {
                    ++rightSidewalkCount;
                    continue;
                }
                ++leftSidewalkCount;
            }
            if (this.isSidewalkTaggingMismatch(sidewalkTagValue, rightSidewalkCount, leftSidewalkCount)) {
                return this.generateFlag(edge, sidewalkTagValue);
            }
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private Segment closestSegmentToPoint(PolyLine line, Location location) {
        PolyLine tLine = new PolyLine((Iterable)location);
        return line.segments().stream().min(Comparator.comparingDouble(s -> s.shortestDistanceTo(tLine).asMeters())).orElseThrow(() -> new CoreException("Unable to get a Segment {}", new Object[]{line}));
    }

    private Optional<CheckFlag> generateFlag(Edge edge, String sidewalkTagValue) {
        super.markAsFlagged(edge.getOsmIdentifier());
        return Optional.of(this.createFlag((Set<AtlasObject>)new OsmWayWalker(edge).collectEdges(), this.getLocalizedInstruction(0, edge.getOsmIdentifier(), sidewalkTagValue)));
    }

    private String getSeparateSidewalkTagValue(Edge edge) {
        if (edge.getTag("sidewalk").isPresent()) {
            return (String)edge.getTag("sidewalk").get();
        }
        if (edge.getTag("sidewalk:left").isPresent() && ALTERNATIVE_SIDEWALK_TAG_VALUE.equals(edge.getTag("sidewalk:left").get()) && (edge.getTag("sidewalk:right").isPresent() && "no".equals(edge.getTag("sidewalk:right").get()) || edge.getTag("sidewalk:right").isEmpty())) {
            return "left";
        }
        if (edge.getTag("sidewalk:right").isPresent() && ALTERNATIVE_SIDEWALK_TAG_VALUE.equals(edge.getTag("sidewalk:right").get()) && (edge.getTag("sidewalk:left").isPresent() && "no".equals(edge.getTag("sidewalk:left").get()) || edge.getTag("sidewalk:left").isEmpty())) {
            return "right";
        }
        if (edge.getTag("sidewalk:left").isPresent() && ALTERNATIVE_SIDEWALK_TAG_VALUE.equals(edge.getTag("sidewalk:left").get()) && edge.getTag("sidewalk:right").isPresent() && ALTERNATIVE_SIDEWALK_TAG_VALUE.equals(edge.getTag("sidewalk:right").get())) {
            return "both";
        }
        return null;
    }

    private boolean isAcceptableHeading(Heading headingOne, Heading headingTwo) {
        int primeMeridian = 180;
        return HEADING_DEGREE_RANGE.contains((Comparable)Double.valueOf(headingOne.asDegrees() - headingTwo.asDegrees())) || HEADING_DEGREE_RANGE.contains((Comparable)Double.valueOf(headingOne.asDegrees() - Math.abs(180.0 - headingTwo.asDegrees())));
    }

    private boolean isCrossing(PolyLine lineCrossed, PolyLine crossingItem) {
        return !lineCrossed.intersections(crossingItem).isEmpty() || lineCrossed.overlapsShapeOf(crossingItem) || !this.isAcceptableHeading(Objects.requireNonNull(lineCrossed.overallHeading().orElse(null)), Objects.requireNonNull(crossingItem.overallHeading().orElse(null)));
    }

    private boolean isDualCarriageWay(Edge edge) {
        Optional highwayTag = HighwayTag.highwayTag((Taggable)edge);
        Optional onewayTag = OneWayTag.tag((Taggable)edge);
        return highwayTag.isPresent() && onewayTag.isPresent() && ((HighwayTag)highwayTag.get()).isMoreImportantThanOrEqualTo(this.maximumHighwayType) && "YES".equals(((OneWayTag)onewayTag.get()).toString());
    }

    private boolean isRightOf(PolyLine line, Location location) {
        PolyLine locationLine = new PolyLine((Iterable)location);
        Segment closest = line.segments().stream().min(Comparator.comparingDouble(s -> s.shortestDistanceTo(locationLine).asMeters())).orElse(null);
        if (closest != null) {
            PolyLine testLine = new PolyLine(new Location[]{closest.first(), closest.last(), location});
            Angle difference = testLine.headingDifference().orElse(null);
            return difference != null && difference.asDegrees() > 0.0;
        }
        return false;
    }

    private boolean isSidewalkTaggingMismatch(String sidewalkTagValue, int rightSidewalkCount, int leftSidewalkCount) {
        switch (sidewalkTagValue) {
            case "right": {
                return leftSidewalkCount > 0;
            }
            case "left": {
                return rightSidewalkCount > 0;
            }
            case "both": {
                return rightSidewalkCount < 1 || leftSidewalkCount < 1;
            }
        }
        throw new CoreException("Unknown sidewalk tag value {}", new Object[]{sidewalkTagValue});
    }

    private boolean validFootwayFilter(Edge edge) {
        return edge.isMainEdge() && edge.getTag("highway").isPresent() && "footway".equals(edge.getTag("highway").get()) && edge.getTag("footway").isPresent() && "sidewalk".equals(edge.getTag("footway").get()) || edge.getTag("foot").isPresent() && ((String)edge.getTag("foot").get()).matches("yes|designated");
    }

    private boolean validSidewalkFilter(Edge edge) {
        return (edge.getTag("sidewalk").isPresent() && ((String)edge.getTag("sidewalk").get()).matches("left|right|both") || edge.getTag("sidewalk:left").isPresent() && ALTERNATIVE_SIDEWALK_TAG_VALUE.equals(edge.getTag("sidewalk:left").get()) || edge.getTag("sidewalk:right").isPresent() && ALTERNATIVE_SIDEWALK_TAG_VALUE.equals(edge.getTag("sidewalk:right").get())) && !this.isDualCarriageWay(edge) && edge.asPolyLine().length().asMeters() >= this.defaultEdgeLength.asMeters() && !edge.isClosed();
    }
}

