/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.linear.edges;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.walker.SimpleEdgeWalker;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.JunctionTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.filters.TaggableFilter;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class RoundaboutHighwayTagCheck
extends BaseCheck<Long> {
    private static final long serialVersionUID = 5324388633864552231L;
    private static final String TAG_FILTER_IGNORE_DEFAULT = "junction->roundabout|highway->*_link|service->driveway";
    private static final String ROUNDABOUT_HIGHWAY_LEVEL_INSTRUCTION = "The way, id:{0,number,#}, should have the highway tag that matches the highest classification of road that passes through. Current: {1}. Expected: {2}.";
    private static final List<String> FALLBACK_INSTRUCTION = List.of("The way, id:{0,number,#}, should have the highway tag that matches the highest classification of road that passes through. Current: {1}. Expected: {2}.");
    private final TaggableFilter tagFilterIgnore;

    public RoundaboutHighwayTagCheck(Configuration configuration) {
        super(configuration);
        this.tagFilterIgnore = this.configurationValue(configuration, "ignore.tags.filter", TAG_FILTER_IGNORE_DEFAULT, TaggableFilter::forDefinition);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Edge && JunctionTag.isRoundabout((Taggable)object) && HighwayTag.isCarNavigableHighway((Taggable)object) && ((Edge)object).isMainEdge() && !this.isFlagged(object.getIdentifier());
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Edge edge = (Edge)object;
        HighwayTag currentHighwayTag = edge.highwayTag();
        Set roundaboutEdges = new SimpleEdgeWalker(edge, this.gatherRoundaboutEdges()).collectEdges();
        roundaboutEdges.stream().map(AtlasObject::getIdentifier).forEach(this::markAsFlagged);
        HighwayTag highestHighwayTag = this.getConnectEdgesMaxHighwayTagClassification(roundaboutEdges);
        if (highestHighwayTag.isMoreImportantThan(currentHighwayTag)) {
            CheckFlag flag = this.createFlag((Set<AtlasObject>)roundaboutEdges, this.getLocalizedInstruction(0, object.getOsmIdentifier(), currentHighwayTag, highestHighwayTag));
            return Optional.of(flag);
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTION;
    }

    private Set<Edge> externalEdges(Set<Node> roundaboutNodes) {
        return roundaboutNodes.stream().flatMap(node -> node.connectedEdges().stream().filter(Edge::isMainEdge).filter(Predicate.not(this.tagFilterIgnore))).collect(Collectors.toSet());
    }

    private Function<Edge, Stream<Edge>> gatherRoundaboutEdges() {
        return edge -> edge.connectedEdges().stream().filter(JunctionTag::isRoundabout);
    }

    private HighwayTag getConnectEdgesMaxHighwayTagClassification(Set<Edge> roundaboutEdges) {
        Set<Node> roundaboutNodes = roundaboutEdges.stream().map(Edge::start).collect(Collectors.toSet());
        Set<Edge> connectedHighwayEdges = this.externalEdges(roundaboutNodes);
        List<HighwayTag> validHighwayTags = this.highwayTagsOnMultipleEdges(connectedHighwayEdges);
        return this.maxHighwayTag(validHighwayTags);
    }

    private List<HighwayTag> highwayTagsOnMultipleEdges(Set<Edge> connectedHighwayEdges) {
        EnumMap highwayTagCount = new EnumMap(HighwayTag.class);
        connectedHighwayEdges.stream().map(Edge::highwayTag).forEach(tag -> highwayTagCount.put((HighwayTag)tag, highwayTagCount.getOrDefault(tag, 0) + 1));
        return highwayTagCount.entrySet().stream().filter(entrySet -> (Integer)entrySet.getValue() / 2 > 1).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private HighwayTag maxHighwayTag(List<HighwayTag> highwayTags) {
        return highwayTags.stream().reduce(HighwayTag.NO, (prev, cur) -> cur.isMoreImportantThan(prev) ? cur : prev);
    }
}

