/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.linear.edges;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.checks.utility.CommonMethods;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Route;
import org.openstreetmap.atlas.geography.atlas.items.complex.ComplexEntity;
import org.openstreetmap.atlas.geography.atlas.items.complex.roundabout.ComplexRoundabout;
import org.openstreetmap.atlas.geography.atlas.walker.OsmWayWalker;
import org.openstreetmap.atlas.geography.atlas.walker.SimpleEdgeWalker;
import org.openstreetmap.atlas.tags.BridgeTag;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.JunctionTag;
import org.openstreetmap.atlas.tags.LayerTag;
import org.openstreetmap.atlas.tags.SyntheticBoundaryNodeTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.TunnelTag;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Angle;

public class MalformedRoundaboutCheck
extends BaseCheck<Long> {
    private static final long serialVersionUID = -3018101860747289836L;
    private static final String BASIC_INSTRUCTION = "This roundabout is malformed.";
    private static final String ENCLOSED_ROADS_INSTRUCTIONS = "This roundabout has car navigable ways inside it.";
    private static final String WRONG_WAY_INSTRUCTIONS = "This roundabout is going the wrong direction, or has been improperly tagged as a roundabout.";
    private static final String MINIMUM_NODES_INSTRUCTION = "This roundabout has less than {0,number,#} nodes.";
    private static final String SHARP_ANGLE_INSTRUCTION = "This roundabout has too sharp of an angle at {0}, consider adding more nodes or rearranging the roundabout to fix this.";
    private static final List<String> LEFT_DRIVING_COUNTRIES_DEFAULT = Arrays.asList("AIA", "ATG", "AUS", "BGD", "BHS", "BMU", "BRB", "BRN", "BTN", "BWA", "CCK", "COK", "CXR", "CYM", "CYP", "DMA", "FJI", "FLK", "GBR", "GGY", "GRD", "GUY", "HKG", "IDN", "IMN", "IND", "IRL", "JAM", "JEY", "JPN", "KEN", "KIR", "KNA", "LCA", "LKA", "LSO", "MAC", "MDV", "MLT", "MOZ", "MSR", "MUS", "MWI", "MYS", "NAM", "NFK", "NIU", "NPL", "NRU", "NZL", "PAK", "PCN", "PNG", "SGP", "SGS", "SHN", "SLB", "SUR", "SWZ", "SYC", "TCA", "THA", "TKL", "TLS", "TON", "TTO", "TUV", "TZA", "UGA", "VCT", "VGB", "VIR", "WSM", "ZAF", "ZMB", "ZWE");
    private static final double MIN_NODES_DEFAULT = 9.0;
    private static final double MAX_THRESHOLD_DEGREES_DEFAULT = 60.0;
    private static final int MIN_NODES_INSTRUCTION_INDEX = 3;
    private static final int SHARP_ANGLE_INSTRUCTION_INDEX = 4;
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("This roundabout has car navigable ways inside it.", "This roundabout is going the wrong direction, or has been improperly tagged as a roundabout.", "This roundabout is malformed.", "This roundabout has less than {0,number,#} nodes.", "This roundabout has too sharp of an angle at {0}, consider adding more nodes or rearranging the roundabout to fix this.");
    private final List<String> leftDrivingCountries;
    private final double minNodes;
    private final Angle maxAngleThreshold;

    public MalformedRoundaboutCheck(Configuration configuration) {
        super(configuration);
        this.leftDrivingCountries = this.configurationValue(configuration, "traffic.countries.left", LEFT_DRIVING_COUNTRIES_DEFAULT);
        this.minNodes = this.configurationValue(configuration, "min.nodes", 9.0);
        this.maxAngleThreshold = this.configurationValue(configuration, "angle.threshold.maximum_degree", 60.0, Angle::degrees);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Edge && object.getTag("iso_country_code").isPresent() && JunctionTag.isRoundabout((Taggable)object) && !this.isFlagged(object.getIdentifier()) && ((Edge)object).isMainEdge() && !this.isExcludedHighway(object) && !this.isEdgeWithSyntheticBoundaryNode(object);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        HashSet<String> instructions = new HashSet<String>();
        ComplexRoundabout complexRoundabout = new ComplexRoundabout((Edge)object, this.leftDrivingCountries);
        Set roundaboutEdgeSet = complexRoundabout.getRoundaboutEdgeSet();
        Route roundaboutEdges = complexRoundabout.getRoundaboutRoute();
        if (!complexRoundabout.isValid()) {
            if (complexRoundabout.getAllInvalidations().size() == 1 && ((ComplexEntity.ComplexEntityError)complexRoundabout.getAllInvalidations().get(0)).getReason().equals(WRONG_WAY_INSTRUCTIONS) && !this.isMultiWayRoundabout(roundaboutEdgeSet)) {
                roundaboutEdgeSet.forEach(roundaboutEdge -> this.markAsFlagged(roundaboutEdge.getIdentifier()));
                return Optional.of(this.createFlag((Set<AtlasObject>)new OsmWayWalker((Edge)object).collectEdges(), this.getLocalizedInstruction(1, object.getOsmIdentifier())).addFixSuggestion(FeatureChange.add((AtlasEntity)((AtlasEntity)((CompleteEntity)CompleteEntity.from((AtlasEntity)((AtlasEntity)object))).withGeometry((Iterable)CommonMethods.buildOriginalOsmWayGeometry((Edge)object).reversed())), (Atlas)object.getAtlas())));
            }
            instructions.addAll(complexRoundabout.getAllInvalidations().stream().map(ComplexEntity.ComplexEntityError::getReason).collect(Collectors.toSet()));
        }
        roundaboutEdgeSet.forEach(roundaboutEdge -> this.markAsFlagged(roundaboutEdge.getIdentifier()));
        if (!roundaboutEdgeSet.isEmpty() && roundaboutEdges != null && roundaboutEdgeSet.stream().noneMatch(this::ignoreBridgeTunnelCrossings) && this.roundaboutEnclosesRoads(roundaboutEdges)) {
            instructions.add(this.getLocalizedInstruction(0, new Object[0]));
        }
        try {
            List maxAngles;
            PolyLine originalGeometry = CommonMethods.buildOriginalOsmWayGeometry((Edge)object);
            if ((double)originalGeometry.size() < this.minNodes && !this.isMultiWayRoundabout(roundaboutEdgeSet)) {
                instructions.add(this.getLocalizedInstruction(3, this.minNodes));
            }
            if (!(maxAngles = originalGeometry.anglesGreaterThanOrEqualTo(this.maxAngleThreshold)).isEmpty()) {
                String angleLocations = "(" + maxAngles.stream().map(t -> "(" + ((Location)t.getSecond()).getLatitude() + ", " + ((Location)t.getSecond()).getLongitude() + ")").collect(Collectors.joining(", ")) + ")";
                instructions.add(this.getLocalizedInstruction(4, angleLocations));
            }
        }
        catch (CoreException originalGeometry) {
            // empty catch block
        }
        if (!instructions.isEmpty()) {
            CheckFlag flag = this.createFlag((Set<AtlasObject>)roundaboutEdgeSet, this.getLocalizedInstruction(2, new Object[0]));
            instructions.forEach(flag::addInstruction);
            return Optional.of(flag);
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean ignoreBridgeTunnelCrossings(Edge edge) {
        return Validators.hasValuesFor((Taggable)edge, (Class[])new Class[]{LayerTag.class}) || BridgeTag.isBridge((Taggable)edge) || TunnelTag.isTunnel((Taggable)edge);
    }

    private boolean intersectsWithEnclosedGeometry(Polygon polygon, Edge edge) {
        PolyLine polyline = edge.asPolyLine();
        return polygon.intersections(polyline).stream().anyMatch(intersection -> !edge.start().getLocation().equals(intersection) && !edge.end().getLocation().equals(intersection) || polygon.fullyGeometricallyEncloses(polyline));
    }

    private boolean isEdgeWithSyntheticBoundaryNode(AtlasObject object) {
        return new SimpleEdgeWalker((Edge)object, this.isRoundaboutEdge()).collectEdges().stream().anyMatch(roundaboutEdge -> roundaboutEdge.connectedNodes().stream().anyMatch(SyntheticBoundaryNodeTag::isSyntheticBoundaryNode));
    }

    private boolean isExcludedHighway(AtlasObject object) {
        return Validators.isOfType((Taggable)object, HighwayTag.class, (Enum[])new HighwayTag[]{HighwayTag.CYCLEWAY, HighwayTag.PEDESTRIAN, HighwayTag.FOOTWAY});
    }

    private boolean isMultiWayRoundabout(Set<Edge> roundaboutEdges) {
        return roundaboutEdges.stream().map(AtlasEntity::getOsmIdentifier).distinct().count() > 1L;
    }

    private Function<Edge, Stream<Edge>> isRoundaboutEdge() {
        return edge -> edge.connectedEdges().stream().filter(connected -> JunctionTag.isRoundabout((Taggable)connected) && !this.isExcludedHighway((AtlasObject)connected));
    }

    private boolean roundaboutEnclosesRoads(Route roundabout) {
        Polygon roundaboutPoly = new Polygon((Iterable)roundabout.asPolyLine());
        return roundabout.start().getAtlas().edgesIntersecting((GeometricSurface)roundaboutPoly, edge -> edge.isMainEdge() && HighwayTag.isCarNavigableHighway((Taggable)edge) && !JunctionTag.isRoundabout((Taggable)edge) && edge.getTag("area").isEmpty() && !this.ignoreBridgeTunnelCrossings((Edge)edge) && this.intersectsWithEnclosedGeometry(roundaboutPoly, (Edge)edge)).iterator().hasNext();
    }
}

