/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.linear.edges;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import org.openstreetmap.atlas.checks.atlas.predicates.TypePredicates;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Segment;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public class ApproximateWayCheck
extends BaseCheck<Long> {
    public static final double DEVIATION_MAXIMUM_RATIO_DEFAULT = 0.04;
    public static final double DEVIATION_MINIMUM_LENGTH_DEFAULT = 10.0;
    public static final double MIN_ANGLE_DEFAULT = 60.0;
    public static final double MAX_ANGLE_DEFAULT = 160.0;
    public static final double BEZIER_STEP_DEFAULT = 0.01;
    private static final long serialVersionUID = 125449616392217396L;
    private static final String EDGE_DEVIATION_INSTRUCTION = "Way {0,number,#} is crude. Please add more nodes/rearrange current nodes to more closely match the road from imagery";
    private static final List<String> FALLBACK_INSTRUCTIONS = Collections.singletonList("Way {0,number,#} is crude. Please add more nodes/rearrange current nodes to more closely match the road from imagery");
    private static final String HIGHWAY_MINIMUM_DEFAULT = HighwayTag.SERVICE.toString();
    private final double maxDeviationRatio;
    private final Distance minDeviationLength;
    private final HighwayTag highwayMinimum;
    private final double minAngle;
    private final double maxAngle;
    private final double bezierStep;

    public ApproximateWayCheck(Configuration configuration) {
        super(configuration);
        this.maxDeviationRatio = this.configurationValue(configuration, "deviation.ratio.max", 0.04, Double::doubleValue);
        this.minDeviationLength = this.configurationValue(configuration, "deviation.minimum.meters", 10.0, Distance::meters);
        String highwayType = this.configurationValue(configuration, "highway.minimum", HIGHWAY_MINIMUM_DEFAULT);
        this.highwayMinimum = Enum.valueOf(HighwayTag.class, highwayType.toUpperCase());
        this.minAngle = this.configurationValue(configuration, "angle.minimum", 60.0);
        this.maxAngle = this.configurationValue(configuration, "angle.max", 160.0);
        this.bezierStep = this.configurationValue(configuration, "bezierStep", 0.01);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return TypePredicates.IS_EDGE.test(object) && ((Edge)object).isMainEdge() && HighwayTag.isCarNavigableHighway((Taggable)object) && this.isMinimumHighwayType(object);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        List segments = ((Edge)object).asPolyLine().segments();
        if (segments.size() < 2) {
            return Optional.empty();
        }
        boolean isCrude = IntStream.range(0, segments.size() - 1).anyMatch(index -> {
            Segment seg2;
            Segment seg1 = (Segment)segments.get(index);
            double angle = this.findAngle(seg1, seg2 = (Segment)segments.get(index + 1));
            if (angle < this.minAngle || angle > this.maxAngle) {
                return false;
            }
            double distance = this.quadraticBezier(seg1.first(), seg2.first(), seg2.end());
            double legsLength = seg1.length().asMeters() + seg2.length().asMeters();
            return distance > this.minDeviationLength.asMeters() && distance / legsLength > this.maxDeviationRatio;
        });
        if (isCrude) {
            return Optional.of(this.createFlag(object, this.getLocalizedInstruction(0, object.getOsmIdentifier())));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private double distance(double startX, double startY, double endX, double endY) {
        return Math.sqrt(Math.pow(endX - startX, 2.0) + Math.pow(endY - startY, 2.0));
    }

    private double findAngle(Segment seg1, Segment seg2) {
        double aLength = seg1.length().asMeters();
        double bLength = seg2.length().asMeters();
        double cLength = new Segment(seg1.start(), seg2.end()).length().asMeters();
        return Math.toDegrees(Math.acos((Math.pow(aLength, 2.0) + Math.pow(bLength, 2.0) - Math.pow(cLength, 2.0)) / (2.0 * aLength * bLength)));
    }

    private boolean isMinimumHighwayType(AtlasObject object) {
        Optional highwayTagOfObject = HighwayTag.highwayTag((Taggable)object);
        return highwayTagOfObject.isPresent() && ((HighwayTag)highwayTagOfObject.get()).isMoreImportantThanOrEqualTo(this.highwayMinimum);
    }

    private double quadraticBezier(Location start, Location anchor, Location end) {
        double startX = start.getLongitude().onEarth().asMeters();
        double startY = start.getLatitude().onEarth().asMeters();
        double anchorX = anchor.getLongitude().onEarth().asMeters();
        double anchorY = anchor.getLatitude().onEarth().asMeters();
        double endX = end.getLongitude().onEarth().asMeters();
        double endY = end.getLatitude().onEarth().asMeters();
        double min = Double.POSITIVE_INFINITY;
        for (double step = 0.0; step <= 1.0; step += this.bezierStep) {
            double pointY;
            double pointX = Math.pow(1.0 - step, 2.0) * startX + (2.0 * step * (1.0 - step) * anchorX + Math.pow(step, 2.0) * endX);
            double distance = this.distance(pointX, pointY = Math.pow(1.0 - step, 2.0) * startY + (2.0 * step * (1.0 - step) * anchorY + Math.pow(step, 2.0) * endY), anchorX, anchorY);
            if (!(distance < min)) continue;
            min = distance;
        }
        return min;
    }
}

