/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.intersections;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.checks.atlas.predicates.TagPredicates;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.checks.validation.GeometryValidator;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Segment;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.tags.BuildingTag;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.WaterwayTag;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfIntersectingPolylineCheck
extends BaseCheck<Long> {
    public static final Integer THREE = 3;
    private static final String AREA_INSTRUCTION = "Feature {0,number,#} has invalid geometry at {1}";
    private static final String POLYLINE_BUILDING_INSTRUCTION = "Feature {0,number,#} is a incomplete building at {1}";
    private static final String DUPLICATE_EDGE_INSTRUCTION = "Feature {0,number,#} has a duplicate Edge at {1}";
    private static final String POLYLINE_INSTRUCTION = "Self-intersecting polyline for feature {0,number,#} at {1}";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("Self-intersecting polyline for feature {0,number,#} at {1}", "Feature {0,number,#} has invalid geometry at {1}", "Feature {0,number,#} is a incomplete building at {1}", "Feature {0,number,#} has a duplicate Edge at {1}");
    private static final Logger logger = LoggerFactory.getLogger(SelfIntersectingPolylineCheck.class);
    private static final String MINIMUM_HIGHWAY_TYPE_DEFAULT = "SERVICE";
    private static final long serialVersionUID = 2722288442633787006L;
    private final HighwayTag minimumHighwayType;

    public SelfIntersectingPolylineCheck(Configuration configuration) {
        super(configuration);
        this.minimumHighwayType = this.configurationValue(configuration, "minimum.highway.type", MINIMUM_HIGHWAY_TYPE_DEFAULT, string -> HighwayTag.valueOf((String)string.toUpperCase()));
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Edge && ((Edge)object).isMainEdge() && (Validators.hasValuesFor((Taggable)object, (Class[])new Class[]{BuildingTag.class}) || ((Edge)object).highwayTag().isMoreImportantThanOrEqualTo(this.minimumHighwayType)) || object instanceof Area || object instanceof Line && !Validators.hasValuesFor((Taggable)object, (Class[])new Class[]{WaterwayTag.class});
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Optional<CheckFlag> response;
        int localizedInstructionIndex;
        PolyLine polyline;
        if (object instanceof Edge) {
            polyline = ((Edge)object).asPolyLine();
            localizedInstructionIndex = TagPredicates.IS_BUILDING.test(object) ? 2 : 0;
        } else if (object instanceof Line) {
            polyline = ((Line)object).asPolyLine();
            localizedInstructionIndex = TagPredicates.IS_BUILDING.test(object) ? 2 : 0;
        } else if (object instanceof Area) {
            polyline = ((Area)object).asPolygon();
            localizedInstructionIndex = this.hasDuplicateSegments(polyline) ? THREE : 1;
        } else {
            throw new CoreException("Invalid item type {}", new Object[]{object.getClass().toString()});
        }
        Set selfIntersections = polyline.selfIntersections();
        if (selfIntersections.size() > 0) {
            CheckFlag flag = new CheckFlag(Long.toString(object.getIdentifier()));
            flag.addObject(object);
            flag.addInstruction(this.getLocalizedInstruction(localizedInstructionIndex, object.getOsmIdentifier(), selfIntersections.toString()));
            selfIntersections.forEach(flag::addPoint);
            response = Optional.of(flag);
        } else {
            boolean isJtsValid = true;
            try {
                isJtsValid = GeometryValidator.testSimplicity((Iterable<Location>)polyline).isEmpty();
            }
            catch (IllegalArgumentException e) {
                logger.error("Encountered invalid geometry for feature {}", (Object)object.getOsmIdentifier(), (Object)e);
            }
            response = !isJtsValid ? Optional.of(this.createFlag(object, this.getLocalizedInstruction(localizedInstructionIndex, new Object[0]))) : Optional.empty();
        }
        return response;
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean hasDuplicateSegments(PolyLine polyline) {
        List segments = polyline.segments();
        for (Segment segment : segments) {
            if (segments.indexOf(segment) == segments.lastIndexOf(segment)) continue;
            return true;
        }
        return false;
    }
}

