/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.intersections;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.checks.utility.CommonMethods;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.LayerTag;
import org.openstreetmap.atlas.tags.RailwayTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.filters.TaggableFilter;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class IntersectionAtDifferentLayersCheck
extends BaseCheck<Long> {
    private static final String INSTRUCTION_FORMAT = "The Node id {0,number,#} connects Ways {1} at different layers.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Collections.singletonList("The Node id {0,number,#} connects Ways {1} at different layers.");
    private static final String INDOOR_MAPPING_DEFAULT = "indoor->*|highway->corridor,steps|level->*";
    private static final String GREAT_SEPARATION_FILTER_DEFAULT = "";
    private final TaggableFilter indoorMappingFilter;
    private final TaggableFilter greatSeparationFilter;
    private static final long serialVersionUID = 5171171744111206429L;

    public IntersectionAtDifferentLayersCheck(Configuration configuration) {
        super(configuration);
        this.indoorMappingFilter = this.configurationValue(configuration, "indoor.mapping.filter", INDOOR_MAPPING_DEFAULT, TaggableFilter::forDefinition);
        this.greatSeparationFilter = this.configurationValue(configuration, "great.separation.filter", GREAT_SEPARATION_FILTER_DEFAULT, TaggableFilter::forDefinition);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return !this.isFlagged(object.getOsmIdentifier()) && object instanceof Node && !HighwayTag.isPedestrianCrossing((Taggable)object) && !RailwayTag.isRailwayCrossing((Taggable)object);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Set edgesToReport;
        Node node = (Node)object;
        List connectedEdges = node.connectedEdges().stream().filter(Edge::isMainEdge).filter(obj -> HighwayTag.isCarNavigableHighway((Taggable)obj) || HighwayTag.isPedestrianNavigableHighway((Taggable)obj)).filter(obj -> obj.getTag("area").isEmpty()).collect(Collectors.toList());
        if (connectedEdges.size() > 1 && !(edgesToReport = connectedEdges.stream().filter(edge1 -> connectedEdges.stream().anyMatch(edge2 -> edge1.getOsmIdentifier() != edge2.getOsmIdentifier() && !this.isIndoorMappingFilter((Edge)edge1) && !this.isIndoorMappingFilter((Edge)edge2) && !LayerTag.areOnSameLayer((Taggable)edge1, (Taggable)edge2) && this.isInterLocationNode((Edge)edge1, node) && this.isInterLocationNode((Edge)edge2, node) && (this.isGreatSeparationFilter((Edge)edge1) || this.isGreatSeparationFilter((Edge)edge2)))).collect(Collectors.toSet())).isEmpty()) {
            return Optional.of(this.createFlag(object, this.getLocalizedInstruction(0, object.getOsmIdentifier(), edgesToReport.stream().map(AtlasObject::getOsmIdentifier).collect(Collectors.toList()))));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean isGreatSeparationFilter(Edge edge) {
        return this.greatSeparationFilter.test((Taggable)edge);
    }

    private boolean isIndoorMappingFilter(Edge edge) {
        return this.indoorMappingFilter.test((Taggable)edge);
    }

    private boolean isInterLocationNode(Edge edge, Node node) {
        List interLocations = StreamSupport.stream(CommonMethods.buildOriginalOsmWayGeometry(edge).innerLocations().spliterator(), false).collect(Collectors.toList());
        return interLocations.contains(node.getLocation());
    }
}

