/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.intersections;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.atlas.checks.atlas.predicates.TagPredicates;
import org.openstreetmap.atlas.checks.atlas.predicates.TypePredicates;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.LocationItem;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.walker.OsmWayWalker;
import org.openstreetmap.atlas.tags.FordTag;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.LeisureTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.WaterwayTag;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class HighwayIntersectionCheck
extends BaseCheck<Long> {
    private static final long serialVersionUID = -2100623356724302728L;
    private static final String INSTRUCTION_FORMAT = "The way with id {0,number,#} has invalid intersections with {1}. A highway way should not share nodes with non-highway features. Either the way is inproperly tagged or is a combination of what should be two separate ways (highway and the other non-highway feature).";
    private static final List<String> FALLBACK_INSTRUCTIONS = Collections.singletonList("The way with id {0,number,#} has invalid intersections with {1}. A highway way should not share nodes with non-highway features. Either the way is inproperly tagged or is a combination of what should be two separate ways (highway and the other non-highway feature).");

    public HighwayIntersectionCheck(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return !this.isFlagged(object) && TypePredicates.IS_EDGE.test(object) && ((Edge)object).isMainEdge() && HighwayTag.isCarNavigableHighway((Taggable)object);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Edge edge = (Edge)object;
        OsmWayWalker wayWalker = new OsmWayWalker(edge);
        Set wayEdges = wayWalker.collectEdges();
        Stream<Edge> edgesConnectedToWay = wayEdges.stream().map(Edge::connectedEdges).flatMap(Collection::stream).filter(connectedEdge -> !this.hasSameOSMId((AtlasObject)connectedEdge, (AtlasObject)edge));
        Set<Edge> invalidconnectingEdges = edgesConnectedToWay.filter(connectedEdge -> TagPredicates.IS_POWER_LINE.test((AtlasObject)connectedEdge) || !FordTag.isYes((Taggable)edge) && this.isWaterwayToCheck((AtlasObject)connectedEdge) && !this.isSlipway((AtlasObject)edge)).collect(Collectors.toSet());
        if (!invalidconnectingEdges.isEmpty()) {
            return this.createFlag(edge, wayEdges, invalidconnectingEdges);
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private Optional<CheckFlag> createFlag(Edge edge, Set<Edge> wayEdges, Set<Edge> crossingEdges) {
        List<Location> points = wayEdges.stream().map(wayEdge -> crossingEdges.stream().map(crossEdge -> this.getIntersections((Edge)wayEdge, (Edge)crossEdge)).flatMap(Collection::stream).map(LocationItem::getLocation).collect(Collectors.toList())).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        this.markAsFlagged(edge.getOsmIdentifier());
        Set crossingIds = crossingEdges.stream().map(AtlasObject::getOsmIdentifier).collect(Collectors.toSet());
        String instruction = this.getLocalizedInstruction(0, edge.getOsmIdentifier(), crossingIds);
        return Optional.of(this.createFlag(wayEdges, instruction, points));
    }

    private Set<Node> getIntersections(Edge firstEdge, Edge secondEdge) {
        Set locations = firstEdge.connectedNodes();
        locations.retainAll(secondEdge.connectedNodes());
        return locations;
    }

    private boolean hasSameOSMId(AtlasObject first, AtlasObject second) {
        return first.getOsmIdentifier() == second.getOsmIdentifier();
    }

    @Override
    private boolean isFlagged(AtlasObject object) {
        return this.isFlagged(object.getOsmIdentifier());
    }

    private boolean isSlipway(AtlasObject object) {
        return Validators.isOfType((Taggable)object, LeisureTag.class, (Enum[])new LeisureTag[]{LeisureTag.SLIPWAY});
    }

    private boolean isWaterWay(Taggable taggable) {
        return Validators.hasValuesFor((Taggable)taggable, (Class[])new Class[]{WaterwayTag.class});
    }

    private boolean isWaterwayToCheck(AtlasObject object) {
        Optional waterwayTagValue;
        boolean validForCheck = false;
        if (this.isWaterWay((Taggable)object) && (waterwayTagValue = WaterwayTag.get((Taggable)object)).isPresent()) {
            String waterwayTag = ((WaterwayTag)waterwayTagValue.get()).name();
            validForCheck = !HighwayTag.highwayTag((Taggable)object).isPresent() || !WaterwayTag.DAM.toString().equalsIgnoreCase(waterwayTag) && !WaterwayTag.WEIR.toString().equalsIgnoreCase(waterwayTag);
        }
        return validForCheck;
    }
}

