/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.intersections;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.atlas.checks.atlas.predicates.TypePredicates;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.walker.EdgeWalker;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.LayerTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.filters.TaggableFilter;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Distance;
import org.openstreetmap.atlas.utilities.tuples.Tuple;

public class EdgeCrossingEdgeCheck
extends BaseCheck<Long> {
    private static final String INSTRUCTION_FORMAT = "The roads with ids {0} invalidly cross each other. If two roads are crossing each other, then they should have nodes at intersection locations unless they are explicitly marked as crossing. Otherwise, crossing roads should have different layer tags.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Collections.singletonList("The roads with ids {0} invalidly cross each other. If two roads are crossing each other, then they should have nodes at intersection locations unless they are explicitly marked as crossing. Otherwise, crossing roads should have different layer tags.");
    private static final boolean CAR_NAVIGABLE_DEFAULT = true;
    private static final boolean PEDESTRIAN_NAVIGABLE_DEFAULT = false;
    private static final boolean CROSSING_CAR_NAVIGABLE_DEFAULT = true;
    private static final boolean CROSSING_PEDESTRIAN_NAVIGABLE_DEFAULT = false;
    private static final String MINIMUM_HIGHWAY_DEFAULT = HighwayTag.NO.toString();
    private static final String MAXIMUM_HIGHWAY_DEFAULT = HighwayTag.MOTORWAY.toString();
    private static final Long OSM_LAYER_DEFAULT = 0L;
    private static final Double CLUSTER_DISTANCE_DEFAULT = 500.0;
    private static final long serialVersionUID = 2146863485833228593L;
    private static final String DEFAULT_INDOOR_MAPPING = "indoor->*|highway->corridor,steps|level->*";
    private final boolean carNavigable;
    private final boolean pedestrianNavigable;
    private final boolean crossingCarNavigable;
    private final boolean crossingPedestrianNavigable;
    private final HighwayTag minimumHighwayType;
    private final HighwayTag maximumHighwayType;
    private final TaggableFilter indoorMapping;
    private final Distance clusterDistance;
    private final Map<Long, Tuple<Set<Location>, Set<Edge>>> clusteredIntersections = new HashMap<Long, Tuple<Set<Location>, Set<Edge>>>();

    private static boolean canCross(PolyLine edgeAsPolyLine, Long edgeLayer, PolyLine crossingEdgeAsPolyLine, Long crossingEdgeLayer, Location intersection) {
        return edgeAsPolyLine.contains(intersection) && crossingEdgeAsPolyLine.contains(intersection) || !edgeLayer.equals(crossingEdgeLayer);
    }

    public EdgeCrossingEdgeCheck(Configuration configuration) {
        super(configuration);
        this.minimumHighwayType = this.configurationValue(configuration, "minimum.highway.type", MINIMUM_HIGHWAY_DEFAULT, str -> Enum.valueOf(HighwayTag.class, str.toUpperCase()));
        this.maximumHighwayType = this.configurationValue(configuration, "maximum.highway.type", MAXIMUM_HIGHWAY_DEFAULT, str -> Enum.valueOf(HighwayTag.class, str.toUpperCase()));
        this.carNavigable = this.configurationValue(configuration, "car.navigable", true);
        this.pedestrianNavigable = this.configurationValue(configuration, "pedestrian.navigable", false);
        this.crossingCarNavigable = this.configurationValue(configuration, "crossing.car.navigable", true);
        this.crossingPedestrianNavigable = this.configurationValue(configuration, "crossing.pedestrian.navigable", false);
        this.indoorMapping = TaggableFilter.forDefinition((String)this.configurationValue(configuration, "indoor.mapping", DEFAULT_INDOOR_MAPPING));
        this.clusterDistance = this.configurationValue(configuration, "cluster.distance", CLUSTER_DISTANCE_DEFAULT, Distance::meters);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return TypePredicates.IS_EDGE.test(object) && this.isValidCrossingEdge(object, this.carNavigable, this.pedestrianNavigable);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        if (!this.clusteredIntersections.containsKey(object.getIdentifier())) {
            Set collectedEdges = new EdgeCrossingEdgeWalker((Edge)object, this.getInvalidCrossingEdges()).collectEdges();
            if (collectedEdges.size() > 1) {
                this.clusterIntersections(this.getIntersectionPairs(collectedEdges));
            } else {
                return Optional.empty();
            }
        }
        Tuple<Set<Location>, Set<Edge>> cluster = this.clusteredIntersections.get(object.getIdentifier());
        ((Set)cluster.getSecond()).forEach(edge -> this.clusteredIntersections.remove(edge.getIdentifier()));
        return this.createEdgeCrossCheckFlag(cluster);
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private void clusterIntersections(List<Tuple<Location, Edge>> intersectionPairs) {
        while (!intersectionPairs.isEmpty()) {
            ArrayDeque<Tuple<Location, Edge>> queue = new ArrayDeque<Tuple<Location, Edge>>();
            queue.add(intersectionPairs.get(0));
            HashSet<Location> locations = new HashSet<Location>();
            HashSet<Edge> edges = new HashSet<Edge>();
            while (!queue.isEmpty()) {
                Tuple intersectionPair = (Tuple)queue.pop();
                locations.add((Location)intersectionPair.getFirst());
                edges.add((Edge)intersectionPair.getSecond());
                intersectionPairs.remove(intersectionPair);
                queue.addAll(intersectionPairs.stream().filter(pair -> !queue.contains(pair) && ((Location)intersectionPair.getFirst()).distanceTo((Location)pair.getFirst()).isLessThanOrEqualTo(this.clusterDistance)).collect(Collectors.toList()));
            }
            edges.forEach(edge -> this.clusteredIntersections.put(edge.getIdentifier(), (Tuple<Set<Location>, Set<Edge>>)Tuple.createTuple((Object)locations, (Object)edges)));
        }
    }

    private Optional<CheckFlag> createEdgeCrossCheckFlag(Tuple<Set<Location>, Set<Edge>> cluster) {
        ((Set)cluster.getSecond()).forEach(edge -> this.markAsFlagged(edge.getIdentifier()));
        return Optional.of(this.createFlag((Set<AtlasObject>)((Set)cluster.getSecond()), this.getLocalizedInstruction(0, ((Set)cluster.getSecond()).stream().map(AtlasObject::getOsmIdentifier).collect(Collectors.toSet())), new ArrayList<Location>((Collection)cluster.getFirst())));
    }

    private Set<Location> getIntersection(Edge edge1, Edge edge2) {
        PolyLine edge1AsPolyLine = edge1.asPolyLine();
        PolyLine edge2AsPolyLine = edge2.asPolyLine();
        Long edge1LayerTag = LayerTag.getTaggedOrImpliedValue((Taggable)edge1, (Long)OSM_LAYER_DEFAULT);
        Long edge2LayerTag = LayerTag.getTaggedOrImpliedValue((Taggable)edge2, (Long)OSM_LAYER_DEFAULT);
        return edge1AsPolyLine.intersections(edge2AsPolyLine).stream().filter(intersection -> !EdgeCrossingEdgeCheck.canCross(edge1AsPolyLine, edge1LayerTag, edge2AsPolyLine, edge2LayerTag, intersection)).collect(Collectors.toSet());
    }

    private List<Tuple<Location, Edge>> getIntersectionPairs(Set<Edge> edges) {
        ArrayList<Tuple<Location, Edge>> intersections = new ArrayList<Tuple<Location, Edge>>();
        edges.forEach(edge -> edges.stream().filter(otherEdge -> !otherEdge.equals(edge)).forEach(otherEdge -> this.getIntersection((Edge)edge, (Edge)otherEdge).forEach(location -> intersections.add(Tuple.createTuple((Object)location, (Object)edge)))));
        return intersections;
    }

    private Function<Edge, Stream<Edge>> getInvalidCrossingEdges() {
        return edge -> {
            Rectangle edgeBounds = edge.bounds();
            Atlas atlas = edge.getAtlas();
            return Iterables.asList((Iterable)atlas.edgesIntersecting((GeometricSurface)edgeBounds, crossingEdge -> edge.getIdentifier() != crossingEdge.getIdentifier() && this.isValidCrossingEdge((AtlasObject)crossingEdge, this.crossingCarNavigable, this.crossingPedestrianNavigable))).stream().filter(crossingEdge -> crossingEdge.getOsmIdentifier() != edge.getOsmIdentifier()).filter(crossingEdge -> !this.getIntersection((Edge)edge, (Edge)crossingEdge).isEmpty());
        };
    }

    private boolean isCrossingHighwayType(Edge edge, boolean carNavigable, boolean pedestrianNavigable) {
        return carNavigable && pedestrianNavigable && (HighwayTag.isCarNavigableHighway((Taggable)edge) || HighwayTag.isPedestrianNavigableHighway((Taggable)edge)) || carNavigable && HighwayTag.isCarNavigableHighway((Taggable)edge) || pedestrianNavigable && HighwayTag.isPedestrianNavigableHighway((Taggable)edge) || !carNavigable && !pedestrianNavigable && !HighwayTag.isCarNavigableHighway((Taggable)edge) && !HighwayTag.isPedestrianNavigableHighway((Taggable)edge);
    }

    private boolean isValidCrossingEdge(AtlasObject object, boolean carNavigable, boolean pedestrianNavigable) {
        Optional highway;
        if (((Edge)object).isMainEdge() && !this.isFlagged(object.getIdentifier()) && object.getTag("area").isEmpty() && !this.indoorMapping.test((Taggable)object) && (highway = HighwayTag.highwayTag((Taggable)object)).isPresent()) {
            HighwayTag highwayTag = (HighwayTag)highway.get();
            return this.isCrossingHighwayType((Edge)object, carNavigable, pedestrianNavigable) && !HighwayTag.CROSSING.equals((Object)highwayTag) && highwayTag.isMoreImportantThanOrEqualTo(this.minimumHighwayType) && highwayTag.isLessImportantThanOrEqualTo(this.maximumHighwayType);
        }
        return false;
    }

    private class EdgeCrossingEdgeWalker
    extends EdgeWalker {
        EdgeCrossingEdgeWalker(Edge startingEdge, Function<Edge, Stream<Edge>> nextCandidates) {
            super(startingEdge, nextCandidates);
        }
    }
}

