/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.intersections;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.checks.validation.intersections.RelationBoundary;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.atlas.items.RelationMemberList;
import org.openstreetmap.atlas.tags.BoundaryTag;
import org.openstreetmap.atlas.tags.RelationTypeTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class BoundaryIntersectionCheck
extends BaseCheck<Long> {
    private static final String DELIMITER = ", ";
    private static final int INDEX = 0;
    private static final String BOUNDARY = "boundary";
    private static final String INVALID_BOUNDARY_FORMAT = "Boundary {0} with way {1} is crossing invalidly with boundary {2} with way {3} at coordinates {4}.";
    private static final String INSTRUCTION_FORMAT = "Boundary {0} with way {1} is crossing invalidly with boundary {2} with way {3} at coordinates {4}. Two boundaries should not intersect each other.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("Boundary {0} with way {1} is crossing invalidly with boundary {2} with way {3} at coordinates {4}. Two boundaries should not intersect each other.", "Boundary {0} with way {1} is crossing invalidly with boundary {2} with way {3} at coordinates {4}.");

    private static boolean isRelationTypeBoundaryWithBoundaryTag(AtlasObject object) {
        return Validators.isOfType((Taggable)object, RelationTypeTag.class, (Enum[])new RelationTypeTag[]{RelationTypeTag.BOUNDARY}) && Validators.hasValuesFor((Taggable)object, (Class[])new Class[]{BoundaryTag.class});
    }

    public BoundaryIntersectionCheck(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Relation && BoundaryIntersectionCheck.isRelationTypeBoundaryWithBoundaryTag(object);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Map<String, Relation> tagToRelation = this.getRelationMap(object);
        RelationBoundary relationBoundary = new RelationBoundary(tagToRelation, this.getBoundaryAtlasEntities((Relation)object));
        HashSet<String> instructions = new HashSet<String>();
        HashSet<AtlasObject> objectsToFlag = new HashSet<AtlasObject>();
        HashSet<String> matchedTags = new HashSet<String>();
        Atlas atlas = object.getAtlas();
        for (AtlasEntity atlasEntity : relationBoundary.getAtlasEntities()) {
            Iterable lineItemsIntersecting = atlas.lineItemsIntersecting((GeometricSurface)atlasEntity.bounds(), this.getPredicateForLineItemSelection(atlasEntity, relationBoundary.getTagToRelation().keySet()));
            Iterable areasIntersecting = atlas.areasIntersecting((GeometricSurface)atlasEntity.bounds(), this.getPredicateForAreaSelection(atlasEntity, relationBoundary.getTagToRelation().keySet()));
            HashSet<String> currentMatchedTags = new HashSet<String>();
            matchedTags.addAll(this.processLineItems(relationBoundary, instructions, objectsToFlag, atlasEntity, lineItemsIntersecting, currentMatchedTags));
            matchedTags.addAll(this.processAreas(relationBoundary, instructions, objectsToFlag, atlasEntity, areasIntersecting, currentMatchedTags));
            objectsToFlag.addAll(relationBoundary.getRelationsByBoundaryTags(matchedTags));
            objectsToFlag.add((AtlasObject)atlasEntity);
        }
        if (instructions.isEmpty()) {
            return Optional.empty();
        }
        CheckFlag checkFlag = new CheckFlag(this.getTaskIdentifier(object));
        instructions.forEach(checkFlag::addInstruction);
        checkFlag.addObjects(objectsToFlag);
        return Optional.of(checkFlag);
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean checkAtlasEntityAsBoundary(AtlasEntity atlasEntity, Set<String> boundaryTags) {
        return atlasEntity.relations().stream().anyMatch(relationToCheck -> BoundaryIntersectionCheck.isRelationTypeBoundaryWithBoundaryTag((AtlasObject)relationToCheck) && boundaryTags.contains(relationToCheck.getTag(BOUNDARY).orElse(""))) || boundaryTags.contains(atlasEntity.getTag(BOUNDARY).orElse(""));
    }

    private String coordinatesToList(Coordinate[] locations) {
        return Stream.of(locations).map(coordinate -> String.format("(%s, %s)", coordinate.getX(), coordinate.getY())).collect(Collectors.joining(DELIMITER));
    }

    private String createInstruction(AtlasEntity atlasEntity, long osmIdentifier, Coordinate[] intersectingPoints, String firstBoundaries, String secondBoundaries) {
        return this.getLocalizedInstruction(0, firstBoundaries, Long.toString(atlasEntity.getOsmIdentifier()), secondBoundaries, Long.toString(osmIdentifier), this.coordinatesToList(intersectingPoints));
    }

    private String entityIdsToString(Set<? extends AtlasEntity> entities) {
        return entities.stream().map(entity -> Long.toString(entity.getOsmIdentifier())).collect(Collectors.joining(DELIMITER));
    }

    private Set<AtlasEntity> getBoundaryAtlasEntities(Relation relation) {
        RelationMemberList relationMemberLineItems = relation.membersOfType(new ItemType[]{ItemType.EDGE, ItemType.LINE, ItemType.AREA});
        return relationMemberLineItems.stream().map(RelationMember::getEntity).collect(Collectors.toSet());
    }

    private Geometry getGeometryForIntersection(String wkt) throws ParseException {
        WKTReader wktReader = new WKTReader();
        Geometry geometry1 = wktReader.read(wkt);
        if (geometry1.getGeometryType().equals("Polygon")) {
            geometry1 = geometry1.getBoundary();
        }
        return geometry1;
    }

    private Coordinate[] getIntersectionPoints(String wktFirst, String wktSecond) {
        try {
            Geometry geometry1 = this.getGeometryForIntersection(wktFirst);
            Geometry geometry2 = this.getGeometryForIntersection(wktSecond);
            return geometry1.intersection(geometry2).getCoordinates();
        }
        catch (ParseException e) {
            throw new IllegalStateException(e);
        }
    }

    private Set<Relation> getMatchingBoundaries(RelationBoundary relationBoundary, AtlasEntity atlasEntity) {
        return atlasEntity.relations().stream().filter(boundary -> relationBoundary.getTagToRelation().containsKey(boundary.getTag(BOUNDARY).orElse(""))).filter(boundary -> !relationBoundary.containsRelationId(boundary.getOsmIdentifier())).collect(Collectors.toSet());
    }

    private Predicate<Area> getPredicateForAreaSelection(AtlasEntity atlasEntity, Set<String> boundaryTags) {
        return areaToCheck -> {
            if (this.checkAtlasEntityAsBoundary((AtlasEntity)areaToCheck, boundaryTags)) {
                return this.isCrossingNotTouching(atlasEntity.toWkt(), areaToCheck.toWkt());
            }
            return false;
        };
    }

    private Predicate<LineItem> getPredicateForLineItemSelection(AtlasEntity atlasEntity, Set<String> boundaryTags) {
        return lineToCheck -> {
            if (this.checkAtlasEntityAsBoundary((AtlasEntity)lineToCheck, boundaryTags)) {
                return this.isCrossingNotTouching(atlasEntity.toWkt(), lineToCheck.toWkt());
            }
            return false;
        };
    }

    private Map<String, Relation> getRelationMap(AtlasObject atlasObject) {
        HashMap<String, Relation> tagToRelation = new HashMap<String, Relation>();
        atlasObject.getTag(BOUNDARY).ifPresent(boundary -> tagToRelation.put((String)boundary, (Relation)atlasObject));
        return tagToRelation;
    }

    private void handleIntersections(RelationBoundary relationBoundary, Set<String> instructions, AtlasEntity currentEntity, Set<String> currentMatchedTags, Set<Relation> matchingBoundaries, String areaWkt, long osmIdentifier) {
        Coordinate[] intersectingPoints = this.getIntersectionPoints(currentEntity.toWkt(), areaWkt);
        String firstBoundaries = this.entityIdsToString(relationBoundary.getRelationsByBoundaryTags(currentMatchedTags));
        String secondBoundaries = this.entityIdsToString(matchingBoundaries);
        if (intersectingPoints.length != 0 && firstBoundaries.hashCode() < secondBoundaries.hashCode()) {
            instructions.add(this.createInstruction(currentEntity, osmIdentifier, intersectingPoints, firstBoundaries, secondBoundaries));
        }
    }

    private boolean isAnyGeometryInvalid(Geometry geometry1, Geometry geometry2) {
        return !geometry1.isValid() || !geometry1.isSimple() || !geometry2.isValid() || !geometry2.isSimple();
    }

    private boolean isCrossingNotTouching(String wktFirst, String wktSecond) {
        WKTReader wktReader = new WKTReader();
        try {
            Geometry geometry1 = wktReader.read(wktFirst);
            Geometry geometry2 = wktReader.read(wktSecond);
            if (geometry1.equals(geometry2)) {
                return false;
            }
            if (this.isAnyGeometryInvalid(geometry1, geometry2)) {
                return false;
            }
            return this.isIntersectingNotTouching(geometry1, geometry2);
        }
        catch (ParseException e) {
            return false;
        }
    }

    private boolean isGeometryPairOfLineType(Geometry geometry1, Geometry geometry2) {
        return geometry1.getGeometryType().equals("LineString") && geometry2.getGeometryType().equals("LineString");
    }

    private boolean isIntersectingNotTouching(Geometry geometry1, Geometry geometry2) {
        return geometry1.intersects(geometry2) && (geometry1.crosses(geometry2) || geometry1.overlaps(geometry2) && !this.isGeometryPairOfLineType(geometry1, geometry2));
    }

    private Set<String> processAreas(RelationBoundary relationBoundary, Set<String> instructions, Set<AtlasObject> objectsToFlag, AtlasEntity atlasEntity, Iterable<Area> areasIntersecting, Set<String> currentMatchedTags) {
        HashSet<String> matchedTags = new HashSet<String>();
        areasIntersecting.forEach(area -> {
            Set<Relation> matchingBoundaries = this.getMatchingBoundaries(relationBoundary, (AtlasEntity)area);
            if (!matchingBoundaries.isEmpty()) {
                currentMatchedTags.addAll(matchingBoundaries.stream().map(relation -> relation.getTag(BOUNDARY)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet()));
                objectsToFlag.addAll(matchingBoundaries);
                this.handleIntersections(relationBoundary, instructions, atlasEntity, currentMatchedTags, matchingBoundaries, area.toWkt(), area.getOsmIdentifier());
            }
            matchedTags.addAll(currentMatchedTags);
        });
        return matchedTags;
    }

    private Set<String> processLineItems(RelationBoundary relationBoundary, Set<String> instructions, Set<AtlasObject> objectsToFlag, AtlasEntity atlasEntity, Iterable<LineItem> lineItemsIntersecting, Set<String> currentMatchedTags) {
        HashSet<String> matchedTags = new HashSet<String>();
        lineItemsIntersecting.forEach(lineItem -> {
            Set<Relation> matchingBoundaries = this.getMatchingBoundaries(relationBoundary, (AtlasEntity)lineItem);
            if (!matchingBoundaries.isEmpty()) {
                currentMatchedTags.addAll(matchingBoundaries.stream().map(relation -> relation.getTag(BOUNDARY)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet()));
                objectsToFlag.addAll(matchingBoundaries);
                objectsToFlag.add((AtlasObject)lineItem);
                this.handleIntersections(relationBoundary, instructions, atlasEntity, currentMatchedTags, matchingBoundaries, lineItem.toWkt(), lineItem.getOsmIdentifier());
            }
            matchedTags.addAll(currentMatchedTags);
        });
        return matchedTags;
    }
}

