/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.areas;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.checks.utility.IntersectionUtilities;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.Segment;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.filters.TaggableFilter;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class WaterAreaCheck
extends BaseCheck<Long> {
    private static final long serialVersionUID = -2567398383133412329L;
    private static final List<String> WATER_FILTERS = Arrays.asList("natural->water&water->*|waterway->riverbank");
    private static final List<String> WATER_FILTERS_WATERWAY = Arrays.asList("natural->water&water->river,stream_pool,canal,lock|waterway->riverbank");
    private static final List<String> WATERWAY_FILTERS = Arrays.asList("waterway->*");
    private static final List<String> WATERWAY_CROSSING_IGNORE = Arrays.asList("waterway->dam");
    private static final String INSTRUCTION_MISSING_WATERWAY = "Waterway area (id={0,number,#}) is missing a waterway way.";
    private static final String INSTRUCTION_NO_EXITING_WATERWAY = "Waterway area (id={0,number,#}) has a waterway way, but there are none entering/exiting.";
    private static final String INSTRUCTION_WATERWAY_INTERSECTION = "Waterway area (id={0,number,#}) intersects with at least one other waterway area (id={1}).";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("Waterway area (id={0,number,#}) is missing a waterway way.", "Waterway area (id={0,number,#}) has a waterway way, but there are none entering/exiting.", "Waterway area (id={0,number,#}) intersects with at least one other waterway area (id={1}).");
    private static final double MINIMUM_PROPORTION_DEFAULT = 0.01;
    private final double minimumIntersect;
    private final List<TaggableFilter> areaFilters = new ArrayList<TaggableFilter>();
    private final List<TaggableFilter> waterRequiringWaterwayFilters = new ArrayList<TaggableFilter>();
    private final List<TaggableFilter> waterwayFilters = new ArrayList<TaggableFilter>();
    private final List<TaggableFilter> waterwayCrossingIgnore = new ArrayList<TaggableFilter>();

    public static boolean matchesFilter(List<TaggableFilter> filters, AtlasObject object) {
        return filters.parallelStream().anyMatch(filter -> filter.test((Taggable)object));
    }

    public static boolean matchesSameFilter(List<TaggableFilter> filters, AtlasObject object1, AtlasObject object2) {
        return filters.parallelStream().anyMatch(filter -> filter.test((Taggable)object1) && filter.test((Taggable)object2));
    }

    public WaterAreaCheck(Configuration configuration) {
        super(configuration);
        this.minimumIntersect = this.configurationValue(configuration, "intersect.minimum.limit", 0.01);
        List<String> filtersString = this.configurationValue(configuration, "water.tags.filters", WATER_FILTERS);
        filtersString.forEach(string -> this.areaFilters.add(TaggableFilter.forDefinition((String)string)));
        filtersString = this.configurationValue(configuration, "waterway.tags.filters", WATERWAY_FILTERS);
        filtersString.forEach(string -> this.waterwayFilters.add(TaggableFilter.forDefinition((String)string)));
        filtersString = this.configurationValue(configuration, "water.tags.filtersrequireswaterway", WATER_FILTERS_WATERWAY);
        filtersString.forEach(string -> this.waterRequiringWaterwayFilters.add(TaggableFilter.forDefinition((String)string)));
        filtersString = this.configurationValue(configuration, "water.tags.crossing.ignore", WATERWAY_CROSSING_IGNORE);
        filtersString.forEach(string -> this.waterwayCrossingIgnore.add(TaggableFilter.forDefinition((String)string)));
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Area && !this.isFlagged(object.getOsmIdentifier()) && WaterAreaCheck.matchesFilter(this.areaFilters, object);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Area area = (Area)object;
        Polygon areaPolygon = area.getClosedGeometry();
        List waterways = Iterables.stream((Iterable)area.getAtlas().linesIntersecting((GeometricSurface)areaPolygon, atlasObject -> WaterAreaCheck.matchesFilter(this.waterwayFilters, (AtlasObject)atlasObject))).collectToList();
        CheckFlag flag = this.checkForMissingWaterway(null, area, waterways);
        flag = this.checkForNoExitingWays(flag, areaPolygon, area, waterways);
        if ((flag = this.checkForOverlappingWaterways(flag, area)) != null) {
            super.markAsFlagged(object.getOsmIdentifier());
        }
        return Optional.ofNullable(flag);
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean alreadyFlagged(List<? extends AtlasObject> objects) {
        return this.getFlaggedIdentifiers().containsAll(objects.parallelStream().map(AtlasObject::getOsmIdentifier).collect(Collectors.toList()));
    }

    private CheckFlag checkForMissingWaterway(CheckFlag flag, Area area, List<Line> waterways) {
        CheckFlag returnFlag = flag;
        if (waterways.isEmpty() && WaterAreaCheck.matchesFilter(this.waterRequiringWaterwayFilters, (AtlasObject)area)) {
            if (returnFlag == null) {
                returnFlag = new CheckFlag(this.getTaskIdentifier((AtlasObject)area));
            }
            returnFlag.addInstruction(this.getLocalizedInstruction(FALLBACK_INSTRUCTIONS.indexOf(INSTRUCTION_MISSING_WATERWAY), area.getOsmIdentifier()));
            returnFlag.addObject((AtlasObject)area);
        }
        return returnFlag;
    }

    private CheckFlag checkForNoExitingWays(CheckFlag flag, Polygon areaPolygon, Area area, List<Line> waterways) {
        List areaSegments;
        CheckFlag returnFlag = flag;
        if (!waterways.isEmpty() && (areaSegments = areaPolygon.segments().stream().filter(segment -> waterways.parallelStream().map(LineItem::asPolyLine).anyMatch(arg_0 -> ((Segment)segment).intersects(arg_0))).collect(Collectors.toList())).isEmpty()) {
            if (returnFlag == null) {
                returnFlag = new CheckFlag(this.getTaskIdentifier((AtlasObject)area));
            }
            if (returnFlag.getFlaggedObjects().isEmpty()) {
                returnFlag.addObject((AtlasObject)area);
            }
            returnFlag.addInstruction(this.getLocalizedInstruction(FALLBACK_INSTRUCTIONS.indexOf(INSTRUCTION_NO_EXITING_WATERWAY), area.getOsmIdentifier()));
        }
        return returnFlag;
    }

    private CheckFlag checkForOverlappingWaterways(CheckFlag flag, Area area) {
        List<Area> areaOverlaps;
        CheckFlag returnFlag = flag;
        List possibleAreaIntersections = area.getClosedGeometry().segments().stream().map(segment -> Pair.of((Object)segment, (Object)Iterables.stream((Iterable)area.getAtlas().areasIntersecting((GeometricSurface)segment.bounds(), atlasObject -> WaterAreaCheck.matchesFilter(this.areaFilters, (AtlasObject)atlasObject) && !area.equals(atlasObject) && area.getClosedGeometry().intersects((PolyLine)atlasObject.getClosedGeometry()))).collectToList())).filter(pair -> !((List)pair.getRight()).isEmpty()).collect(Collectors.toList());
        List<Area> areaIntersections = possibleAreaIntersections.stream().flatMap(pair -> ((List)pair.getRight()).stream()).distinct().filter(tArea -> !this.intersections((PolyLine)area.getClosedGeometry(), (PolyLine)tArea.getClosedGeometry()).isEmpty()).filter(tArea -> WaterAreaCheck.matchesFilter(this.waterwayCrossingIgnore, (AtlasObject)tArea) && WaterAreaCheck.matchesFilter(this.waterwayCrossingIgnore, (AtlasObject)area) || !WaterAreaCheck.matchesFilter(this.waterwayCrossingIgnore, (AtlasObject)tArea) && !WaterAreaCheck.matchesFilter(this.waterwayCrossingIgnore, (AtlasObject)area)).collect(Collectors.toList());
        if (!areaIntersections.isEmpty() && !this.alreadyFlagged(areaIntersections)) {
            if (returnFlag == null) {
                returnFlag = new CheckFlag(this.getTaskIdentifier((AtlasObject)area));
            }
            if (returnFlag.getFlaggedObjects().isEmpty()) {
                returnFlag.addObject((AtlasObject)area);
            }
            returnFlag.addPoints(possibleAreaIntersections.stream().filter(pair -> !this.alreadyFlagged((List)pair.getRight())).map(Pair::getLeft).map(Segment::middle).collect(Collectors.toList()));
            returnFlag.addInstruction(this.getLocalizedInstruction(FALLBACK_INSTRUCTIONS.indexOf(INSTRUCTION_WATERWAY_INTERSECTION), area.getOsmIdentifier(), areaIntersections.stream().map(AtlasObject::getOsmIdentifier).distinct().map(Objects::toString).collect(Collectors.joining(", "))));
            areaIntersections.forEach(returnFlag::addObject);
            areaIntersections.stream().map(AtlasObject::getOsmIdentifier).forEach(x$0 -> super.markAsFlagged(x$0));
        }
        if (!(areaOverlaps = possibleAreaIntersections.stream().flatMap(pair -> ((List)pair.getRight()).stream()).distinct().filter(tArea -> IntersectionUtilities.findIntersectionPercentage(tArea.getClosedGeometry(), area.getClosedGeometry()) >= this.minimumIntersect).collect(Collectors.toList())).isEmpty()) {
            if (returnFlag == null) {
                returnFlag = new CheckFlag(this.getTaskIdentifier((AtlasObject)area));
            }
            if (returnFlag.getFlaggedObjects().isEmpty()) {
                returnFlag.addObject((AtlasObject)area);
            }
            returnFlag.addInstruction(this.getLocalizedInstruction(FALLBACK_INSTRUCTIONS.indexOf(INSTRUCTION_WATERWAY_INTERSECTION), area.getOsmIdentifier(), areaOverlaps.stream().map(AtlasObject::getOsmIdentifier).distinct().map(Objects::toString).collect(Collectors.joining(", "))));
            areaOverlaps.forEach(returnFlag::addObject);
        }
        return returnFlag;
    }

    private Set<Location> intersections(PolyLine line1, PolyLine line2) {
        if (line1.intersects(line2)) {
            Set intersections = line1.intersections(line2);
            intersections.removeIf(intersection -> line1.contains(intersection) && line2.contains(intersection));
            if (!intersections.isEmpty()) {
                return intersections;
            }
        }
        return Collections.emptySet();
    }
}

