/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.utility.feature_change;

import java.util.Collection;
import java.util.function.BiFunction;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;

public interface IFeatureChange {
    public static FeatureChange createFeatureChange(BiFunction<AtlasEntity, Atlas, FeatureChange> changeCreator, AtlasEntity object, Collection<IFeatureChange> changes) {
        CompleteEntity completeEntity = (CompleteEntity)CompleteEntity.shallowFrom((AtlasEntity)object);
        if (changes.stream().anyMatch(TaggedChange.class::isInstance)) {
            completeEntity = completeEntity.withTags(object.getTags());
        }
        if (object instanceof Iterable) {
            if (changes.stream().anyMatch(GeometryChange.class::isInstance)) {
                boolean addGeometry = true;
                for (Object iterable : (Iterable)object) {
                    if (iterable instanceof Location) continue;
                    addGeometry = false;
                    break;
                }
                if (addGeometry) {
                    completeEntity = completeEntity.withGeometry((Iterable)object);
                }
            }
        }
        for (IFeatureChange change : changes) {
            completeEntity = change.apply(completeEntity);
        }
        return changeCreator.apply((AtlasEntity)completeEntity, object.getAtlas());
    }

    public <T extends CompleteEntity<T>> CompleteEntity<T> apply(CompleteEntity<T> var1);

    public static interface TaggedChange {
    }

    public static interface GeometryChange {
    }
}

