/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.utility;

import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import org.openstreetmap.atlas.checks.event.CheckFlagEvent;
import org.openstreetmap.atlas.checks.flag.CheckFlag;

public class UniqueCheckFlagContainer
implements Serializable {
    private String checkName;
    private Set<String> uniqueIdentifiers;
    private CheckFlag checkFlag;

    public UniqueCheckFlagContainer(CheckFlagEvent checkFlagEvent) {
        this(checkFlagEvent.getCheckName(), checkFlagEvent.getCheckFlag().getUniqueIdentifiers(), checkFlagEvent.getCheckFlag().makeComplete());
    }

    public UniqueCheckFlagContainer(String checkName, Set<String> uniqueIdentifiers, CheckFlag checkFlag) {
        this.checkName = checkName;
        this.uniqueIdentifiers = uniqueIdentifiers;
        this.checkFlag = checkFlag.makeComplete();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        UniqueCheckFlagContainer that = (UniqueCheckFlagContainer)other;
        return Objects.equals(this.checkName, that.checkName) && Objects.equals(this.uniqueIdentifiers, that.uniqueIdentifiers);
    }

    public CheckFlag getCheckFlag() {
        return this.checkFlag;
    }

    public String getCheckName() {
        return this.checkName;
    }

    public CheckFlagEvent getEvent() {
        return new CheckFlagEvent(this.checkName, this.checkFlag);
    }

    public Set<String> getUniqueIdentifiers() {
        return this.uniqueIdentifiers;
    }

    public int hashCode() {
        return Objects.hash(this.checkName, this.uniqueIdentifiers);
    }
}

