/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.utility;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.openstreetmap.atlas.checks.base.ExternalDataFetcher;
import org.openstreetmap.atlas.generator.tools.filesystem.FileSystemHelper;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.guava.cache.CacheBuilder;
import org.sparkproject.guava.cache.CacheLoader;
import org.sparkproject.guava.cache.LoadingCache;

public class SQLiteUtils
implements Serializable {
    private static final long serialVersionUID = 3796921068577020645L;
    private final String database;
    private final String defaultTable;
    private final ExternalDataFetcher fileFetcher;
    private transient LoadingCache<String, Map<String, Object>> cachedMap;
    private transient Connection connection;
    public static final String MEMORY_DB = ":memory:";
    private static Logger logger = LoggerFactory.getLogger(SQLiteUtils.class);
    private static final int DEFAULT_CACHE_MAX = 1000;

    public static boolean isValidDatabase(String database) {
        return database != null && (database.startsWith(MEMORY_DB) || !database.isBlank() && FileSystemHelper.exists((String)database));
    }

    private static String sqlSanitize(String string, char quote) {
        int baseLength = string.length();
        StringBuilder stringBuilder = new StringBuilder(baseLength);
        for (int index = 0; index < baseLength; ++index) {
            char current = string.charAt(index);
            if (quote == current) {
                stringBuilder.append(quote);
            }
            stringBuilder.append(current);
        }
        return stringBuilder.toString();
    }

    public SQLiteUtils(ExternalDataFetcher fileFetcher, String database, String table) {
        this.fileFetcher = fileFetcher;
        this.database = database;
        this.defaultTable = table;
    }

    public void clear() {
        if (this.cachedMap != null) {
            this.cachedMap.cleanUp();
            this.cachedMap = null;
        }
    }

    public String getFile() {
        if (this.database != null && this.database.startsWith(MEMORY_DB)) {
            return this.database;
        }
        Optional<Resource> wikiDataResource = this.fileFetcher.apply(this.database);
        if (wikiDataResource.isPresent() && wikiDataResource.get() instanceof File) {
            return ((File)wikiDataResource.get()).getPathString();
        }
        return null;
    }

    public Map<String, Object> getRows(Map<String, String> values) {
        StringBuilder statement = new StringBuilder("SELECT * FROM ").append(this.defaultTable);
        if (!values.isEmpty()) {
            statement.append(" WHERE ");
        }
        String and = " AND ";
        for (Map.Entry<String, String> entry : values.entrySet()) {
            statement.append(entry.getKey()).append(" = '").append(SQLiteUtils.sqlSanitize(entry.getValue(), '\'')).append('\'').append(" AND ");
        }
        String builtStatement = statement.substring(0, statement.length() > " AND ".length() ? statement.length() - " AND ".length() : statement.length());
        if (this.cachedMap == null) {
            this.cachedMap = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Map<String, Object>>(){

                public Map<String, Object> load(String statement) throws Exception {
                    return SQLiteUtils.this.getRowsReal(statement);
                }
            });
        }
        try {
            return (Map)this.cachedMap.get((Object)builtStatement);
        }
        catch (ExecutionException e) {
            logger.error("Failed to get row for " + statement, (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private Connection getConnection() throws SQLException {
        if (this.connection == null) {
            Properties properties = new Properties();
            properties.setProperty("open_mode", "1");
            this.connection = DriverManager.getConnection(MessageFormat.format("jdbc:sqlite:{0}", this.getFile()), properties);
            this.connection.setReadOnly(true);
        }
        return this.connection;
    }

    private Map<String, Object> getRowsReal(String statement) {
        try {
            Connection currentConnection = this.getConnection();
            HashMap<String, Object> queryResultMap = new HashMap<String, Object>();
            try (Statement databaseStatement = currentConnection.createStatement();
                 ResultSet results = databaseStatement.executeQuery(statement);){
                if (results.next()) {
                    ResultSetMetaData metaData = results.getMetaData();
                    for (int index = 1; index <= metaData.getColumnCount(); ++index) {
                        queryResultMap.put(metaData.getColumnLabel(index), results.getObject(index));
                    }
                }
            }
            queryResultMap.entrySet().removeIf(e -> e.getValue() == null);
            return queryResultMap;
        }
        catch (SQLException e2) {
            logger.error("Bad connection", (Throwable)e2);
            return Collections.emptyMap();
        }
    }
}

