/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.utility;

import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.openstreetmap.atlas.checks.utility.KeyFullyChecked;
import org.openstreetmap.atlas.checks.validation.tag.InvalidTagsCheck;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.tags.filters.TaggableFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KeyFullyCheckedUtils {
    private static final Logger logger = LoggerFactory.getLogger(KeyFullyCheckedUtils.class);

    public static Collection<Predicate<Taggable>> populateIgnoreTags() {
        Object classInfoList;
        ArrayList<TaggableFilter> filters = new ArrayList<TaggableFilter>();
        ArrayList<Predicate<Taggable>> predicateFilters = new ArrayList<Predicate<Taggable>>();
        ClassLoader classLoader = InvalidTagsCheck.class.getClassLoader();
        try {
            classInfoList = ClassPath.from((ClassLoader)classLoader).getTopLevelClassesRecursive(InvalidTagsCheck.class.getPackageName());
        }
        catch (IOException exception) {
            logger.error(exception.getMessage(), (Throwable)exception);
            classInfoList = Collections.emptySet();
        }
        for (ClassPath.ClassInfo info : classInfoList) {
            Field[] fields;
            Class clazz = info.load();
            for (Field field : fields = FieldUtils.getFieldsWithAnnotation((Class)clazz, KeyFullyChecked.class)) {
                KeyFullyCheckedUtils.getTagFromField(clazz, field, filters, predicateFilters);
            }
        }
        filters.forEach(filter -> predicateFilters.add(arg_0 -> ((TaggableFilter)filter).test(arg_0)));
        return predicateFilters;
    }

    private static void getTagFromField(Class<?> clazz, Field field, List<TaggableFilter> filters, List<Predicate<Taggable>> predicateFilters) {
        Object fieldObject;
        KeyFullyChecked annotation = field.getAnnotation(KeyFullyChecked.class);
        try {
            field.trySetAccessible();
            fieldObject = field.get(clazz);
            if (fieldObject == null) {
                throw new IllegalArgumentException(MessageFormat.format("@KeyFullyChecked fields must be initialized in a static manner ({0}: {1})", clazz.getSimpleName(), field.getName()));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e1) {
            logger.error(e1.getMessage(), (Throwable)e1);
            return;
        }
        if (KeyFullyChecked.Type.TAGGABLE_FILTER == annotation.value()) {
            KeyFullyCheckedUtils.getTagFromFieldTaggable(field, fieldObject, filters, predicateFilters);
        } else if (KeyFullyChecked.Type.TAG_KEY == annotation.value()) {
            if (fieldObject instanceof Class) {
                predicateFilters.add(Validators.hasValuesFor((Class[])new Class[]{(Class)fieldObject}));
            } else {
                predicateFilters.add(Validators.hasValuesFor((Class[])new Class[]{fieldObject.getClass()}));
            }
        } else if (KeyFullyChecked.Type.PARTIAL == annotation.value()) {
            String value = fieldObject.toString();
            predicateFilters.add(taggable -> taggable.getTags().entrySet().parallelStream().anyMatch(e -> ((String)e.getKey()).contains(value)));
        } else if (logger.isErrorEnabled()) {
            logger.error(MessageFormat.format("We don''t currently handle {0}", new Object[]{annotation.value()}));
        }
    }

    private static void getTagFromFieldTaggable(Field field, Object fieldObject, List<TaggableFilter> filters, List<Predicate<Taggable>> predicateFilters) {
        Type[] parameters;
        Type type;
        if (fieldObject instanceof TaggableFilter) {
            filters.add((TaggableFilter)fieldObject);
        } else if (fieldObject instanceof String) {
            filters.add(TaggableFilter.forDefinition((String)((String)fieldObject)));
        } else if (fieldObject instanceof Predicate && (type = field.getGenericType()) instanceof ParameterizedType && (parameters = ((ParameterizedType)type).getActualTypeArguments()).length == 1 && Taggable.class.equals((Object)parameters[0])) {
            Predicate filter = (Predicate)fieldObject;
            predicateFilters.add(filter);
        }
    }

    private KeyFullyCheckedUtils() {
    }
}

