/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.utility;

import java.util.EnumMap;
import javax.annotation.Nullable;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;

public final class AtlasToOsmType {
    private static final EnumMap<ItemType, String> ATLAS_TO_OSM_TYPE = new EnumMap(ItemType.class);

    @Nullable
    public static String convert(ItemType itemType) {
        return ATLAS_TO_OSM_TYPE.getOrDefault(itemType, null);
    }

    private AtlasToOsmType() {
    }

    static {
        ATLAS_TO_OSM_TYPE.put(ItemType.EDGE, "way");
        ATLAS_TO_OSM_TYPE.put(ItemType.AREA, "way");
        ATLAS_TO_OSM_TYPE.put(ItemType.LINE, "way");
        ATLAS_TO_OSM_TYPE.put(ItemType.NODE, "node");
        ATLAS_TO_OSM_TYPE.put(ItemType.POINT, "node");
        ATLAS_TO_OSM_TYPE.put(ItemType.RELATION, "relation");
    }
}

