/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.maproulette.data.cooperative_challenge;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.function.Predicate;
import org.openstreetmap.atlas.checks.maproulette.data.cooperative_challenge.CooperativeChallengeOperation;
import org.openstreetmap.atlas.geography.atlas.change.description.ChangeDescription;
import org.openstreetmap.atlas.geography.atlas.change.description.ChangeDescriptorType;
import org.openstreetmap.atlas.geography.atlas.change.description.descriptors.ChangeDescriptor;
import org.openstreetmap.atlas.geography.atlas.change.description.descriptors.ChangeDescriptorName;
import org.openstreetmap.atlas.geography.atlas.change.description.descriptors.TagChangeDescriptor;

public class TagChangeOperation
extends CooperativeChallengeOperation {
    private static final String UNSET_TAGS = "unsetTags";
    private static final String SET_TAGS = "setTags";

    public TagChangeOperation(ChangeDescription changeDescription) {
        super(changeDescription);
    }

    @Override
    public TagChangeOperation create() {
        JsonObject json = new JsonObject();
        JsonObject data = new JsonObject();
        data.add("id", (JsonElement)new JsonPrimitive(this.getIdentifier()));
        JsonArray operationsArray = new JsonArray();
        this.getChangeDescriptorList().forEach(changeDescriptor -> {
            JsonObject nestedOperation = new JsonObject();
            String action = this.convertChangeDescriptorType(changeDescriptor.getChangeDescriptorType());
            nestedOperation.add("operation", (JsonElement)new JsonPrimitive(action));
            if (UNSET_TAGS.equals(action)) {
                JsonArray tagChanges = new JsonArray();
                tagChanges.add((JsonElement)new JsonPrimitive(((TagChangeDescriptor)changeDescriptor).getKey()));
                nestedOperation.add("data", (JsonElement)tagChanges);
            } else if (SET_TAGS.equals(action)) {
                JsonObject tagChanges = new JsonObject();
                tagChanges.add(((TagChangeDescriptor)changeDescriptor).getKey(), (JsonElement)new JsonPrimitive(((TagChangeDescriptor)changeDescriptor).getValue()));
                nestedOperation.add("data", (JsonElement)tagChanges);
            }
            operationsArray.add((JsonElement)nestedOperation);
        });
        data.add("operations", (JsonElement)operationsArray);
        json.add("operationType", (JsonElement)new JsonPrimitive(this.convertAction(this.getOperationType())));
        json.add("data", (JsonElement)data);
        this.setJson(json);
        return this;
    }

    @Override
    protected Predicate<ChangeDescriptor> operationFilter() {
        return changeDescriptor -> changeDescriptor.getName().equals((Object)ChangeDescriptorName.TAG);
    }

    private String convertAction(ChangeDescriptorType descriptorType) {
        if (descriptorType.equals((Object)ChangeDescriptorType.ADD) || descriptorType.equals((Object)ChangeDescriptorType.UPDATE)) {
            return "modifyElement";
        }
        if (descriptorType.equals((Object)ChangeDescriptorType.REMOVE)) {
            return "removeElement";
        }
        return "";
    }

    private String convertChangeDescriptorType(ChangeDescriptorType descriptorType) {
        if (descriptorType.equals((Object)ChangeDescriptorType.UPDATE) || descriptorType.equals((Object)ChangeDescriptorType.ADD)) {
            return SET_TAGS;
        }
        if (descriptorType.equals((Object)ChangeDescriptorType.REMOVE)) {
            return UNSET_TAGS;
        }
        return "";
    }
}

