/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.maproulette.data.cooperative_challenge;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.openstreetmap.atlas.checks.maproulette.data.cooperative_challenge.CooperativeChallengeOperation;
import org.openstreetmap.atlas.geography.atlas.change.description.ChangeDescription;
import org.openstreetmap.atlas.geography.atlas.change.description.descriptors.ChangeDescriptor;
import org.openstreetmap.atlas.geography.atlas.change.description.descriptors.ChangeDescriptorName;

public class GeometryChangeOperation
extends CooperativeChallengeOperation {
    private static final String CONTENT = "content";
    private static final Map<String, String> FILE_MAP = new HashMap<String, String>(3);
    private final String osc;

    public GeometryChangeOperation(ChangeDescription changeDescription) {
        super(changeDescription);
        Optional optionalOsc = changeDescription.getOsc();
        this.osc = optionalOsc.isPresent() ? (String)optionalOsc.get() : (changeDescription.toJsonElement().getAsJsonObject().has("osc") ? changeDescription.toJsonElement().getAsJsonObject().get("osc").getAsString() : null);
    }

    @Override
    public GeometryChangeOperation create() {
        JsonObject json = new JsonObject();
        if (this.osc != null && !this.osc.isBlank()) {
            FILE_MAP.forEach((key, value) -> json.add(key, (JsonElement)new JsonPrimitive(value)));
            json.add(CONTENT, (JsonElement)new JsonPrimitive(this.osc));
        }
        this.setJson(json);
        return this;
    }

    @Override
    protected Predicate<ChangeDescriptor> operationFilter() {
        return changeDescriptor -> changeDescriptor.getName() == ChangeDescriptorName.GEOMETRY;
    }

    static {
        FILE_MAP.put("type", "xml");
        FILE_MAP.put("format", "osc");
        FILE_MAP.put("encoding", "base64");
    }
}

