/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.maproulette.data.cooperative_challenge;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.maproulette.data.cooperative_challenge.GeometryChangeOperation;
import org.openstreetmap.atlas.checks.maproulette.data.cooperative_challenge.TagChangeOperation;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.change.description.ChangeDescription;
import org.openstreetmap.atlas.geography.atlas.change.description.ChangeDescriptorType;
import org.openstreetmap.atlas.geography.atlas.change.description.descriptors.ChangeDescriptor;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;

public abstract class CooperativeChallengeOperation {
    private final ChangeDescriptorType operationType;
    private final String identifier;
    private final List<ChangeDescriptor> changeDescriptorList;
    private JsonObject json;
    protected static final String OPERATION_TYPE_KEY = "operationType";
    protected static final String DATA_KEY = "data";
    protected static final String ID_KEY = "id";
    protected static final String OPERATIONS_KEY = "operations";
    protected static final String OPERATION_KEY = "operation";
    private static final String DELIMITER = "/";
    private static final int ATLAS_SECTIONING_IDENTIFIER_LENGTH = 6;

    public static Class<? extends CooperativeChallengeOperation> getAppropriateChangeOperation(ChangeDescription changeDescription) {
        block4: for (ChangeDescriptor changeDescriptor : changeDescription.getChangeDescriptors()) {
            switch (changeDescriptor.getName()) {
                case GEOMETRY: {
                    return GeometryChangeOperation.class;
                }
                case TAG: {
                    continue block4;
                }
            }
            throw new CoreException("No cooperative challenge converter is available for {0}", new Object[]{changeDescriptor.getName()});
        }
        return changeDescription.getOsc().isPresent() ? GeometryChangeOperation.class : TagChangeOperation.class;
    }

    private static String extractOSMObjectFromItemType(ItemType itemType) {
        if ("RELATION".equals(itemType.name())) {
            return "relation";
        }
        if ("NODE".equals(itemType.name()) || "POINT".equals(itemType.name())) {
            return "node";
        }
        return "way";
    }

    protected CooperativeChallengeOperation(ChangeDescription changeDescription) {
        this.operationType = changeDescription.getChangeDescriptorType();
        String rawId = Long.toString(changeDescription.getIdentifier());
        this.identifier = String.join((CharSequence)DELIMITER, CooperativeChallengeOperation.extractOSMObjectFromItemType(changeDescription.getItemType()), rawId.length() > 6 ? rawId.substring(0, rawId.length() - 6) : rawId);
        this.changeDescriptorList = changeDescription.getChangeDescriptors().stream().filter(operation -> this.operationFilter().test((ChangeDescriptor)operation)).collect(Collectors.toList());
    }

    public abstract CooperativeChallengeOperation create();

    public JsonObject getJson() {
        return this.json;
    }

    protected List<ChangeDescriptor> getChangeDescriptorList() {
        return this.changeDescriptorList;
    }

    protected String getIdentifier() {
        return this.identifier;
    }

    protected ChangeDescriptorType getOperationType() {
        return this.operationType;
    }

    protected abstract Predicate<ChangeDescriptor> operationFilter();

    protected void setJson(JsonObject json) {
        this.json = json;
    }
}

