/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.database.wikidata;

import java.text.MessageFormat;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openstreetmap.atlas.checks.database.wikidata.WikiItemInterface;

public enum WikiDataItem implements WikiItemInterface
{
    ELEMENT_Q9,
    KEY_Q7,
    TAG_Q2,
    STATUS_Q11,
    STATUS_Q8010,
    DE_FACTO_Q13(STATUS_Q11),
    IN_USE_Q14(STATUS_Q11),
    APPROVED_Q15(STATUS_Q11),
    REJECTED_Q16(STATUS_Q11),
    VOTING_Q17(STATUS_Q11),
    DRAFT_Q18(STATUS_Q11),
    ABANDONED_Q19(STATUS_Q11),
    PROPOSED_Q20(STATUS_Q11),
    OBSOLETE_Q5060(STATUS_Q11),
    DEPRECATED_Q5061(STATUS_Q11),
    DISCARDABLE_Q7550(STATUS_Q11),
    IMPORTED_Q21146(STATUS_Q11),
    IS_ALLOWED_Q8000(STATUS_Q8010),
    IS_PROHIBITED_Q8001(STATUS_Q8010),
    WELL_KNOWN_VALUES_Q8,
    GROUP_Q12,
    OSM_CONCEPT_Q10,
    SANDBOX_Q2761;

    @Nullable
    private final WikiDataItem parent;
    @Nonnull
    private final String pid;
    @Nonnull
    private final String rName;

    public static WikiDataItem fromValue(String value) {
        WikiDataItem rItem = Stream.of(WikiDataItem.values()).filter(entry -> entry.getId().equalsIgnoreCase(value)).findFirst().orElse(null);
        if (rItem == null) {
            rItem = Stream.of(WikiDataItem.values()).filter(p -> p.getDescriptor().equalsIgnoreCase(value)).findFirst().orElse(null);
        }
        return rItem;
    }

    private WikiDataItem() {
        this(null);
    }

    private WikiDataItem(WikiDataItem parent) {
        this.parent = parent;
        String[] enumName = this.name().split("_", -1);
        this.pid = enumName[enumName.length - 1];
        this.rName = this.name().replace("_" + this.pid, "").replace("_", " ");
    }

    @Override
    public String getDescriptor() {
        return this.rName;
    }

    @Override
    public String getId() {
        return this.pid;
    }

    @Nullable
    public WikiDataItem getParent() {
        return this.parent;
    }

    public boolean matches(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof String) {
            return this.rName.equalsIgnoreCase((String)other) || this.pid.equalsIgnoreCase((String)other);
        }
        return false;
    }

    public String toString() {
        return MessageFormat.format("{0}: {1}", this.pid, this.rName);
    }
}

