/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.database.wikidata;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceStability;
import org.openstreetmap.atlas.checks.database.wikidata.WikiDataItem;
import org.openstreetmap.atlas.checks.database.wikidata.WikiProperty;

public final class WikiData {
    private static final Map<String, WikiData> createdWikiData = Collections.synchronizedMap(new TreeMap());
    private static final String EMPTY_STRING = "";
    private static final Pattern QUOTE_PATTERN = Pattern.compile("(^\")|(\"$)");
    private static final Pattern BRACKET_PATTERN = Pattern.compile("(^\\[)|(\\]$)");
    private final String identifier;
    private final Collection<String> instanceOfP2;
    private final String subclassOfP3;
    private final WikiDataItem statusP6;
    private final String wikidataEquivalentP7;
    private final Collection<String> formatterUrlP8;
    private final WikiDataItem keyTypeP9;
    private final String keyForThisTagP10;
    private final String proposalDiscussionP11;
    private final String wikiDataConceptP12;
    private final Pattern valueValidationRegexP13;
    private final String permanentKeyIdP16;
    private final Collection<String> redirectToP17;
    private final Collection<String> differentFromP18;
    private final String permanentTagIdP19;
    private final String propertyDifferentFromP20;
    private final String relationRoleIdP21;
    private final Collection<String> requiredKeyOrTagP22;
    private final String groupP25;
    private final Collection<String> limitedToLanguageP26;
    private final String imageP28;
    private final Collection<String> mustOnlyBeUsedInRegionP29;
    private final Collection<String> notToBeUsedInRegionP30;
    private final Collection<String> documentationWikiPagesP31;
    private final String languageCodeP32;
    private final boolean useOnNodesP33;
    private final boolean useOnWaysP34;
    private final boolean useOnAreasP35;
    private final boolean useOnRelationsP36;
    private final boolean useOnChangesetsP37;
    private final String oSMCartoImageP39;
    private final String tagForThisRelationTypeP40;
    private final String permanentRelationTypeIdP41;
    private final Collection<String> belongsToRelationTypeP43;
    private final Collection<String> incompatibleWithP44;
    private final Collection<String> impliesP45;
    private final Collection<String> combinationP46;
    private final String imageCaptionP47;
    private final String limitedToRegionP48;
    private final Collection<String> geographicCodeP49;
    private final String redirectsToWikiPageP50;
    private final Collection<String> identicalToP51;

    public static void clearWikiData() {
        createdWikiData.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static WikiData getWikiData(Map<String, Object> wikiMap) {
        Objects.requireNonNull(wikiMap, "Wiki Data Item map cannot be null");
        String identifier = wikiMap.getOrDefault("id", EMPTY_STRING).toString();
        if (identifier.isBlank()) {
            return null;
        }
        if (createdWikiData.containsKey(identifier)) {
            return createdWikiData.get(identifier);
        }
        Map<String, WikiData> map = createdWikiData;
        synchronized (map) {
            return createdWikiData.computeIfAbsent(identifier, tid -> new WikiData(wikiMap));
        }
    }

    @Nullable
    public static WikiData getWikiData(String identifier) {
        Objects.requireNonNull(identifier, "id cannot be null");
        return createdWikiData.getOrDefault(identifier, null);
    }

    private static Collection<String> stringToCollection(String string) {
        if (string != null && !string.isBlank()) {
            return Stream.of(BRACKET_PATTERN.matcher(string).replaceAll(EMPTY_STRING).split(",", 0)).map(tString -> QUOTE_PATTERN.matcher((CharSequence)tString).replaceAll(EMPTY_STRING)).map(String::trim).map(tString -> QUOTE_PATTERN.matcher((CharSequence)tString).replaceAll(EMPTY_STRING)).collect(Collectors.toUnmodifiableSet());
        }
        return Collections.emptySet();
    }

    @Nonnull
    private static String stringify(@Nullable Object object) {
        if (object != null) {
            return object.toString();
        }
        return EMPTY_STRING;
    }

    private WikiData(Map<String, Object> wikiMap) {
        this.identifier = wikiMap.get("id").toString();
        this.instanceOfP2 = WikiData.stringToCollection(WikiData.stringify(WikiProperty.INSTANCE_OF_P2.get(wikiMap)));
        this.subclassOfP3 = WikiData.stringify(WikiProperty.SUBCLASS_OF_P3.get(wikiMap));
        this.statusP6 = WikiDataItem.fromValue(WikiData.stringify(WikiProperty.STATUS_P6.get(wikiMap)));
        this.wikidataEquivalentP7 = WikiData.stringify(WikiProperty.WIKIDATA_EQUIVALENT_P7.get(wikiMap));
        this.formatterUrlP8 = WikiData.stringToCollection(WikiData.stringify(WikiProperty.FORMATTER_URL_P8.get(wikiMap)));
        this.keyTypeP9 = WikiDataItem.fromValue(WikiData.stringify(WikiProperty.KEY_TYPE_P9.get(wikiMap)));
        this.keyForThisTagP10 = WikiData.stringify(WikiProperty.KEY_FOR_THIS_TAG_P10.get(wikiMap));
        this.proposalDiscussionP11 = WikiData.stringify(WikiProperty.PROPOSAL_DISCUSSION_P11.get(wikiMap));
        this.wikiDataConceptP12 = WikiData.stringify(WikiProperty.WIKIDATA_CONCEPT_P12.get(wikiMap));
        this.valueValidationRegexP13 = WikiProperty.VALUE_VALIDATION_REGEX_P13.get(wikiMap) != null ? Pattern.compile("^(" + WikiData.stringify(WikiProperty.VALUE_VALIDATION_REGEX_P13.get(wikiMap)) + ")$") : null;
        this.permanentKeyIdP16 = WikiData.stringify(WikiProperty.PERMANENT_KEY_ID_P16.get(wikiMap));
        this.redirectToP17 = WikiData.stringToCollection(WikiData.stringify(WikiProperty.REDIRECT_TO_P17.get(wikiMap)));
        this.differentFromP18 = WikiData.stringToCollection(WikiData.stringify(WikiProperty.DIFFERENT_FROM_P18.get(wikiMap)));
        this.permanentTagIdP19 = WikiData.stringify(WikiProperty.PERMANENT_TAG_ID_P19.get(wikiMap));
        this.propertyDifferentFromP20 = WikiData.stringify(WikiProperty.PROPERTY_DIFFERENT_FROM_P20.get(wikiMap));
        this.relationRoleIdP21 = WikiData.stringify(WikiProperty.RELATION_ROLE_ID_P21.get(wikiMap));
        this.requiredKeyOrTagP22 = WikiData.stringToCollection(WikiData.stringify(WikiProperty.REQUIRED_KEY_OR_TAG_P22.get(wikiMap)));
        this.groupP25 = WikiData.stringify(WikiProperty.GROUP_P25.get(wikiMap));
        this.limitedToLanguageP26 = WikiData.stringToCollection(WikiData.stringify(WikiProperty.LIMITED_TO_LANGUAGE_P26.get(wikiMap)));
        this.imageP28 = WikiData.stringify(WikiProperty.IMAGE_P28.get(wikiMap));
        this.mustOnlyBeUsedInRegionP29 = WikiData.stringToCollection(WikiData.stringify(WikiProperty.MUST_ONLY_BE_USED_IN_REGION_P29.get(wikiMap)));
        this.notToBeUsedInRegionP30 = WikiData.stringToCollection(WikiData.stringify(WikiProperty.NOT_TO_BE_USED_IN_REGION_P30.get(wikiMap)));
        this.documentationWikiPagesP31 = WikiData.stringToCollection(WikiData.stringify(WikiProperty.DOCUMENTATION_WIKI_PAGES_P31.get(wikiMap)));
        this.languageCodeP32 = WikiData.stringify(WikiProperty.LANGUAGE_CODE_P32.get(wikiMap));
        this.useOnNodesP33 = !WikiDataItem.IS_PROHIBITED_Q8001.matches(WikiData.stringify(WikiProperty.USE_ON_NODES_P33.get(wikiMap)));
        this.useOnWaysP34 = !WikiDataItem.IS_PROHIBITED_Q8001.matches(WikiData.stringify(WikiProperty.USE_ON_WAYS_P34.get(wikiMap)));
        this.useOnAreasP35 = !WikiDataItem.IS_PROHIBITED_Q8001.matches(WikiData.stringify(WikiProperty.USE_ON_AREAS_P35.get(wikiMap)));
        this.useOnRelationsP36 = !WikiDataItem.IS_PROHIBITED_Q8001.matches(WikiData.stringify(WikiProperty.USE_ON_RELATIONS_P36.get(wikiMap)));
        this.useOnChangesetsP37 = !WikiDataItem.IS_PROHIBITED_Q8001.matches(WikiData.stringify(WikiProperty.USE_ON_CHANGESETS_P37.get(wikiMap)));
        this.oSMCartoImageP39 = WikiData.stringify(WikiProperty.OSM_CARTO_IMAGE_P39.get(wikiMap));
        this.tagForThisRelationTypeP40 = WikiData.stringify(WikiProperty.TAG_FOR_THIS_RELATION_TYPE_P40.get(wikiMap));
        this.permanentRelationTypeIdP41 = WikiData.stringify(WikiProperty.PERMANENT_RELATION_TYPE_ID_P41.get(wikiMap));
        this.belongsToRelationTypeP43 = WikiData.stringToCollection(WikiData.stringify(WikiProperty.BELONGS_TO_RELATION_TYPE_P43.get(wikiMap)));
        this.incompatibleWithP44 = WikiData.stringToCollection(WikiData.stringify(WikiProperty.INCOMPATIBLE_WITH_P44.get(wikiMap)));
        this.impliesP45 = WikiData.stringToCollection(WikiData.stringify(WikiProperty.IMPLIES_P45.get(wikiMap)));
        this.combinationP46 = WikiData.stringToCollection(WikiData.stringify(WikiProperty.COMBINATION_P46.get(wikiMap)));
        this.imageCaptionP47 = WikiData.stringify(WikiProperty.IMAGE_CAPTION_P47.get(wikiMap));
        this.limitedToRegionP48 = WikiData.stringify(WikiProperty.LIMITED_TO_REGION_P48.get(wikiMap));
        this.geographicCodeP49 = WikiData.stringToCollection(WikiData.stringify(WikiProperty.GEOGRAPHIC_CODE_P49.get(wikiMap)));
        this.redirectsToWikiPageP50 = WikiData.stringify(WikiProperty.REDIRECTS_TO_WIKI_PAGE_P50.get(wikiMap));
        this.identicalToP51 = WikiData.stringToCollection(WikiData.stringify(WikiProperty.IDENTICAL_TO_P51.get(wikiMap)));
    }

    @Nonnull
    public Collection<String> getBelongsToRelationTypeP43() {
        return this.belongsToRelationTypeP43;
    }

    @Nonnull
    public Collection<String> getCombinationP46() {
        return this.combinationP46;
    }

    @Nonnull
    public Collection<String> getDifferentFromP18() {
        return this.differentFromP18;
    }

    @InterfaceStability.Unstable
    @Nonnull
    public Collection<String> getDocumentationWikiPagesP31() {
        return this.documentationWikiPagesP31.stream().map(key -> "https://wiki.osm.org/wiki/" + key).collect(Collectors.toList());
    }

    @Nonnull
    public Collection<String> getFormatterUrlP8() {
        return this.formatterUrlP8;
    }

    @Nonnull
    public Collection<String> getGeographicCodeP49() {
        return this.geographicCodeP49;
    }

    @InterfaceStability.Unstable
    @Nonnull
    public String getGroupP25() {
        return this.groupP25;
    }

    @Nonnull
    public String getId() {
        return this.identifier;
    }

    @Nonnull
    public Collection<String> getIdenticalToP51() {
        return this.identicalToP51;
    }

    @InterfaceStability.Unstable
    @Nonnull
    public String getImageCaptionP47() {
        return this.imageCaptionP47;
    }

    @InterfaceStability.Unstable
    @Nonnull
    public String getImageP28() {
        return this.imageP28;
    }

    @Nonnull
    public Collection<String> getImpliesP45() {
        return this.impliesP45;
    }

    @Nonnull
    public Collection<String> getIncompatibleWithP44() {
        return this.incompatibleWithP44;
    }

    @Nonnull
    public Collection<String> getInstanceOfP2() {
        return this.instanceOfP2;
    }

    @Nonnull
    public String getKeyForThisTagP10() {
        return this.keyForThisTagP10;
    }

    @Nullable
    public WikiDataItem getKeyTypeP9() {
        return this.keyTypeP9;
    }

    @Nonnull
    public String getLanguageCodeP32() {
        return this.languageCodeP32;
    }

    @InterfaceStability.Unstable
    @Nonnull
    public Collection<String> getLimitedToLanguageP26() {
        return this.limitedToLanguageP26;
    }

    @InterfaceStability.Unstable
    @Nonnull
    public String getLimitedToRegionP48() {
        return this.limitedToRegionP48;
    }

    @Nonnull
    public Collection<String> getMustOnlyBeUsedInRegionP29() {
        return this.mustOnlyBeUsedInRegionP29;
    }

    @Nonnull
    public Collection<String> getNotToBeUsedInRegionP30() {
        return this.notToBeUsedInRegionP30;
    }

    @InterfaceStability.Unstable
    @Nonnull
    public String getOSMCartoImageP39() {
        return this.oSMCartoImageP39;
    }

    @Nonnull
    public String getPermanentKeyIdP16() {
        return this.permanentKeyIdP16;
    }

    @Nonnull
    public String getPermanentRelationTypeIdP41() {
        return this.permanentRelationTypeIdP41;
    }

    @Nonnull
    public String getPermanentTagIdP19() {
        return this.permanentTagIdP19;
    }

    @InterfaceStability.Unstable
    @Nonnull
    public String getPropertyDifferentFromP20() {
        return this.propertyDifferentFromP20;
    }

    @Nonnull
    public String getProposalDiscussionP11() {
        return this.proposalDiscussionP11;
    }

    @Nonnull
    public Collection<String> getRedirectToP17() {
        return this.redirectToP17;
    }

    @InterfaceStability.Unstable
    @Nonnull
    public String getRedirectsToWikiPageP50() {
        return this.redirectsToWikiPageP50;
    }

    @Nonnull
    public String getRelationRoleIdP21() {
        return this.relationRoleIdP21;
    }

    @Nonnull
    public Collection<String> getRequiredKeyOrTagP22() {
        return this.requiredKeyOrTagP22;
    }

    @InterfaceStability.Unstable
    @Nullable
    public WikiDataItem getStatusP6() {
        return this.statusP6;
    }

    @Nonnull
    public String getSubclassOfP3() {
        return this.subclassOfP3;
    }

    @Nonnull
    public String getTagForThisRelationTypeP40() {
        return this.tagForThisRelationTypeP40;
    }

    @Nullable
    public Pattern getValueValidationRegexP13() {
        return this.valueValidationRegexP13;
    }

    @Nonnull
    public String getWikiDataConceptP12() {
        return this.wikiDataConceptP12;
    }

    @Nonnull
    public String getWikidataEquivalentP7() {
        return this.wikidataEquivalentP7;
    }

    @InterfaceStability.Unstable
    @Nonnull
    public boolean isUseOnAreasP35() {
        return this.useOnAreasP35;
    }

    @InterfaceStability.Unstable
    @Nonnull
    public boolean isUseOnChangesetsP37() {
        return this.useOnChangesetsP37;
    }

    public boolean isUseOnNodesP33() {
        return this.useOnNodesP33;
    }

    public boolean isUseOnRelationsP36() {
        return this.useOnRelationsP36;
    }

    public boolean isUseOnWaysP34() {
        return this.useOnWaysP34;
    }
}

