/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.database.taginfo;

import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class TagInfoKeyTagCommon
implements Serializable {
    private static final long serialVersionUID = -2248695610153869229L;
    private final String key;
    private final Number countAll;
    private final Number countNodes;
    private final Number countWays;
    private final Number countRelations;
    private final boolean inWiki;
    private final boolean inWikiEn;

    @Nullable
    protected static <T> T getAndCast(Map<String, Object> row, String key, Class<T> clazz) {
        if (row.containsKey(key) && clazz.isInstance(row.get(key))) {
            return clazz.cast(row.get(key));
        }
        return null;
    }

    protected TagInfoKeyTagCommon(Map<String, Object> row) {
        this.key = TagInfoKeyTagCommon.getAndCast(row, "key", String.class);
        this.countAll = TagInfoKeyTagCommon.getAndCast(row, "count_all", Number.class);
        this.countNodes = TagInfoKeyTagCommon.getAndCast(row, "count_nodes", Number.class);
        this.countWays = TagInfoKeyTagCommon.getAndCast(row, "count_ways", Number.class);
        this.countRelations = TagInfoKeyTagCommon.getAndCast(row, "count_relations", Number.class);
        this.inWiki = Boolean.TRUE.equals(TagInfoKeyTagCommon.getAndCast(row, "in_wiki", Boolean.class));
        this.inWikiEn = Boolean.TRUE.equals(TagInfoKeyTagCommon.getAndCast(row, "in_wiki_en", Boolean.class));
    }

    public Number getCountAll() {
        return this.countAll;
    }

    public Number getCountNodes() {
        return this.countNodes;
    }

    public Number getCountRelations() {
        return this.countRelations;
    }

    public Number getCountWays() {
        return this.countWays;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isInWiki() {
        return this.inWiki;
    }

    public boolean isInWikiEn() {
        return this.inWikiEn;
    }
}

