/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.base;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.generator.tools.filesystem.FileSystemHelper;
import org.openstreetmap.atlas.generator.tools.spark.utilities.SparkFileHelper;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.caching.ConcurrentResourceCache;
import org.openstreetmap.atlas.utilities.caching.strategies.CachingStrategy;
import org.openstreetmap.atlas.utilities.caching.strategies.NamespaceCachingStrategy;
import org.openstreetmap.atlas.utilities.runtime.Retry;
import org.openstreetmap.atlas.utilities.scalars.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalDataFetcher
implements Function<String, Optional<Resource>>,
Serializable {
    private static final long serialVersionUID = 724339604023082195L;
    private static final String GLOBAL_HADOOP_FILECACHE_NAMESPACE = "__HadoopExternalFileCache_global_namespace__";
    private static final Logger logger = LoggerFactory.getLogger(ExternalDataFetcher.class);
    private static final int RETRY_ATTEMPTS = 5;
    private final String input;
    private final Map<String, String> configuration;
    private transient ExternalDataResourceCache cache;
    private boolean silent;

    public ExternalDataFetcher(String input, Map<String, String> configuration) {
        this.input = input;
        this.configuration = configuration;
    }

    @Override
    public Optional<Resource> apply(String string) {
        return this.getCache().get(this.getUri(string));
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    @Nonnull
    private ExternalDataResourceCache getCache() {
        if (this.cache == null) {
            this.cache = new ExternalDataResourceCache();
        }
        return this.cache;
    }

    private URI getUri(String string) {
        String atlasURIString = SparkFileHelper.combine((String)this.input, (String[])new String[]{string});
        try {
            return new URI(atlasURIString);
        }
        catch (URISyntaxException exception) {
            throw new CoreException("Bad URI syntax: {}", new Object[]{atlasURIString, exception});
        }
    }

    private class ExternalFileFetcher
    implements Function<URI, Optional<Resource>>,
    Serializable {
        private static final long serialVersionUID = 1721253891315559418L;

        private ExternalFileFetcher() {
        }

        @Override
        public Optional<Resource> apply(URI uri) {
            Retry retry = new Retry(5, Duration.ONE_SECOND).withQuadratic(true);
            boolean exists = (Boolean)retry.run(() -> {
                Boolean bl;
                block9: {
                    InputStream inputStream = FileSystemHelper.resource((String)uri.toString(), ExternalDataFetcher.this.configuration).read();
                    try {
                        bl = true;
                        if (inputStream == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            if (e.getMessage().contains("File not found")) {
                                return false;
                            }
                            throw new CoreException("Unable to test existence of {}", new Object[]{uri, e});
                        }
                    }
                    inputStream.close();
                }
                return bl;
            });
            if (!exists) {
                if (!ExternalDataFetcher.this.silent) {
                    logger.warn("Fetcher: resource {} does not exist!", (Object)uri);
                }
                return Optional.empty();
            }
            return Optional.ofNullable(FileSystemHelper.resource((String)uri.toString(), ExternalDataFetcher.this.configuration));
        }
    }

    private class ExternalDataResourceCache
    extends ConcurrentResourceCache {
        ExternalDataResourceCache() {
            super((CachingStrategy)new NamespaceCachingStrategy(ExternalDataFetcher.GLOBAL_HADOOP_FILECACHE_NAMESPACE), (Function)new ExternalFileFetcher());
        }
    }
}

