/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.verifier;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.rules.Verifier;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.Atlas;

public class ConsumerBasedExpectedCheckVerifier
extends Verifier {
    private final List<CheckFlag> generatedFlags = new ArrayList<CheckFlag>();
    private final List<Consumer<List<CheckFlag>>> globalVerifiers = new ArrayList<Consumer<List<CheckFlag>>>();
    private final List<Consumer<CheckFlag>> flagVerifiers = new ArrayList<Consumer<CheckFlag>>();

    public void actual(Atlas atlas, BaseCheck<?> check) {
        Iterables.addAll(this.generatedFlags, check.flags(atlas));
        check.clear();
    }

    public ConsumerBasedExpectedCheckVerifier globallyVerify(Consumer<List<CheckFlag>> verifierFunction) {
        this.globalVerifiers.add(verifierFunction);
        return this;
    }

    public ConsumerBasedExpectedCheckVerifier verify(Consumer<CheckFlag> verifierFunction) {
        this.flagVerifiers.add(verifierFunction);
        return this;
    }

    public ConsumerBasedExpectedCheckVerifier verifyEmpty() {
        this.globalVerifiers.add(flags -> Assert.assertTrue((boolean)flags.isEmpty()));
        return this;
    }

    public ConsumerBasedExpectedCheckVerifier verifyExpectedSize(int size) {
        this.globalVerifiers.add(flags -> Assert.assertEquals((long)size, (long)flags.size()));
        return this;
    }

    public ConsumerBasedExpectedCheckVerifier verifyNotEmpty() {
        this.globalVerifiers.add(flags -> Assert.assertFalse((boolean)flags.isEmpty()));
        return this;
    }

    public ConsumerBasedExpectedCheckVerifier verifyNotNull() {
        this.globalVerifiers.add(flags -> {
            Assert.assertNotNull((Object)flags);
            flags.forEach(Assert::assertNotNull);
        });
        return this;
    }

    protected void verify() throws Throwable {
        if (this.globalVerifiers.isEmpty() && this.flagVerifiers.isEmpty()) {
            Assert.fail((String)"Please create at least one function to verify test results.");
        }
        this.globalVerifiers.forEach(consumer -> consumer.accept(this.generatedFlags));
        this.generatedFlags.forEach(flag -> this.flagVerifiers.forEach(consumer -> consumer.accept(flag)));
    }
}

