/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.tag;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.walker.OsmWayWalker;
import org.openstreetmap.atlas.tags.BridgeTag;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.JunctionTag;
import org.openstreetmap.atlas.tags.LayerTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.TunnelTag;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class UnusualLayerTagsCheck
extends BaseCheck<Long> {
    public static final String INVALID_LAYER_INSTRUCTION = String.format("A layer tag must have a value in [%d, %d] and 0 should not be used explicitly.", LayerTag.getMinValue(), LayerTag.getMaxValue());
    public static final String JUNCTION_INSTRUCTION = "Junctions with valid layer values must include bridge or tunnel tags";
    private static final Predicate<Taggable> ALLOWED_TAGS;
    private static final long BRIDGE_LAYER_TAG_MAX_VALUE;
    private static final long BRIDGE_LAYER_TAG_MIN_VALUE = 1L;
    public static final String BRIDGE_INSTRUCTION;
    private static final int THREE = 3;
    private static final long TUNNEL_LAYER_TAG_MAX_VALUE = -1L;
    private static final long TUNNEL_LAYER_TAG_MIN_VALUE;
    public static final String TUNNEL_INSTRUCTION;
    public static final List<String> FALLBACK_INSTRUCTIONS;
    private static final Predicate<Taggable> ELIGIBLE_TUNNEL_TAGS;
    private static final long serialVersionUID = 7040472721500502360L;

    public UnusualLayerTagsCheck(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Edge && HighwayTag.isCarNavigableHighway((Taggable)object) && ALLOWED_TAGS.test((Taggable)object) && ((Edge)object).isMainEdge() && !this.isFlagged(object.getOsmIdentifier());
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Optional layerTagValue = LayerTag.getTaggedValue((Taggable)object);
        boolean isTagValueValid = layerTagValue.isPresent();
        this.markAsFlagged(object.getOsmIdentifier());
        Set osmWay = new OsmWayWalker((Edge)object).collectEdges();
        if (TunnelTag.isTunnel((Taggable)object) && (!isTagValueValid || (Long)layerTagValue.get() > -1L || (Long)layerTagValue.get() < TUNNEL_LAYER_TAG_MIN_VALUE)) {
            return Optional.of(this.createFlag((Set<AtlasObject>)osmWay, this.getLocalizedInstruction(0, new Object[0])));
        }
        if (!(!BridgeTag.isBridge((Taggable)object) || isTagValueValid && (Long)layerTagValue.get() == 0L || isTagValueValid && (Long)layerTagValue.get() <= BRIDGE_LAYER_TAG_MAX_VALUE && (Long)layerTagValue.get() >= 1L)) {
            return Optional.of(this.createFlag((Set<AtlasObject>)osmWay, this.getLocalizedInstruction(2, new Object[0])));
        }
        if (JunctionTag.isRoundabout((Taggable)object) && isTagValueValid && (Long)layerTagValue.get() != 0L && !TunnelTag.isTunnel((Taggable)object) && !BridgeTag.isBridge((Taggable)object)) {
            return Optional.of(this.createFlag((Set<AtlasObject>)osmWay, this.getLocalizedInstruction(1, new Object[0])));
        }
        if (!isTagValueValid) {
            return Optional.of(this.createFlag((Set<AtlasObject>)osmWay, this.getLocalizedInstruction(3, new Object[0])));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    static {
        BRIDGE_LAYER_TAG_MAX_VALUE = LayerTag.getMaxValue();
        BRIDGE_INSTRUCTION = String.format("Bridges must have a layer tag set to a value in [%d, %d].", 1L, BRIDGE_LAYER_TAG_MAX_VALUE);
        TUNNEL_LAYER_TAG_MIN_VALUE = LayerTag.getMinValue();
        TUNNEL_INSTRUCTION = String.format("Tunnels must have layer tags set to a value in [%d, %d].", TUNNEL_LAYER_TAG_MIN_VALUE, -1L);
        FALLBACK_INSTRUCTIONS = Arrays.asList(TUNNEL_INSTRUCTION, JUNCTION_INSTRUCTION, BRIDGE_INSTRUCTION, INVALID_LAYER_INSTRUCTION);
        ELIGIBLE_TUNNEL_TAGS = object -> Validators.hasValuesFor((Taggable)object, (Class[])new Class[]{TunnelTag.class}) && !Validators.isOfType((Taggable)object, TunnelTag.class, (Enum[])new TunnelTag[]{TunnelTag.BUILDING_PASSAGE});
        ALLOWED_TAGS = Validators.hasValuesFor((Class[])new Class[]{BridgeTag.class}).or(Validators.hasValuesFor((Class[])new Class[]{LayerTag.class})).or(ELIGIBLE_TUNNEL_TAGS);
    }
}

