/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.tag;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.atlas.predicates.TypePredicates;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.Heading;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEntity;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.tags.AccessTag;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.TollTag;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Angle;
import org.openstreetmap.atlas.utilities.scalars.Counter;

public class TollValidationCheck
extends BaseCheck<Long> {
    private static final long serialVersionUID = -4286937145318778446L;
    private static final String INTERSECTS_TOLL_FEATURE = "Way {0, number, #} intersects toll feature but is missing toll tag, please investigate toll tag addition.";
    private static final String ESCAPABLE_TOLL = "Toll tags need to be investigated for removal on way {0, number, #}. Please check ways {1, number, #} and {2, number, #} and affected nearby ways for modeling issues. Nearby toll features that might be helpful are: upstream {3, number, #} and downstream {4, number, #}.";
    private static final String INCONSISTENT_TOLL_TAGS = "Way {0, number, #} has an inconsistent toll tag with its surrounding ways. Please check for proper toll tag modeling.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("Way {0, number, #} intersects toll feature but is missing toll tag, please investigate toll tag addition.", "Toll tags need to be investigated for removal on way {0, number, #}. Please check ways {1, number, #} and {2, number, #} and affected nearby ways for modeling issues. Nearby toll features that might be helpful are: upstream {3, number, #} and downstream {4, number, #}.", "Way {0, number, #} has an inconsistent toll tag with its surrounding ways. Please check for proper toll tag modeling.");
    private static final String HIGHWAY_MINIMUM_DEFAULT = HighwayTag.RESIDENTIAL.toString();
    private static final Double MAX_ANGLE_DIFF_DEFAULT = 40.0;
    private static final double MIN_IN_OUT_EDGES_DEFAULT = 1.0;
    private static final double MAX_ITERATION_FOR_SEARCH_DEFAULT = 15.0;
    private final HighwayTag minHighwayType;
    private final double minInAndOutEdges;
    private final double maxAngleDiffForContiguousWays;
    private final double maxIterationForNearbySearch;

    public TollValidationCheck(Configuration configuration) {
        super(configuration);
        String highwayType = this.configurationValue(configuration, "minHighwayType", HIGHWAY_MINIMUM_DEFAULT);
        this.minHighwayType = Enum.valueOf(HighwayTag.class, highwayType.toUpperCase());
        this.maxAngleDiffForContiguousWays = this.configurationValue(configuration, "maxAngleDiffForContiguousWays", MAX_ANGLE_DIFF_DEFAULT);
        this.minInAndOutEdges = this.configurationValue(configuration, "minInAndOutEdges", 1.0);
        this.maxIterationForNearbySearch = this.configurationValue(configuration, "maxIterationForNearbySearch", 15.0);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return TypePredicates.IS_EDGE.test(object) && ((Edge)object).isMainEdge() && ((Edge)object).highwayTag().isMoreImportantThan(this.minHighwayType) && !this.isFlagged(object.getOsmIdentifier()) && !this.isPrivateAccess(object.getOsmTags());
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Edge escapableOutEdge;
        Edge edgeInQuestion = ((Edge)object).getMainEdge();
        Map edgeInQuestionTags = edgeInQuestion.getOsmTags();
        HashSet<Long> alreadyCheckedNearbyTollEdges = new HashSet<Long>();
        HashSet<Long> alreadyCheckedObjectIds = new HashSet<Long>();
        if (this.isCaseOne(edgeInQuestion, edgeInQuestionTags)) {
            this.markAsFlagged(edgeInQuestion.getOsmIdentifier());
            return Optional.of(this.createFlag(object, this.getLocalizedInstruction(0, edgeInQuestion.getOsmIdentifier())).addFixSuggestion(FeatureChange.add((AtlasEntity)((AtlasEntity)((CompleteEntity)CompleteEntity.from((AtlasEntity)((AtlasEntity)object))).withAddedTag("toll", TollTag.YES.toString().toLowerCase())), (Atlas)object.getAtlas())));
        }
        if (this.isCaseTwo(edgeInQuestion, edgeInQuestionTags)) {
            this.markAsFlagged(edgeInQuestion.getOsmIdentifier());
            return Optional.of(this.createFlag(object, this.getLocalizedInstruction(2, edgeInQuestion.getOsmIdentifier())).addFixSuggestion(FeatureChange.add((AtlasEntity)((AtlasEntity)((CompleteEntity)CompleteEntity.from((AtlasEntity)((AtlasEntity)object))).withAddedTag("toll", TollTag.YES.toString().toLowerCase())), (Atlas)object.getAtlas())));
        }
        Edge escapableInEdge = this.edgeProvingBackwardsIsEscapable(edgeInQuestion, alreadyCheckedObjectIds).orElse(null);
        if (this.escapableEdgesNullChecker(escapableInEdge, escapableOutEdge = (Edge)this.edgeProvingForwardIsEscapable(edgeInQuestion, alreadyCheckedObjectIds).orElse(null)) && this.isCaseThree(edgeInQuestion, edgeInQuestionTags, escapableInEdge, escapableOutEdge)) {
            this.markAsFlagged(object.getOsmIdentifier());
            Counter counter = new Counter();
            Long nearbyTollFeatureUpstream = this.getNearbyTollFeatureInEdgeSide(edgeInQuestion, alreadyCheckedNearbyTollEdges, counter).orElse(null);
            counter.reset();
            Long nearbyTollFeatureDownstream = this.getNearbyTollFeatureOutEdgeSide(edgeInQuestion, alreadyCheckedNearbyTollEdges, counter).orElse(null);
            return Optional.of(this.createFlag(object, this.getLocalizedInstruction(1, edgeInQuestion.getOsmIdentifier(), escapableInEdge.getOsmIdentifier(), escapableOutEdge.getOsmIdentifier(), nearbyTollFeatureUpstream, nearbyTollFeatureDownstream)));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private Angle angleDiffBetweenEdges(Edge edge1, Edge edge2) {
        Optional edge1heading = edge1.asPolyLine().finalHeading();
        Optional edge2heading = edge2.asPolyLine().initialHeading();
        if (edge1heading.isPresent() && edge2heading.isPresent()) {
            return ((Heading)edge1heading.get()).difference((Angle)edge2heading.get());
        }
        return Angle.NONE;
    }

    private boolean barrierTagContainsToll(Map<String, String> tags) {
        return tags.get("barrier").contains("toll");
    }

    private boolean bothTollYesTag(Map<String, String> tags, Map<String, String> tags2) {
        return this.hasTollYesTag(tags) && this.hasTollYesTag(tags2);
    }

    private boolean containsBarrierTag(Map<String, String> tags) {
        return tags.containsKey("barrier");
    }

    private boolean containsHighwayTag(Map<String, String> tags) {
        return tags.containsKey("highway");
    }

    private boolean containsTollTag(Map<String, String> tags) {
        return tags.containsKey("toll");
    }

    private boolean edgeIntersectsTollFeature(Edge edge) {
        Iterable intersectingAreas = edge.getAtlas().areasIntersecting((GeometricSurface)edge.bounds());
        Set edgeNodes = edge.connectedNodes();
        for (Area area : intersectingAreas) {
            boolean areaContainsPolyline = area.asPolygon().overlaps(edge.asPolyLine());
            Map areaTags = area.getOsmTags();
            if (!areaContainsPolyline || !this.containsBarrierTag(areaTags) || !this.barrierTagContainsToll(areaTags)) continue;
            return true;
        }
        for (Node node : edgeNodes) {
            Map nodeTags = node.getOsmTags();
            if ((!this.containsHighwayTag(nodeTags) || !this.highwayTagContainsToll(nodeTags)) && (!this.containsBarrierTag(nodeTags) || !this.barrierTagContainsToll(nodeTags))) continue;
            return true;
        }
        return false;
    }

    private Optional<Edge> edgeProvingBackwardsIsEscapable(Edge edge, Set<Long> alreadyCheckedObjectIds) {
        Set<Edge> inEdges = this.getInEdges(edge);
        for (Edge inEdge : inEdges) {
            if (!((double)inEdges.size() >= this.minInAndOutEdges) || alreadyCheckedObjectIds.contains(inEdge.getIdentifier()) || !inEdge.highwayTag().isMoreImportantThan(this.minHighwayType) || !this.hasSameHighwayTag(edge, inEdge) || !(this.angleDiffBetweenEdges(inEdge, edge).asDegrees() <= this.maxAngleDiffForContiguousWays)) continue;
            alreadyCheckedObjectIds.add(inEdge.getIdentifier());
            Map keySet = inEdge.getOsmTags();
            if (!this.containsTollTag(keySet) || this.containsTollTag(keySet) && ((String)keySet.get("toll")).equalsIgnoreCase(TollTag.NO.toString())) {
                return Optional.of(inEdge);
            }
            if (this.edgeIntersectsTollFeature(inEdge) || !this.containsTollTag(keySet) || !((String)keySet.get("toll")).equalsIgnoreCase(TollTag.YES.toString())) continue;
            return this.edgeProvingBackwardsIsEscapable(inEdge, alreadyCheckedObjectIds);
        }
        return Optional.empty();
    }

    private Optional<Edge> edgeProvingForwardIsEscapable(Edge edge, Set<Long> alreadyCheckedObjectIds) {
        Set<Edge> outEdges = this.getOutEdges(edge);
        for (Edge outEdge : outEdges) {
            if (!((double)outEdges.size() >= this.minInAndOutEdges) || alreadyCheckedObjectIds.contains(outEdge.getIdentifier()) || !outEdge.highwayTag().isMoreImportantThan(this.minHighwayType) || !this.hasSameHighwayTag(edge, outEdge) || !(this.angleDiffBetweenEdges(edge, outEdge).asDegrees() <= this.maxAngleDiffForContiguousWays)) continue;
            alreadyCheckedObjectIds.add(outEdge.getIdentifier());
            Map keySet = outEdge.getOsmTags();
            if (!this.containsTollTag(keySet) || this.containsTollTag(keySet) && ((String)keySet.get("toll")).equalsIgnoreCase(TollTag.NO.toString())) {
                return Optional.of(outEdge);
            }
            if (this.edgeIntersectsTollFeature(outEdge) || !this.containsTollTag(keySet) || !((String)keySet.get("toll")).equalsIgnoreCase(TollTag.YES.toString())) continue;
            return this.edgeProvingForwardIsEscapable(outEdge, alreadyCheckedObjectIds);
        }
        return Optional.empty();
    }

    private boolean escapableEdgesNullChecker(Edge escapableInEdge, Edge escapableOutEdge) {
        return escapableInEdge != null && escapableOutEdge != null;
    }

    private Optional<Long> getAreaOrNodeIntersectionId(Edge edge, Set<Long> alreadyCheckedNearbyTollEdges) {
        alreadyCheckedNearbyTollEdges.add(edge.getIdentifier());
        Iterable intersectingAreas = edge.getAtlas().areasIntersecting((GeometricSurface)edge.bounds());
        Set edgeNodes = edge.connectedNodes();
        for (Area area : intersectingAreas) {
            boolean areaContainsPolyline = area.asPolygon().overlaps(edge.asPolyLine());
            Map areaTags = area.getOsmTags();
            if (!areaContainsPolyline || !this.containsBarrierTag(areaTags) || !this.barrierTagContainsToll(areaTags)) continue;
            return Optional.of(area.getOsmIdentifier());
        }
        for (Node node : edgeNodes) {
            Map nodeTags = node.getOsmTags();
            if ((!this.containsHighwayTag(nodeTags) || !this.highwayTagContainsToll(nodeTags)) && (!this.containsBarrierTag(nodeTags) || !this.barrierTagContainsToll(nodeTags))) continue;
            return Optional.of(node.getOsmIdentifier());
        }
        return Optional.empty();
    }

    private Set<Edge> getInEdges(Edge edge) {
        return edge.inEdges().stream().filter(someEdge -> someEdge.isMainEdge() && HighwayTag.isCarNavigableHighway((Taggable)someEdge)).collect(Collectors.toSet());
    }

    private Optional<Long> getNearbyTollFeatureInEdgeSide(Edge edge, Set<Long> alreadyCheckedNearbyTollEdges, Counter counter) {
        Set<Edge> inEdges = this.getInEdges(edge);
        for (Edge inEdge : inEdges) {
            if ((double)inEdges.size() >= this.minInAndOutEdges && this.edgeIntersectsTollFeature(inEdge) && !alreadyCheckedNearbyTollEdges.contains(inEdge.getIdentifier())) {
                return this.getAreaOrNodeIntersectionId(inEdge, alreadyCheckedNearbyTollEdges);
            }
            if (!((double)counter.getValue() <= this.maxIterationForNearbySearch) || !((double)inEdges.size() >= this.minInAndOutEdges) || this.edgeIntersectsTollFeature(inEdge) || alreadyCheckedNearbyTollEdges.contains(inEdge.getIdentifier())) continue;
            alreadyCheckedNearbyTollEdges.add(inEdge.getIdentifier());
            counter.add(1L);
            return this.getNearbyTollFeatureInEdgeSide(inEdge, alreadyCheckedNearbyTollEdges, counter);
        }
        return Optional.empty();
    }

    private Optional<Long> getNearbyTollFeatureOutEdgeSide(Edge edge, Set<Long> alreadyCheckedNearbyTollEdges, Counter counter) {
        Set<Edge> outEdges = this.getOutEdges(edge);
        for (Edge outEdge : outEdges) {
            if ((double)outEdges.size() >= this.minInAndOutEdges && this.edgeIntersectsTollFeature(outEdge) && !alreadyCheckedNearbyTollEdges.contains(outEdge.getIdentifier())) {
                return this.getAreaOrNodeIntersectionId(outEdge, alreadyCheckedNearbyTollEdges);
            }
            if (!((double)counter.getValue() <= this.maxIterationForNearbySearch) || !((double)outEdges.size() >= this.minInAndOutEdges) || this.edgeIntersectsTollFeature(outEdge) || alreadyCheckedNearbyTollEdges.contains(outEdge.getIdentifier())) continue;
            alreadyCheckedNearbyTollEdges.add(outEdge.getIdentifier());
            counter.add(1L);
            return this.getNearbyTollFeatureOutEdgeSide(outEdge, alreadyCheckedNearbyTollEdges, counter);
        }
        return Optional.empty();
    }

    private Set<Edge> getOutEdges(Edge edge) {
        return edge.outEdges().stream().filter(someEdge -> someEdge.isMainEdge() && HighwayTag.isCarNavigableHighway((Taggable)someEdge)).collect(Collectors.toSet());
    }

    private boolean hasInconsistentTollTag(Edge edge) {
        Set<Edge> inEdges = edge.inEdges().stream().filter(inEdge -> inEdge.getOsmIdentifier() != edge.getOsmIdentifier() && inEdge.isMainEdge() && HighwayTag.isCarNavigableHighway((Taggable)inEdge)).collect(Collectors.toSet());
        Set<Edge> outEdges = edge.outEdges().stream().filter(outEdge -> outEdge.getOsmIdentifier() != edge.getOsmIdentifier() && outEdge.isMainEdge() && HighwayTag.isCarNavigableHighway((Taggable)outEdge)).collect(Collectors.toSet());
        if (inEdges.size() == 1 && outEdges.size() == 1) {
            return this.inconsistentTollTagLogic(inEdges, outEdges, edge);
        }
        return false;
    }

    private boolean hasSameHighwayTag(Edge edge1, Edge edge2) {
        if (HighwayTag.highwayTag((Taggable)edge1).isPresent() && HighwayTag.highwayTag((Taggable)edge2).isPresent()) {
            return edge1.highwayTag().equals((Object)edge2.highwayTag());
        }
        return false;
    }

    private boolean hasTollYesTag(Map<String, String> tags) {
        return tags.keySet().stream().anyMatch(tag -> tag.equals("toll")) && tags.get("toll").equalsIgnoreCase(TollTag.YES.toString());
    }

    private boolean highwayTagContainsToll(Map<String, String> tags) {
        return tags.get("highway").contains("toll");
    }

    private boolean inconsistentTollTagLogic(Set<Edge> inEdges, Set<Edge> outEdges, Edge edge) {
        for (Edge inEdge : inEdges) {
            for (Edge outEdge : outEdges) {
                Map outEdgeOsmTags;
                Map inEdgeOsmTags;
                if (!this.hasSameHighwayTag(edge, inEdge) || !this.hasSameHighwayTag(edge, outEdge) || !(this.angleDiffBetweenEdges(edge, outEdge).asDegrees() <= this.maxAngleDiffForContiguousWays) || !(this.angleDiffBetweenEdges(inEdge, edge).asDegrees() <= this.maxAngleDiffForContiguousWays) || !this.bothTollYesTag(inEdgeOsmTags = inEdge.getOsmTags(), outEdgeOsmTags = outEdge.getOsmTags())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isCaseOne(Edge edgeInQuestion, Map<String, String> edgeInQuestionTags) {
        return !this.hasTollYesTag(edgeInQuestionTags) && this.edgeIntersectsTollFeature(edgeInQuestion);
    }

    private boolean isCaseThree(Edge edgeInQuestion, Map<String, String> edgeInQuestionTags, Edge escapableInEdge, Edge escapableOutEdge) {
        return this.hasTollYesTag(edgeInQuestionTags) && !this.edgeIntersectsTollFeature(edgeInQuestion) && !this.hasInconsistentTollTag(escapableOutEdge) && !this.hasInconsistentTollTag(escapableInEdge);
    }

    private boolean isCaseTwo(Edge edgeInQuestion, Map<String, String> edgeInQuestionTags) {
        return !this.hasTollYesTag(edgeInQuestionTags) && this.hasInconsistentTollTag(edgeInQuestion);
    }

    private boolean isPrivateAccess(Map<String, String> tags) {
        if (tags.containsKey("access")) {
            return tags.get("access").equalsIgnoreCase(AccessTag.PRIVATE.toString());
        }
        return false;
    }
}

