/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.tag;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.locale.IsoLanguage;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.tags.names.NameFinder;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class ShortNameCheck
extends BaseCheck<Long> {
    private static final List<String> NON_LATIN_SCRIPT_COUNTRIES_DEFAULT = Arrays.asList("AFG", "ARE", "ARM", "BGD", "BGR", "BHR", "BIH", "BLR", "BRN", "BTN", "CHN", "COM", "CYP", "DJI", "DZA", "EGY", "ERI", "ESH", "ETH", "GEO", "GRC", "HKG", "IND", "IRN", "IRQ", "ISR", "JOR", "JPN", "KAZ", "KGZ", "KHM", "KOR", "KWT", "LAO", "LBN", "LBY", "LKA", "MAC", "MAR", "MDA", "MDV", "MKD", "MMR", "MNE", "MNG", "MRT", "MYS", "NPL", "OMN", "PAK", "PRK", "PSE", "QAT", "RUS", "SAU", "SDN", "SGP", "SOM", "SRB", "SYR", "TCD", "THA", "TJK", "TUN", "TWN", "TZA", "UKR", "YEM");
    private static final long THRESHOLD_DEFAULT = 2L;
    private static final long NON_LATIN_SCRIPT_THRESHOLD_DEFAULT = 1L;
    private static final List<String> FALLBACK_INSTRUCTIONS = Collections.singletonList("The following names for OSM Id: {0,number,#}, are too short {1}");
    private static final long serialVersionUID = -3935274340982988966L;
    private final Set<String> keyNames = new HashSet<String>();
    private final long threshold;
    private final long nonLatinThreshold;
    private final Set<String> nonLatinScriptCountries;

    public ShortNameCheck(Configuration configuration) {
        super(configuration);
        Set languages = IsoLanguage.allLanguageCodes().stream().map(languageCode -> Optional.of((IsoLanguage)IsoLanguage.forLanguageCode((String)languageCode).get())).collect(Collectors.toSet());
        languages.add(Optional.empty());
        for (Optional language : languages) {
            for (Class klass : NameFinder.STANDARD_TAGS_NON_REFERENCE) {
                Validators.localizeKeyName((Class)klass, (Optional)language, (Taggable.TagSearchOption[])new Taggable.TagSearchOption[0]).ifPresent(this.keyNames::add);
            }
        }
        this.threshold = this.configurationValue(configuration, "length.maximum", 2L);
        this.nonLatinThreshold = this.configurationValue(configuration, "non.latin.length.maximum", 1L);
        this.nonLatinScriptCountries = new HashSet<String>((Collection)this.configurationValue(configuration, "non.latin.countries", NON_LATIN_SCRIPT_COUNTRIES_DEFAULT));
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        String objectIsoCountry = object.tag("iso_country_code");
        String nameTag = object.tag("name");
        return nameTag != null && objectIsoCountry != null && (long)nameTag.length() < (this.nonLatinScriptCountries.contains(objectIsoCountry.toUpperCase()) ? this.nonLatinThreshold : this.threshold);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Map tags = object.getTags();
        String shortNameTags = tags.entrySet().stream().filter(entry -> this.keyNames.contains(entry.getKey()) && (StringUtils.isEmpty((CharSequence)((CharSequence)entry.getValue())) || (long)((String)entry.getValue()).length() < this.threshold)).map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("; "));
        if (shortNameTags.length() > 0) {
            return Optional.of(this.createFlag(object, this.getLocalizedInstruction(0, object.getOsmIdentifier(), shortNameTags)));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }
}

