/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.tag;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.tags.BridgeTag;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.RailwayTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public class BridgeDetailedInfoCheck
extends BaseCheck<Long> {
    private static final long serialVersionUID = -8915653487119336836L;
    private static final Predicate<AtlasObject> IS_MAJOR_HIGHWAY = object -> Validators.isOfType((Taggable)object, HighwayTag.class, (Enum[])new HighwayTag[]{HighwayTag.MOTORWAY, HighwayTag.TRUNK, HighwayTag.PRIMARY, HighwayTag.SECONDARY});
    private static final Double MINIMUM_LENGTH = 500.0;
    private static final String BRIDGE_STRUCTURE_TAG = "bridge:structure";
    private static final List<String> FALLBACK_INSTRUCTIONS = Collections.singletonList("The length of this bridge (OSM ID: {0,number,#}) makes it deserve more details than just 'bridge=yes'. Add an appropriate 'bridge=*' or 'bridge:structure=*' tag.");
    private final Distance minimumLength;

    public BridgeDetailedInfoCheck(Configuration configuration) {
        super(configuration);
        this.minimumLength = this.configurationValue(configuration, "bridge.length.minimum.meters", MINIMUM_LENGTH, Distance::meters);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Edge && ((Edge)object).isMainEdge() && Validators.isOfType((Taggable)object, BridgeTag.class, (Enum[])new BridgeTag[]{BridgeTag.YES}) && (RailwayTag.isRailway((Taggable)object) || IS_MAJOR_HIGHWAY.test(object));
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Optional bridgeStructureTag = object.getTag(BRIDGE_STRUCTURE_TAG);
        if (((Edge)object).length().isGreaterThan(this.minimumLength) && bridgeStructureTag.isEmpty()) {
            return Optional.of(this.createFlag(object, this.getLocalizedInstruction(0, object.getOsmIdentifier())));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }
}

