/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.linear.edges;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.walker.OsmWayWalker;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.JunctionTag;
import org.openstreetmap.atlas.tags.SyntheticBoundaryNodeTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class SingleSegmentMotorwayCheck
extends BaseCheck<Long> {
    private static final long serialVersionUID = 5874631233752066384L;
    private static final String SINGLE_SEGMENT_INSTRUCTION = "This way, id:{0,number,#}, is a motorway that is disconnected from any other motorways.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Collections.singletonList("This way, id:{0,number,#}, is a motorway that is disconnected from any other motorways.");

    public SingleSegmentMotorwayCheck(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Edge && ((Edge)object).isMainEdge() && this.isMotorwayNotRoundabout((Edge)object) && !this.isFlagged(object.getOsmIdentifier()) && ((Edge)object).connectedNodes().stream().noneMatch(SyntheticBoundaryNodeTag::isBoundaryNode);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Edge edge = (Edge)object;
        if (edge.connectedEdges().stream().filter(Edge::isMainEdge).noneMatch(this::isMotorwayNotRoundabout)) {
            this.markAsFlagged(edge.getOsmIdentifier());
            return Optional.of(this.createFlag((Set<AtlasObject>)new OsmWayWalker(edge).collectEdges(), this.getLocalizedInstruction(0, edge.getOsmIdentifier())));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean isMotorwayNotRoundabout(Edge edge) {
        return Validators.isOfType((Taggable)edge, HighwayTag.class, (Enum[])new HighwayTag[]{HighwayTag.MOTORWAY}) && !JunctionTag.isRoundabout((Taggable)edge);
    }
}

