/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.linear.edges;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.walker.OsmWayWalker;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.JunctionTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.filters.TaggableFilter;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Angle;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public class RoundaboutMissingTagCheck
extends BaseCheck<Long> {
    public static final String MISSING_JUNCTION_TAG_INSTRUCTION = "This edge might be a roundabout";
    private static final int MINIMUM_INTERSECTION = 2;
    private static final int TURNING_CIRCLE_SECTIONS = 2;
    private static final long TURNING_CIRCLE_LENGTH_THRESHOLD_DEFAULT = 4L;
    private static final int MODULUS = 10;
    private static final int FIRST_EDGE_SECTION = 1;
    private static final List<String> FALLBACK_INSTRUCTIONS = Collections.singletonList("This edge might be a roundabout");
    private static final double MAX_THRESHOLD_DEGREES_DEFAULT = 40.0;
    private static final double MIN_THRESHOLD_DEGREES_DEFAULT = 10.0;
    private static final String TAG_FILTER_IGNORE_DEFAULT = "motor_vehicle->!no&foot->!yes&footway->!&access->!private&construction->!";
    private static final long serialVersionUID = 5171171744111206429L;
    private final Angle maxAngleThreshold;
    private final Angle minAngleThreshold;
    private final long turningCircleLengthThreshold;
    private final TaggableFilter tagFilterIgnore;

    public RoundaboutMissingTagCheck(Configuration configuration) {
        super(configuration);
        this.maxAngleThreshold = this.configurationValue(configuration, "angle.threshold.maximum_degree", 40.0, Angle::degrees);
        this.minAngleThreshold = this.configurationValue(configuration, "angle.threshold.minimum_degree", 10.0, Angle::degrees);
        this.tagFilterIgnore = this.configurationValue(configuration, "ignore.tags.filter", TAG_FILTER_IGNORE_DEFAULT, TaggableFilter::forDefinition);
        this.turningCircleLengthThreshold = this.configurationValue(configuration, "turning.circle.length.threshold", 4L);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Edge && !this.isFlagged(object.getOsmIdentifier()) && object.getIdentifier() % 10L == 1L && ((Edge)object).isMainEdge() && HighwayTag.isCarNavigableHighway((Taggable)object) && this.tagFilterIgnore.test((Taggable)object) && object.getTag("junction").isEmpty() && object.getTag("area").isEmpty() && this.isPartOfClosedWay((Edge)object) && this.intersectingWithMoreThan((Edge)object) && !this.isTurningCircle((Edge)object);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Edge edge = (Edge)object;
        PolyLine originalGeom = this.buildOriginalOsmWayGeometry(edge);
        List maxOffendingAngles = originalGeom.anglesGreaterThanOrEqualTo(this.maxAngleThreshold);
        List minOffendingAngles = originalGeom.anglesLessThanOrEqualTo(this.minAngleThreshold);
        if (maxOffendingAngles.isEmpty() && minOffendingAngles.isEmpty()) {
            new OsmWayWalker(edge).collectEdges().forEach(roundaboutEdge -> this.markAsFlagged(roundaboutEdge.getIdentifier()));
            return Optional.of(this.createFlag((Set<AtlasObject>)new OsmWayWalker(edge).collectEdges(), this.getLocalizedInstruction(0, object.getOsmIdentifier())).addFixSuggestion(FeatureChange.add((AtlasEntity)((AtlasEntity)((CompleteEntity)CompleteEntity.from((AtlasEntity)((AtlasEntity)object))).withAddedTag("junction", JunctionTag.ROUNDABOUT.name().toLowerCase())), (Atlas)object.getAtlas())));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private PolyLine buildOriginalOsmWayGeometry(Edge edge) {
        ArrayList sortedEdges = new ArrayList(new OsmWayWalker(edge).collectEdges());
        PolyLine geometry = new PolyLine(((Edge)sortedEdges.get(0)).getRawGeometry());
        for (int index = 1; index < sortedEdges.size(); ++index) {
            geometry = geometry.append(((Edge)sortedEdges.get(index)).asPolyLine());
        }
        return geometry;
    }

    private boolean intersectingWithMoreThan(Edge edge) {
        HashSet edgesFormingOSMWay = new HashSet(new OsmWayWalker(edge).collectEdges());
        HashSet connectedEdges = new HashSet();
        edgesFormingOSMWay.forEach(connectedEdge -> connectedEdge.connectedEdges().stream().filter(Edge::isMainEdge).filter(HighwayTag::isCarNavigableHighway).filter(obj -> obj.getTag("service").isEmpty()).forEach(wayId -> {
            if (wayId.getOsmIdentifier() != edge.getOsmIdentifier()) {
                connectedEdges.add(wayId.getOsmIdentifier());
            }
        }));
        return connectedEdges.size() >= 2;
    }

    private boolean isPartOfClosedWay(Edge edge) {
        return edge.inEdges().stream().filter(Edge::isMainEdge).filter(inEdge -> inEdge.getOsmIdentifier() == edge.getOsmIdentifier()).count() == 1L;
    }

    private boolean isTurningCircle(Edge edge) {
        Distance edge2;
        ArrayList edgesFormingOSMWay = new ArrayList(new OsmWayWalker(edge).collectEdges());
        if (edgesFormingOSMWay.size() != 2) {
            return false;
        }
        Distance edge1 = ((Edge)edgesFormingOSMWay.get(0)).asPolyLine().length();
        return edge1.isGreaterThan(edge2 = ((Edge)edgesFormingOSMWay.get(1)).asPolyLine().length()) ? edge1.asMeters() / edge2.asMeters() > (double)this.turningCircleLengthThreshold : edge2.asMeters() / edge1.asMeters() > (double)this.turningCircleLengthThreshold;
    }
}

