/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.linear.edges;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Route;
import org.openstreetmap.atlas.geography.atlas.items.complex.ComplexEntity;
import org.openstreetmap.atlas.geography.atlas.items.complex.roundabout.ComplexRoundabout;
import org.openstreetmap.atlas.geography.atlas.walker.SimpleEdgeWalker;
import org.openstreetmap.atlas.tags.BridgeTag;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.JunctionTag;
import org.openstreetmap.atlas.tags.LayerTag;
import org.openstreetmap.atlas.tags.SyntheticBoundaryNodeTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.TunnelTag;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class MalformedRoundaboutCheck
extends BaseCheck<Long> {
    private static final long serialVersionUID = -3018101860747289836L;
    private static final String BASIC_INSTRUCTION = "This roundabout is malformed.";
    private static final String ENCLOSED_ROADS_INSTRUCTIONS = "This roundabout has car navigable ways inside it.";
    private static final List<String> LEFT_DRIVING_COUNTRIES_DEFAULT = Arrays.asList("AIA", "ATG", "AUS", "BGD", "BHS", "BMU", "BRB", "BRN", "BTN", "BWA", "CCK", "COK", "CXR", "CYM", "CYP", "DMA", "FJI", "FLK", "GBR", "GGY", "GRD", "GUY", "HKG", "IDN", "IMN", "IND", "IRL", "JAM", "JEY", "JPN", "KEN", "KIR", "KNA", "LCA", "LKA", "LSO", "MAC", "MDV", "MLT", "MOZ", "MSR", "MUS", "MWI", "MYS", "NAM", "NFK", "NIU", "NPL", "NRU", "NZL", "PAK", "PCN", "PNG", "SGP", "SGS", "SHN", "SLB", "SUR", "SWZ", "SYC", "TCA", "THA", "TKL", "TLS", "TON", "TTO", "TUV", "TZA", "UGA", "VCT", "VGB", "VIR", "WSM", "ZAF", "ZMB", "ZWE");
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("This roundabout has car navigable ways inside it.", "This roundabout is malformed.");
    private final List<String> leftDrivingCountries;

    public MalformedRoundaboutCheck(Configuration configuration) {
        super(configuration);
        this.leftDrivingCountries = this.configurationValue(configuration, "traffic.countries.left", LEFT_DRIVING_COUNTRIES_DEFAULT);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Edge && object.getTag("iso_country_code").isPresent() && JunctionTag.isRoundabout((Taggable)object) && !this.isFlagged(object.getIdentifier()) && ((Edge)object).isMainEdge() && !this.isExcludedHighway(object) && !this.isEdgeWithSyntheticBoundaryNode(object);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        HashSet<String> instructions = new HashSet<String>();
        ComplexRoundabout complexRoundabout = new ComplexRoundabout((Edge)object, this.leftDrivingCountries);
        if (!complexRoundabout.isValid()) {
            instructions.addAll(complexRoundabout.getAllInvalidations().stream().map(ComplexEntity.ComplexEntityError::getReason).collect(Collectors.toSet()));
        }
        Set roundaboutEdgeSet = complexRoundabout.getRoundaboutEdgeSet();
        Route roundaboutEdges = complexRoundabout.getRoundaboutRoute();
        roundaboutEdgeSet.forEach(roundaboutEdge -> this.markAsFlagged(roundaboutEdge.getIdentifier()));
        if (!roundaboutEdgeSet.isEmpty() && roundaboutEdges != null && roundaboutEdgeSet.stream().noneMatch(this::ignoreBridgeTunnelCrossings) && this.roundaboutEnclosesRoads(roundaboutEdges)) {
            instructions.add(this.getLocalizedInstruction(0, new Object[0]));
        }
        if (!instructions.isEmpty()) {
            CheckFlag flag = this.createFlag((Set<AtlasObject>)roundaboutEdgeSet, this.getLocalizedInstruction(1, new Object[0]));
            instructions.forEach(flag::addInstruction);
            return Optional.of(flag);
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean ignoreBridgeTunnelCrossings(Edge edge) {
        return Validators.hasValuesFor((Taggable)edge, (Class[])new Class[]{LayerTag.class}) || BridgeTag.isBridge((Taggable)edge) || TunnelTag.isTunnel((Taggable)edge);
    }

    private boolean intersectsWithEnclosedGeometry(Polygon polygon, Edge edge) {
        PolyLine polyline = edge.asPolyLine();
        return polygon.intersections(polyline).stream().anyMatch(intersection -> !edge.start().getLocation().equals(intersection) && !edge.end().getLocation().equals(intersection) || polygon.fullyGeometricallyEncloses(polyline));
    }

    private boolean isEdgeWithSyntheticBoundaryNode(AtlasObject object) {
        return new SimpleEdgeWalker((Edge)object, this.isRoundaboutEdge()).collectEdges().stream().anyMatch(roundaboutEdge -> roundaboutEdge.connectedNodes().stream().anyMatch(SyntheticBoundaryNodeTag::isSyntheticBoundaryNode));
    }

    private boolean isExcludedHighway(AtlasObject object) {
        return Validators.isOfType((Taggable)object, HighwayTag.class, (Enum[])new HighwayTag[]{HighwayTag.CYCLEWAY, HighwayTag.PEDESTRIAN, HighwayTag.FOOTWAY});
    }

    private Function<Edge, Stream<Edge>> isRoundaboutEdge() {
        return edge -> edge.connectedEdges().stream().filter(connected -> JunctionTag.isRoundabout((Taggable)connected) && !this.isExcludedHighway((AtlasObject)connected));
    }

    private boolean roundaboutEnclosesRoads(Route roundabout) {
        Polygon roundaboutPoly = new Polygon((Iterable)roundabout.asPolyLine());
        return roundabout.start().getAtlas().edgesIntersecting((GeometricSurface)roundaboutPoly, edge -> edge.isMainEdge() && HighwayTag.isCarNavigableHighway((Taggable)edge) && !JunctionTag.isRoundabout((Taggable)edge) && edge.getTag("area").isEmpty() && !this.ignoreBridgeTunnelCrossings((Edge)edge) && this.intersectsWithEnclosedGeometry(roundaboutPoly, (Edge)edge)).iterator().hasNext();
    }
}

