/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.linear;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.tags.NaturalTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.WaterTag;
import org.openstreetmap.atlas.tags.WaterwayTag;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public class MalformedPolyLineCheck
extends BaseCheck<Long> {
    private static final Distance MAXIMUM_LENGTH = Distance.kilometers((double)100.0);
    private static final int MAXIMUM_POINTS = 500;
    private static final String MAX_LENGTH_INSTRUCTION = "Line is {0}, which is longer than the maximum of {1}";
    private static final String MAX_POINTS_INSTRUCTION = "Line contains {0} points more than maximum of {1}";
    private static final String MAX_POINTS_MAX_LENGTH_INSTRUCTION = "Line contains {0} points more than maximum of {1} and line is {2}, which is longer than the maximum of {3}";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("Line contains {0} points more than maximum of {1}", "Line is {0}, which is longer than the maximum of {1}", "Line contains {0} points more than maximum of {1} and line is {2}, which is longer than the maximum of {3}");
    private static final long serialVersionUID = -6190296606600063334L;
    private static final WaterwayTag[] WATERWAY_TAGS = new WaterwayTag[]{WaterwayTag.CANAL, WaterwayTag.STREAM, WaterwayTag.RIVER, WaterwayTag.RIVERBANK};

    public MalformedPolyLineCheck(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Edge && ((Edge)object).isMainEdge() || object instanceof Line;
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        LineItem line = (LineItem)object;
        int numberPoints = Iterables.asList((Iterable)line.getRawGeometry()).size();
        Distance length = line.asPolyLine().length();
        if (this.isComplexPolyLine(line) || this.isMemberOfRelationWithWaterTag(line)) {
            return Optional.empty();
        }
        if (numberPoints > 500 && length.isGreaterThan(MAXIMUM_LENGTH)) {
            return Optional.of(this.createFlag(object, this.getLocalizedInstruction(2, numberPoints, 500, length, MAXIMUM_LENGTH)));
        }
        if (numberPoints < 1 || numberPoints > 500) {
            return Optional.of(this.createFlag(object, this.getLocalizedInstruction(0, numberPoints, 500)));
        }
        if (length.isGreaterThan(MAXIMUM_LENGTH)) {
            return Optional.of(this.createFlag(object, this.getLocalizedInstruction(1, length, MAXIMUM_LENGTH)));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean isComplexPolyLine(LineItem line) {
        return Validators.isOfType((Taggable)line, WaterwayTag.class, (Enum[])WATERWAY_TAGS) || Validators.isOfType((Taggable)line, NaturalTag.class, (Enum[])new NaturalTag[]{NaturalTag.COASTLINE}) || Validators.isOfType((Taggable)line, NaturalTag.class, (Enum[])new NaturalTag[]{NaturalTag.WATER}) && Validators.isOfType((Taggable)line, WaterTag.class, (Enum[])new WaterTag[]{WaterTag.RIVER});
    }

    private boolean isMemberOfRelationWithWaterTag(LineItem line) {
        return line.relations().stream().anyMatch(relation -> Validators.isOfType((Taggable)relation, NaturalTag.class, (Enum[])new NaturalTag[]{NaturalTag.WATER}));
    }
}

