/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.intersections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.checks.utility.IntersectionUtilities;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.tags.AmenityTag;
import org.openstreetmap.atlas.tags.BridgeTag;
import org.openstreetmap.atlas.tags.BuildingTag;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.filters.TaggableFilter;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class OceanBleedingCheck
extends BaseCheck<Long> {
    private final TaggableFilter validOceanTags;
    private static final String DEFAULT_INVALID_OCEAN_TAGS = "man_made->breakwater,pier|natural->beach,marsh,swamp|water->marsh|wetland->bog,fen,mangrove,marsh,saltern,saltmarsh,string_bog,swamp,wet_meadow|landuse->*";
    private final TaggableFilter invalidOceanTags;
    private final TaggableFilter oceanBoundaryTags;
    private static final String DEFAULT_OFFENDING_MISCELLANEOUS_LINEITEMS = "railway->rail,narrow_gauge,preserved,subway,disused,monorail,tram,light_rail,funicular,construction,miniature";
    private final TaggableFilter defaultOffendingLineitems;
    private static final String DEFAULT_HIGHWAY_MINIMUM = "TOLL_GANTRY";
    private final HighwayTag highwayMinimum;
    private static final List<String> DEFAULT_HIGHWAYS_EXCLUDE = Collections.emptyList();
    private final List<HighwayTag> highwaysExclude;
    private static final String OCEAN_INSTRUCTION = "Ocean feature {0,number,#} has invalid intersections. ";
    private static final String BLEEDING_BUILDING_INSTRUCTION = "Building {0,number,#} intersects the ocean feature. ";
    private static final String BLEEDING_LINEITEM_INSTRUCTION = "Way {0,number,#} intersects the ocean feature. ";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("Building {0,number,#} intersects the ocean feature. ", "Way {0,number,#} intersects the ocean feature. ", "Ocean feature {0,number,#} has invalid intersections. ");
    private static final long serialVersionUID = -2229281211747728380L;

    public OceanBleedingCheck(Configuration configuration) {
        super(configuration);
        this.validOceanTags = TaggableFilter.forDefinition((String)this.configurationValue(configuration, "ocean.valid", "natural->strait,channel,fjord,sound,bay|harbour->*&harbour->!no|estuary->*&estuary->!no|bay->*&bay->!no|place->sea|seamark:type->harbour,harbour_basin,sea_area|water->bay,cove,harbour|waterway->artificial,dock"));
        this.invalidOceanTags = TaggableFilter.forDefinition((String)this.configurationValue(configuration, "ocean.invalid", DEFAULT_INVALID_OCEAN_TAGS));
        this.defaultOffendingLineitems = TaggableFilter.forDefinition((String)this.configurationValue(configuration, "lineItems.offending", DEFAULT_OFFENDING_MISCELLANEOUS_LINEITEMS));
        this.highwayMinimum = Enum.valueOf(HighwayTag.class, this.configurationValue(configuration, "highway.minimum", DEFAULT_HIGHWAY_MINIMUM).toUpperCase());
        this.highwaysExclude = this.configurationValue(configuration, "highway.exclude", DEFAULT_HIGHWAYS_EXCLUDE).stream().map(element -> Enum.valueOf(HighwayTag.class, element.toUpperCase())).collect(Collectors.toList());
        this.oceanBoundaryTags = TaggableFilter.forDefinition((String)this.configurationValue(configuration, "ocean.boundary", "natural->coastline"));
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return (object instanceof Area || object instanceof LineItem) && (this.validOceanTags.test((Taggable)object) && !this.invalidOceanTags.test((Taggable)object) || this.oceanBoundaryTags.test((Taggable)object));
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        boolean oceanIsArea = object instanceof Area;
        Polygon oceanBoundary = oceanIsArea ? ((Area)object).asPolygon() : new Polygon((Iterable)((LineItem)object).asPolyLine());
        boolean oceanFeatureIsAWaterBody = this.validOceanTags.test((Taggable)object);
        ArrayList<LineItem> offendingLineItems = new ArrayList<LineItem>();
        ArrayList<Area> offendingBuildings = new ArrayList<Area>();
        if (oceanIsArea && oceanFeatureIsAWaterBody) {
            Iterable intersectingLinearFeatures = object.getAtlas().lineItemsIntersecting((GeometricSurface)oceanBoundary, this.isInvalidlyInteractingWithOcean((PolyLine)oceanBoundary));
            Iterable intersectingBuildingFeatures = object.getAtlas().areasIntersecting((GeometricSurface)oceanBoundary, BuildingTag::isBuilding);
            intersectingLinearFeatures.forEach(offendingLineItems::add);
            intersectingBuildingFeatures.forEach(offendingBuildings::add);
        } else {
            Iterable intersectingLinearFeatures = object.getAtlas().lineItemsIntersecting((GeometricSurface)oceanBoundary, lineItem -> (oceanIsArea && !oceanBoundary.fullyGeometricallyEncloses(lineItem.asPolyLine()) || object instanceof LineItem && ((LineItem)object).asPolyLine().intersects(lineItem.asPolyLine())) && this.isInvalidlyInteractingWithOcean((PolyLine)(oceanIsArea ? oceanBoundary : ((LineItem)object).asPolyLine())).test((LineItem)lineItem));
            Iterable intersectingBuildingFeatures = object.getAtlas().areasIntersecting((GeometricSurface)oceanBoundary, area -> (oceanIsArea && !oceanBoundary.fullyGeometricallyEncloses((PolyLine)area.asPolygon()) || object instanceof LineItem && ((LineItem)object).asPolyLine().intersects((PolyLine)area.asPolygon())) && BuildingTag.isBuilding((Taggable)area));
            intersectingLinearFeatures.forEach(offendingLineItems::add);
            intersectingBuildingFeatures.forEach(offendingBuildings::add);
        }
        return this.generateFlag(object, offendingLineItems, offendingBuildings);
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private Optional<CheckFlag> generateFlag(AtlasObject object, ArrayList<LineItem> offendingLineItems, ArrayList<Area> offendingBuildings) {
        HashSet flaggedObjects = new HashSet();
        StringBuilder instructions = new StringBuilder();
        instructions.append(this.getLocalizedInstruction(2, object.getOsmIdentifier()));
        offendingBuildings.forEach(building -> {
            flaggedObjects.add(building);
            instructions.append(this.getLocalizedInstruction(0, building.getOsmIdentifier()));
        });
        HashSet seenLineItems = new HashSet();
        offendingLineItems.forEach(lineItem -> {
            flaggedObjects.add(lineItem);
            if (!seenLineItems.contains(lineItem.getOsmIdentifier())) {
                instructions.append(this.getLocalizedInstruction(1, lineItem.getOsmIdentifier()));
                seenLineItems.add(lineItem.getOsmIdentifier());
            }
        });
        return flaggedObjects.isEmpty() ? Optional.empty() : Optional.of(this.createFlag(flaggedObjects, instructions.toString()));
    }

    private Predicate<LineItem> isInvalidlyInteractingWithOcean(PolyLine oceanFeature) {
        return lineItem -> {
            if (BridgeTag.isBridge((Taggable)lineItem)) {
                return false;
            }
            if (!(lineItem instanceof Edge)) {
                return this.defaultOffendingLineitems.test((Taggable)lineItem);
            }
            if (!this.validHighwayType().test((Edge)lineItem)) {
                return false;
            }
            if (IntersectionUtilities.haveExplicitLocationsForIntersections(oceanFeature, lineItem)) {
                Set intersections = oceanFeature.intersections(lineItem.asPolyLine());
                if (!intersections.contains(((Edge)lineItem).start().getLocation()) && !intersections.contains(((Edge)lineItem).end().getLocation())) {
                    return true;
                }
                return ((Edge)lineItem).connectedNodes().stream().filter(node -> intersections.contains(node.getLocation())).anyMatch(node -> !node.getTag("amenity").orElse("").equalsIgnoreCase(AmenityTag.FERRY_TERMINAL.name()));
            }
            return true;
        };
    }

    private Predicate<Edge> validHighwayType() {
        return edge -> edge.highwayTag().isMoreImportantThanOrEqualTo(this.highwayMinimum) && !this.highwaysExclude.contains(edge.highwayTag());
    }
}

