/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.intersections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.LocationItem;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.LayerTag;
import org.openstreetmap.atlas.tags.RailwayTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.tags.filters.TaggableFilter;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class LevelCrossingOnRailwayCheck
extends BaseCheck<Long> {
    private static final String RAILWAY_FILTER_DEFAULT = "railway->rail,tram,disused,preserved,miniature,light_rail,subway,narrow_gauge";
    private final TaggableFilter railwayFilter;
    private static final Long OSM_LAYER_DEFAULT = 0L;
    private final Long layerDefault;
    private static final String INVALID_TAGGED_OBJECT = "The object (OSM ID: {0,number,#}) has `railway=level_crossing` but is not a node. To fix: Remove `railway=level_crossing` tag.";
    private static final int INVALID_TAGGED_OBJECT_INDEX = 0;
    private static final String NODE_MISSING_LC_TAG = "The intersection node (OSM ID: {0,number,#}) is missing a `railway=level_crossing` tag. This means that there are at least one valid railway and one car navigable highway on the same layer at this node. To fix: If the two ways should be on different layers then adjust the layer tags for each way appropriately. If the two ways do intersect on the same layer then add the `railway=level_crossing` tag to this node.";
    private static final int NODE_MISSING_LC_TAG_INDEX = 1;
    private static final String NODE_INVALID_LC_TAG_NO_HIGHWAY = "The node (OSM ID: {0,number,#}) has `railway=level_crossing` tag, but there is no car navigable highway at this intersection. To fix: Remove railway=level_crossing tag.";
    private static final int NODE_INVALID_LC_TAG_NO_HIGHWAY_INDEX = 2;
    private static final String NODE_INVALID_LC_TAG_NO_RAILWAY = "The node (OSM ID: {0,number,#}) has `railway=level_crossing` tag, but there are no existing rails at this intersection. To fix: Remove railway=level_crossing tag.";
    private static final int NODE_INVALID_LC_TAG_NO_RAILWAY_INDEX = 3;
    private static final String NODE_INVALID_LC_TAG_LAYERS = "The node (OSM ID: {0,number,#}) has `railway=level_crossing` tag, but there are no railway and highway intersection on the same layer. To fix: If the railway and highway should be on the same layer then update the layer tags for both ways to be equal. If the ways are on different layers then remove railway=level_crossing tag.";
    private static final int NODE_INVALID_LC_TAG_LAYERS_INDEX = 4;
    private static final String INTERSECTION_MISSING_NODE = "The railway (OSM ID: {0,number,#}) has one or more car navigable intersections on the same layer that are missing intersection nodes. To fix: If highway and railway do cross at the same layer then add appropriate intersection node(s) with `railway=level_crossing` tag. If highway and railway are on different layers then update the appropriate layer tag for the way that goes under or over the other way.";
    private static final int INTERSECTION_MISSING_NODE_INDEX = 5;
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("The object (OSM ID: {0,number,#}) has `railway=level_crossing` but is not a node. To fix: Remove `railway=level_crossing` tag.", "The intersection node (OSM ID: {0,number,#}) is missing a `railway=level_crossing` tag. This means that there are at least one valid railway and one car navigable highway on the same layer at this node. To fix: If the two ways should be on different layers then adjust the layer tags for each way appropriately. If the two ways do intersect on the same layer then add the `railway=level_crossing` tag to this node.", "The node (OSM ID: {0,number,#}) has `railway=level_crossing` tag, but there is no car navigable highway at this intersection. To fix: Remove railway=level_crossing tag.", "The node (OSM ID: {0,number,#}) has `railway=level_crossing` tag, but there are no existing rails at this intersection. To fix: Remove railway=level_crossing tag.", "The node (OSM ID: {0,number,#}) has `railway=level_crossing` tag, but there are no railway and highway intersection on the same layer. To fix: If the railway and highway should be on the same layer then update the layer tags for both ways to be equal. If the ways are on different layers then remove railway=level_crossing tag.", "The railway (OSM ID: {0,number,#}) has one or more car navigable intersections on the same layer that are missing intersection nodes. To fix: If highway and railway do cross at the same layer then add appropriate intersection node(s) with `railway=level_crossing` tag. If highway and railway are on different layers then update the appropriate layer tag for the way that goes under or over the other way.");
    private static final List<String> CONSTRUCTION_TAGS = List.of("highway", "railway");
    private static final long serialVersionUID = -2063033332877849846L;

    public LevelCrossingOnRailwayCheck(Configuration configuration) {
        super(configuration);
        this.layerDefault = this.configurationValue(configuration, "layer.default", OSM_LAYER_DEFAULT);
        this.railwayFilter = this.configurationValue(configuration, "railway.filter", RAILWAY_FILTER_DEFAULT, TaggableFilter::forDefinition);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Node || Validators.isOfType((Taggable)object, RailwayTag.class, (Enum[])new RailwayTag[]{RailwayTag.LEVEL_CROSSING}) || this.railwayFilter.test((Taggable)object);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Optional<CheckFlag> flagIncorrectlyTagged = this.flagIncorrectlyTagged(object);
        if (!flagIncorrectlyTagged.isEmpty()) {
            return flagIncorrectlyTagged;
        }
        Optional<CheckFlag> flagNonNodeTagged = this.flagNonNodeTagged(object);
        if (!flagNonNodeTagged.isEmpty()) {
            return flagNonNodeTagged;
        }
        Optional<CheckFlag> flagInvalidIntersections = this.flagInvalidIntersections(object);
        if (!flagInvalidIntersections.isEmpty()) {
            return flagInvalidIntersections;
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private Optional<CheckFlag> flagIncorrectlyTagged(AtlasObject object) {
        if (object instanceof Node) {
            Node node = (Node)object;
            NodeCheck nodeCheck = this.isValidLevelCrossingNode(node);
            if (Validators.isOfType((Taggable)node, RailwayTag.class, (Enum[])new RailwayTag[]{RailwayTag.LEVEL_CROSSING}) && nodeCheck != NodeCheck.NODE_VALID && nodeCheck != NodeCheck.NODE_IGNORE) {
                int instructIndex;
                switch (nodeCheck) {
                    case NODE_NO_RAILWAY: {
                        instructIndex = 3;
                        break;
                    }
                    case NODE_NO_HIGHWAY: {
                        instructIndex = 2;
                        break;
                    }
                    default: {
                        instructIndex = 4;
                    }
                }
                return Optional.of(this.createFlag(object, this.getLocalizedInstruction(instructIndex, object.getOsmIdentifier())).addFixSuggestion(FeatureChange.add((AtlasEntity)((AtlasEntity)((CompleteEntity)CompleteEntity.from((AtlasEntity)((AtlasEntity)object))).withRemovedTag("railway")), (Atlas)object.getAtlas())));
            }
            if (!Validators.isOfType((Taggable)node, RailwayTag.class, (Enum[])new RailwayTag[]{RailwayTag.LEVEL_CROSSING}) && nodeCheck == NodeCheck.NODE_VALID) {
                return Optional.of(this.createFlag(object, this.getLocalizedInstruction(1, object.getOsmIdentifier())).addFixSuggestion(FeatureChange.add((AtlasEntity)((AtlasEntity)((CompleteEntity)CompleteEntity.from((AtlasEntity)((AtlasEntity)object))).withAddedTag("railway", RailwayTag.LEVEL_CROSSING.toString().toLowerCase())), (Atlas)object.getAtlas())));
            }
        }
        return Optional.empty();
    }

    private Optional<CheckFlag> flagInvalidIntersections(AtlasObject object) {
        if (object instanceof Line && this.railwayFilter.test((Taggable)object)) {
            Line railway = (Line)object;
            Atlas atlas = railway.getAtlas();
            ArrayList<Location> badIntersectingHighways = new ArrayList<Location>();
            Iterables.asList((Iterable)atlas.edgesIntersecting((GeometricSurface)railway.bounds())).forEach(highway -> badIntersectingHighways.addAll(this.missingNodesAtIntersectionOnSameLayer(railway, (Edge)highway)));
            if (!badIntersectingHighways.isEmpty()) {
                return Optional.of(this.createFlag(object, this.getLocalizedInstruction(5, railway.getOsmIdentifier()), badIntersectingHighways));
            }
        }
        return Optional.empty();
    }

    private Optional<CheckFlag> flagNonNodeTagged(AtlasObject object) {
        if (!(object instanceof LocationItem) && Validators.isOfType((Taggable)object, RailwayTag.class, (Enum[])new RailwayTag[]{RailwayTag.LEVEL_CROSSING})) {
            return Optional.of(this.createFlag(object, this.getLocalizedInstruction(0, object.getOsmIdentifier())).addFixSuggestion(FeatureChange.add((AtlasEntity)((AtlasEntity)((CompleteEntity)CompleteEntity.from((AtlasEntity)((AtlasEntity)object))).withRemovedTag("railway")), (Atlas)object.getAtlas())));
        }
        return Optional.empty();
    }

    private boolean ignoreWay(AtlasObject object) {
        return object.getTags().keySet().stream().anyMatch(tag -> tag.equals("construction") || tag.startsWith("construction:") && !tag.equals("construction:date")) || CONSTRUCTION_TAGS.stream().anyMatch(tag -> "construction".equals(object.getTags().get(tag))) || HighwayTag.highwayTag((Taggable)object).isPresent() && RailwayTag.isRailway((Taggable)object) || Validators.isOfType((Taggable)object, RailwayTag.class, (Enum[])new RailwayTag[]{RailwayTag.PROPOSED});
    }

    private NodeCheck isValidLevelCrossingNode(Node node) {
        Atlas atlas = node.getAtlas();
        if (Iterables.asList((Iterable)atlas.itemsContaining(node.getLocation())).stream().anyMatch(this::ignoreWay)) {
            return NodeCheck.NODE_IGNORE;
        }
        List connectedRailways = Iterables.asList((Iterable)atlas.itemsContaining(node.getLocation())).stream().filter(arg_0 -> ((TaggableFilter)this.railwayFilter).test(arg_0)).collect(Collectors.toList());
        if (connectedRailways.isEmpty()) {
            return NodeCheck.NODE_NO_RAILWAY;
        }
        List connectedHighways = Iterables.asList((Iterable)atlas.itemsContaining(node.getLocation())).stream().filter(HighwayTag::isCarNavigableHighway).collect(Collectors.toList());
        if (connectedHighways.isEmpty()) {
            return NodeCheck.NODE_NO_HIGHWAY;
        }
        for (AtlasObject railway : connectedRailways) {
            Long railwayLayer = LayerTag.getTaggedOrImpliedValue((Taggable)railway, (Long)this.layerDefault);
            for (AtlasObject highway : connectedHighways) {
                Long highwayLayer = LayerTag.getTaggedOrImpliedValue((Taggable)highway, (Long)this.layerDefault);
                if (!railwayLayer.equals(highwayLayer) || railway.getOsmIdentifier() == highway.getOsmIdentifier()) continue;
                return NodeCheck.NODE_VALID;
            }
        }
        return NodeCheck.NODE_NO_LAYERS;
    }

    private List<Location> missingNodesAtIntersectionOnSameLayer(Line railway, Edge highway) {
        Long railwayLayer = LayerTag.getTaggedOrImpliedValue((Taggable)railway, (Long)this.layerDefault);
        Long highwayLayer = LayerTag.getTaggedOrImpliedValue((Taggable)highway, (Long)this.layerDefault);
        if (Edge.isMainEdgeIdentifier((long)highway.getIdentifier()) && HighwayTag.isCarNavigableHighway((Taggable)highway) && !this.ignoreWay((AtlasObject)railway) && !this.ignoreWay((AtlasObject)highway) && railwayLayer.equals(highwayLayer)) {
            return railway.asPolyLine().intersections(highway.asPolyLine()).stream().filter(location -> !railway.asPolyLine().contains(location) || !highway.asPolyLine().contains(location)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static enum NodeCheck {
        NODE_IGNORE,
        NODE_VALID,
        NODE_NO_RAILWAY,
        NODE_NO_HIGHWAY,
        NODE_NO_LAYERS;

    }
}

