/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.areas;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.Segment;
import org.openstreetmap.atlas.geography.Snapper;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.tags.AreaTag;
import org.openstreetmap.atlas.tags.FootTag;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.LayerTag;
import org.openstreetmap.atlas.tags.LevelTag;
import org.openstreetmap.atlas.tags.ServiceTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public class PedestrianAreaOverlappingEdgeCheck
extends BaseCheck<Long> {
    private static final long serialVersionUID = 1861527706740836635L;
    private static final List<String> FALLBACK_INSTRUCTIONS = Collections.singletonList("Pedestrian area {0,number,#} is overlapping way id(s) {1} and is not snapped at all points of intersections.");
    private static final String ZERO = "0";
    private static final Long ZERO_LONG = 0L;
    private static final double DISTANCE_MINIMUM_METERS_DEFAULT = 1.0;
    private final Distance minimumDistance;

    public PedestrianAreaOverlappingEdgeCheck(Configuration configuration) {
        super(configuration);
        this.minimumDistance = this.configurationValue(configuration, "distance.minimum.meters", 1.0, Distance::meters);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Area && this.isPedestrianArea(object) && !this.isFlagged(object.getOsmIdentifier());
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Area area = (Area)object;
        Polygon areaPolygon = area.asPolygon();
        List segments = areaPolygon.segments();
        List locationsInSegments = Segment.asList((Iterable)segments);
        Set filteredIntersectingEdges = Iterables.stream((Iterable)area.getAtlas().edgesIntersecting((GeometricSurface)areaPolygon)).filter(edge -> this.isValidIntersectingEdge((Edge)edge, area)).collectToSet();
        HashSet<AtlasObject> overlappingEdges = new HashSet<AtlasObject>();
        for (Edge edge2 : filteredIntersectingEdges) {
            edge2.asPolyLine().segments().forEach(segment -> {
                block3: {
                    block2: {
                        Location edgeSegmentStartLocation = segment.start();
                        Location edgeSegmentEndLocation = segment.end();
                        Snapper.SnappedLocation snappedStartLoc = edgeSegmentStartLocation.snapTo((PolyLine)areaPolygon);
                        Snapper.SnappedLocation snappedEndLoc = edgeSegmentEndLocation.snapTo((PolyLine)areaPolygon);
                        Distance startLocDistance = snappedStartLoc.getDistance();
                        Distance endLocDistance = snappedEndLoc.getDistance();
                        boolean intersectsAtStart = locationsInSegments.contains(edgeSegmentStartLocation);
                        boolean intersectsAtEnd = locationsInSegments.contains(edgeSegmentEndLocation);
                        if (intersectsAtStart && intersectsAtEnd && this.isNotSnappedToSegments(segments, (Segment)segment) || intersectsAtStart && !intersectsAtEnd && endLocDistance.isGreaterThanOrEqualTo(this.minimumDistance) && areaPolygon.fullyGeometricallyEncloses(edgeSegmentEndLocation)) break block2;
                        if (!intersectsAtEnd || intersectsAtStart || !startLocDistance.isGreaterThanOrEqualTo(this.minimumDistance) || !areaPolygon.fullyGeometricallyEncloses(edgeSegmentStartLocation)) break block3;
                    }
                    edge2.connectedEdges().stream().filter(connectedEdge -> this.isValidIntersectingEdge((Edge)connectedEdge, area) && areaPolygon.fullyGeometricallyEncloses(connectedEdge.asPolyLine())).forEach(overlappingEdges::add);
                    overlappingEdges.add((AtlasObject)edge2);
                }
            });
        }
        if (!overlappingEdges.isEmpty()) {
            this.markAsFlagged(object.getOsmIdentifier());
            CheckFlag flag = this.createFlag(overlappingEdges, this.getLocalizedInstruction(0, object.getOsmIdentifier(), new StringList(this.getIdentifiers(overlappingEdges)).join(", ")));
            flag.addObject(object);
            return Optional.of(flag);
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private Iterable<String> getIdentifiers(Set<AtlasObject> objects) {
        return Iterables.stream(objects).map(AtlasObject::getIdentifier).map(String::valueOf).collectToList();
    }

    private boolean isNotSnappedToSegments(List<Segment> segments, Segment segment) {
        return segments.stream().noneMatch(areaSegment -> areaSegment.overlapsShapeOf((PolyLine)segment));
    }

    private boolean isOfSameElevation(Edge edge, Area area) {
        return LevelTag.getTaggedOrImpliedValue((Taggable)area, (String)ZERO).equals(LevelTag.getTaggedOrImpliedValue((Taggable)edge, (String)ZERO)) && LayerTag.getTaggedOrImpliedValue((Taggable)area, (Long)ZERO_LONG).equals(LayerTag.getTaggedOrImpliedValue((Taggable)edge, (Long)ZERO_LONG));
    }

    private boolean isPedestrianArea(AtlasObject object) {
        return Validators.isOfType((Taggable)object, AreaTag.class, (Enum[])new AreaTag[]{AreaTag.YES}) && Validators.isOfType((Taggable)object, HighwayTag.class, (Enum[])new HighwayTag[]{HighwayTag.PEDESTRIAN});
    }

    private boolean isValidIntersectingEdge(Edge edge, Area area) {
        return edge.getOsmIdentifier() != area.getOsmIdentifier() && edge.isMainEdge() && !HighwayTag.isPedestrianNavigableHighway((Taggable)edge) && (HighwayTag.isCarNavigableHighway((Taggable)edge) || Validators.isOfType((Taggable)edge, HighwayTag.class, (Enum[])new HighwayTag[]{HighwayTag.CYCLEWAY}) && Validators.isOfType((Taggable)edge, FootTag.class, (Enum[])new FootTag[]{FootTag.NO}) || Validators.isOfType((Taggable)edge, ServiceTag.class, (Enum[])new ServiceTag[]{ServiceTag.ALLEY, ServiceTag.PARKING_AISLE, ServiceTag.DRIVEWAY, ServiceTag.EMERGENCY_ACCESS, ServiceTag.DRIVE_THROUGH})) && this.isOfSameElevation(edge, area);
    }
}

