/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.utility;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.openstreetmap.atlas.checks.event.CheckFlagEvent;
import org.openstreetmap.atlas.checks.flag.CheckFlag;

public class UniqueCheckFlagContainer
implements Serializable {
    private final ConcurrentHashMap<String, ConcurrentHashMap<Set<String>, CheckFlag>> uniqueFlags;

    public static UniqueCheckFlagContainer combine(UniqueCheckFlagContainer container1, UniqueCheckFlagContainer container2) {
        container2.uniqueFlags.entrySet().forEach(entry -> container1.addAll((String)entry.getKey(), ((ConcurrentHashMap)entry.getValue()).values()));
        return container1;
    }

    public UniqueCheckFlagContainer() {
        this.uniqueFlags = new ConcurrentHashMap();
    }

    private UniqueCheckFlagContainer(ConcurrentHashMap<String, ConcurrentHashMap<Set<String>, CheckFlag>> flags) {
        this.uniqueFlags = flags;
    }

    public void add(String flagSource, CheckFlag flag) {
        this.uniqueFlags.putIfAbsent(flagSource, new ConcurrentHashMap());
        Set<String> uniqueObjectIdentifiers = flag.getUniqueIdentifiers();
        this.uniqueFlags.get(flagSource).putIfAbsent(uniqueObjectIdentifiers.isEmpty() ? Collections.singleton(flag.getIdentifier()) : uniqueObjectIdentifiers, flag);
    }

    public void addAll(String flagSource, Iterable<CheckFlag> flags) {
        flags.forEach(flag -> this.add(flagSource, (CheckFlag)flag));
    }

    public Stream<CheckFlagEvent> reconstructEvents() {
        return this.uniqueFlags.keySet().stream().flatMap(checkName -> this.uniqueFlags.get(checkName).values().stream().map(checkFlag -> new CheckFlagEvent((String)checkName, (CheckFlag)checkFlag)));
    }

    public Stream<CheckFlag> stream() {
        return this.uniqueFlags.values().stream().map(ConcurrentHashMap::values).flatMap(Collection::stream);
    }
}

