/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.utility;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;
import org.openstreetmap.atlas.checks.utility.CompressionUtilities;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Longitude;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public final class ElevationUtilities
implements Serializable {
    private static final long serialVersionUID = -5929570973909280629L;
    private static final String SRTM_EXTENSION = "hgt";
    private static final double SRTM_EXTENT = 1.0;
    public static final short NO_ELEVATION = Short.MIN_VALUE;
    private static final short[][] EMPTY_MAP = new short[0][];
    private static final int DECIMAL_TO_PERCENTAGE = 100;
    private final Map<Pair<Integer, Integer>, short[][]> loadedSrtm = new HashMap<Pair<Integer, Integer>, short[][]>();
    private final double srtmExtent;
    private final String srtmExtension;
    private final String srtmPath;

    private static String configurationKey(String key) {
        return ElevationUtilities.formatKey(ElevationUtilities.class.getSimpleName(), key);
    }

    private static <U, V> V configurationValue(Configuration configuration, String key, U defaultValue, Function<U, V> transform) {
        return (V)configuration.get(ElevationUtilities.configurationKey(key), defaultValue, transform).value();
    }

    private static String formatKey(String name, String key) {
        return String.format("%s.%s", name, key);
    }

    public ElevationUtilities(Configuration configuration) {
        this((Double)ElevationUtilities.configurationValue(configuration, "elevation.srtm_extent", 1.0, Function.identity()), (String)ElevationUtilities.configurationValue(configuration, "elevation.srtm_ext", SRTM_EXTENSION, Function.identity()), (String)ElevationUtilities.configurationValue(configuration, "elevation.path", "elevation", Function.identity()));
    }

    public ElevationUtilities(double srtmExtent, String srtmExtension, String srtmPath) {
        this.srtmExtension = srtmExtension;
        this.srtmExtent = srtmExtent;
        this.srtmPath = srtmPath;
    }

    public short getElevation(Location location) {
        short[][] map = this.getMap(location);
        if (Arrays.equals((Object[])EMPTY_MAP, (Object[])map)) {
            return Short.MIN_VALUE;
        }
        int[] index = this.getIndex(location, map.length);
        return map[index[0]][index[1]];
    }

    public double getIncline(Location start, Location end) {
        short startElevation = this.getElevation(start);
        short endElevation = this.getElevation(end);
        if (startElevation == Short.MIN_VALUE || endElevation == Short.MIN_VALUE) {
            return Double.NaN;
        }
        double distance = end.distanceTo(start).asMeters();
        return (double)(endElevation - startElevation) / distance * 100.0;
    }

    public int[] getIndex(Location location, int mapSize) {
        double latDegrees = location.getLatitude().asDegrees();
        double lonDegrees = location.getLongitude().asDegrees();
        float fraction = (float)this.srtmExtent / (float)mapSize;
        int latitude = (int)Math.floor(Math.abs(latDegrees - (double)((int)latDegrees)) / (double)fraction);
        int longitude = (int)Math.floor(Math.abs(lonDegrees - (double)((int)lonDegrees)) / (double)fraction);
        if (latDegrees >= 0.0) {
            latitude = mapSize - 1 - latitude;
        }
        if (lonDegrees < 0.0) {
            longitude = mapSize - 1 - longitude;
        }
        return new int[]{latitude, longitude};
    }

    public short[][] getMap(Location location) {
        double latDegrees = location.getLatitude().asDegrees();
        double lonDegrees = location.getLongitude().asDegrees();
        int lat = (int)Math.floor(latDegrees);
        int lon = (int)Math.floor(lonDegrees);
        return this.loadedSrtm.computeIfAbsent((Pair<Integer, Integer>)Pair.of((Object)lat, (Object)lon), pair -> this.loadMap((Integer)pair.getLeft(), (Integer)pair.getRight()));
    }

    public Distance getResolution(Location location) {
        short[][] map = this.getMap(location);
        if (Arrays.equals((Object[])EMPTY_MAP, (Object[])map)) {
            return Distance.MAXIMUM;
        }
        float difference = (float)this.srtmExtent / (float)map.length;
        Location temp = new Location(location.getLatitude(), Longitude.degrees((double)(location.getLongitude().asDegrees() + (double)difference)));
        return temp.distanceTo(location);
    }

    public String getSrtmFileName(int latitude, int longitude) {
        int lat = latitude;
        int lon = longitude;
        String latPrefix = "N";
        if (lat < 0) {
            lat = Math.abs(lat);
            latPrefix = "S";
        }
        String lonPrefix = "E";
        if (lon < 0) {
            lon = Math.abs(lon);
            lonPrefix = "W";
        }
        return String.format("%s%02d%s%03d.%s", latPrefix, lat, lonPrefix, lon, this.srtmExtension);
    }

    public boolean inSameDataPoint(Location one, Location two) {
        int[] indexTwo;
        int[] indexOne;
        short[][] mapTwo;
        short[][] mapOne = this.getMap(one);
        return Arrays.equals((Object[])mapOne, (Object[])(mapTwo = this.getMap(two))) && !Arrays.equals((Object[])EMPTY_MAP, (Object[])mapOne) && Arrays.equals(indexOne = this.getIndex(one, mapOne.length), indexTwo = this.getIndex(two, mapTwo.length));
    }

    public void putMap(Location location, short[][] map) {
        double latDegrees = location.getLatitude().asDegrees();
        double lonDegrees = location.getLongitude().asDegrees();
        int lat = (int)Math.floor(latDegrees);
        int lon = (int)Math.floor(lonDegrees);
        this.loadedSrtm.put((Pair<Integer, Integer>)Pair.of((Object)lat, (Object)lon), map);
    }

    private synchronized short[][] loadMap(int lat, int lon) {
        short[][] sArray;
        block11: {
            String filename = this.getSrtmFileName(lat, lon);
            Path path = Paths.get(this.srtmPath, filename);
            if (!path.toFile().isFile()) {
                for (String ext : new String[]{"zip", "gz", "xz", "bz", "bz2", "tar"}) {
                    path = Paths.get(this.srtmPath, filename + "." + ext);
                    if (path.toFile().isFile()) break;
                }
            }
            if (!path.toFile().isFile()) {
                return EMPTY_MAP;
            }
            InputStream is = CompressionUtilities.getUncompressedInputStream(Files.newInputStream(path, new OpenOption[0]));
            try {
                sArray = this.readStream(is);
                if (is == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return EMPTY_MAP;
                }
            }
            is.close();
        }
        return sArray;
    }

    private short[][] readStream(InputStream inputStream) throws IOException {
        int squareSize = 1;
        short[] data = new short[(int)Math.pow(squareSize, 2.0)];
        int index = 0;
        ByteBuffer byteBuffer = ByteBuffer.wrap(inputStream.readAllBytes());
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        while (byteBuffer.hasRemaining()) {
            data[index] = byteBuffer.getShort();
            if (++index < data.length || !byteBuffer.hasRemaining()) continue;
            data = Arrays.copyOf(data, (int)Math.pow(++squareSize, 2.0));
        }
        short[][] realData = new short[squareSize][squareSize];
        for (int latitude = 0; latitude < squareSize; ++latitude) {
            for (int longitude = 0; longitude < squareSize; ++longitude) {
                realData[latitude][longitude] = data[latitude * squareSize + longitude];
            }
        }
        return realData;
    }
}

