/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.maproulette;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.checks.flag.serializer.CheckFlagDeserializer;
import org.openstreetmap.atlas.checks.maproulette.MapRouletteCommand;
import org.openstreetmap.atlas.checks.maproulette.MapRouletteConfiguration;
import org.openstreetmap.atlas.checks.maproulette.data.Challenge;
import org.openstreetmap.atlas.checks.maproulette.data.ChallengeStatus;
import org.openstreetmap.atlas.checks.maproulette.data.Task;
import org.openstreetmap.atlas.checks.maproulette.serializer.ChallengeDeserializer;
import org.openstreetmap.atlas.checks.utility.FileUtility;
import org.openstreetmap.atlas.checks.utility.OpenStreetMapCheckFlagConverter;
import org.openstreetmap.atlas.locale.IsoCountry;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.configuration.StandardConfiguration;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRouletteUploadCommand
extends MapRouletteCommand {
    private static final Command.Switch<File> INPUT_DIRECTORY = new Command.Switch("logfiles", "Path to folder containing log files to upload to MapRoulette.", File::new, Command.Optionality.REQUIRED);
    private static final Command.Switch<File> CONFIG_LOCATION = new Command.Switch("config", "Path to a file containing MapRoulette challenge configuration.", File::new, Command.Optionality.OPTIONAL, "config/configuration.json");
    private static final Command.Switch<List<String>> COUNTRIES = new Command.Switch("countries", "A comma separated list of ISO3 country codes to filter flags by.", string -> Arrays.asList(string.split(",")), Command.Optionality.OPTIONAL);
    private static final Command.Switch<List<String>> CHECKS = new Command.Switch("checks", "A comma separated list of check names to filter flags by.", string -> Arrays.asList(string.split(",")), Command.Optionality.OPTIONAL);
    private static final Command.Switch<String> CHECKIN_COMMENT_PREFIX = new Command.Switch("checkinCommentPrefix", "MapRoulette checkinComment prefix. This will be prepended to the check name (e.g. #prefix: [ISO - CheckName] ).", String::toString, Command.Optionality.OPTIONAL, "#maproulette");
    private static final Command.Switch<String> CHECKIN_COMMENT = new Command.Switch("checkinComment", "MapRoulette checkinComment. If supplied, this would overwrite the checkinCommentPrefix", String::toString, Command.Optionality.OPTIONAL, "");
    private static final Command.Switch<Boolean> INCLUDE_FIX_SUGGESTIONS = new Command.Switch("includeFixSuggestions", "true/false whether all fix suggestions in the geojson should be uploaded to MR.", Boolean::parseBoolean, Command.Optionality.OPTIONAL, "true");
    private static final String PARAMETER_CHALLENGE = "challenge";
    private static final Logger logger = LoggerFactory.getLogger(MapRouletteUploadCommand.class);
    private final Map<String, Map<String, Challenge>> checkNameChallengeMap = new HashMap<String, Map<String, Challenge>>();

    public static void main(String[] args) {
        new MapRouletteUploadCommand().run(args);
    }

    public String getCountryDisplayName(String countryCode) {
        return "NA".equals(countryCode) ? "" : Arrays.stream(countryCode.split(",")).map(country -> IsoCountry.displayCountry((String)country).orElse(country)).collect(Collectors.joining(", "));
    }

    @Override
    public Command.SwitchList switches() {
        return super.switches().with(new Command.Switch[]{INPUT_DIRECTORY, OUTPUT_PATH, CONFIG_LOCATION, COUNTRIES, CHECKS, CHECKIN_COMMENT_PREFIX, CHECKIN_COMMENT});
    }

    @Override
    protected void execute(CommandMap commandMap, MapRouletteConfiguration configuration) {
        Configuration instructions = this.loadConfiguration(commandMap);
        Optional countries = commandMap.getOption(COUNTRIES);
        Optional checks = commandMap.getOption(CHECKS);
        String checkinCommentPrefix = (String)commandMap.get(CHECKIN_COMMENT_PREFIX);
        String checkinComment = (String)commandMap.get(CHECKIN_COMMENT);
        ((File)commandMap.get(INPUT_DIRECTORY)).listFilesRecursively().forEach(logFile -> {
            Optional<FileUtility.LogOutputFileType> optionalHandledFileType = FileUtility.getOptionalLogOutputType(logFile);
            optionalHandledFileType.ifPresent(logOutputFileType -> {
                try (BufferedReader reader = FileUtility.getReader(logFile, logOutputFileType);){
                    reader.lines().filter(line -> line.trim().length() > 0).forEach(line -> {
                        boolean checkIsSupported;
                        CheckFlag flagRecoveredFromLine = new CheckFlagDeserializer().deserialize(new JsonParser().parse(line), null, null);
                        if (flagRecoveredFromLine == null) {
                            return;
                        }
                        CheckFlag uploadFlag = OpenStreetMapCheckFlagConverter.openStreetMapify(flagRecoveredFromLine).orElse(flagRecoveredFromLine);
                        String countryCode = uploadFlag.getCountryISO();
                        String checkName = uploadFlag.getChallengeName().orElse("");
                        boolean countryIsSupported = countries.isEmpty() || !"NA".equals(countryCode) && ((List)countries.get()).contains(countryCode);
                        boolean bl = checkIsSupported = checks.isEmpty() || ((List)checks.get()).contains(checkName);
                        if (countryIsSupported && checkIsSupported) {
                            try {
                                Map countryToChallengeMap = this.checkNameChallengeMap.computeIfAbsent(checkName, ignore -> new HashMap());
                                Challenge challengeObject = countryToChallengeMap.computeIfAbsent(countryCode, ignore -> this.getChallenge(checkName, instructions, countryCode, checkinCommentPrefix, checkinComment));
                                boolean includeFixSuggestions = commandMap.get(INCLUDE_FIX_SUGGESTIONS) == null || Boolean.parseBoolean((String)commandMap.get(INCLUDE_FIX_SUGGESTIONS));
                                Task task = uploadFlag.getMapRouletteTask(includeFixSuggestions);
                                task.setChallengeName(challengeObject.getName());
                                this.addTask(challengeObject, task);
                            }
                            catch (UnsupportedEncodingException | URISyntaxException error) {
                                logger.error("Exception thrown while adding task: ", (Throwable)error);
                            }
                        }
                    });
                    this.uploadTasks();
                }
                catch (IOException error) {
                    logger.error("Exception while reading {}:", logFile, (Object)error);
                }
            });
        });
    }

    private Challenge getChallenge(String checkName, Configuration fallbackConfiguration, String countryCode, String checkinCommentPrefix, String checkinComment) {
        Map challengeMap = (Map)fallbackConfiguration.get(this.getChallengeParameter(checkName), Collections.emptyMap()).value();
        Gson gson = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter(Challenge.class, (Object)new ChallengeDeserializer()).create();
        Challenge result = (Challenge)gson.fromJson(gson.toJson((Object)challengeMap), Challenge.class);
        String challengeName = String.join((CharSequence)" - ", this.getCountryDisplayName(countryCode), result.getName().isEmpty() ? checkName : result.getName());
        result.setName(challengeName);
        result.setCheckinComment(checkinComment.isEmpty() ? String.format("%s: %s", checkinCommentPrefix, challengeName) : checkinComment);
        result.setStatus(ChallengeStatus.READY.intValue());
        result.setEnabled(false);
        result.setUpdateTasks(false);
        return result;
    }

    private String getChallengeParameter(String checkName) {
        return MessageFormat.format("{0}.{1}", checkName, PARAMETER_CHALLENGE);
    }

    private Configuration loadConfiguration(CommandMap map) {
        return new StandardConfiguration((Resource)((File)map.get(CONFIG_LOCATION)));
    }
}

