/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.maproulette;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.openstreetmap.atlas.checks.maproulette.data.ProjectConfiguration;
import org.openstreetmap.atlas.exception.CoreException;

public class MapRouletteConfiguration
implements Serializable {
    private static final int API_KEY_INDEX = 3;
    private static final int NUMBER_OF_COMPONENTS = 4;
    private static final int PORT_INDEX = 1;
    private static final int PROJECT_NAME_INDEX = 2;
    private static final int SERVER_INDEX = 0;
    private static final long serialVersionUID = -1060265212173405828L;
    private static final String DELIMITER = "(?<!https|http):";
    private static final String SCHEME_DELIMITER = "://";
    private final String apiKey;
    private final int port;
    private final String scheme;
    private final String server;
    private final ProjectConfiguration projectConfiguration;

    public static MapRouletteConfiguration parse(String configuration) {
        String[] components;
        if (StringUtils.isNotEmpty((CharSequence)configuration) && (components = configuration.split(DELIMITER)).length == 4) {
            String server;
            String scheme;
            String[] splitServer = components[0].split(SCHEME_DELIMITER);
            if (splitServer.length < 2) {
                scheme = "http";
                server = components[0];
            } else {
                scheme = splitServer[0];
                server = splitServer[1];
            }
            return new MapRouletteConfiguration(scheme, server, Integer.parseInt(components[1]), new ProjectConfiguration(components[2]), components[3]);
        }
        throw new CoreException("Map Roulette configuration not set, invalid string passed in. [{}]", new Object[]{configuration});
    }

    public MapRouletteConfiguration(String server, int port, String projectName, String apiKey) {
        this("http", server, port, new ProjectConfiguration(projectName), apiKey);
    }

    public MapRouletteConfiguration(String server, int port, ProjectConfiguration projectConfiguration, String apiKey) {
        this("http", server, port, projectConfiguration, apiKey);
    }

    public MapRouletteConfiguration(String scheme, String server, int port, ProjectConfiguration projectConfiguration, String apiKey) {
        this.scheme = scheme;
        this.server = server;
        this.port = port;
        this.projectConfiguration = projectConfiguration;
        this.apiKey = apiKey;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public int getPort() {
        return this.port;
    }

    public ProjectConfiguration getProjectConfiguration() {
        return this.projectConfiguration;
    }

    public String getProjectName() {
        return this.projectConfiguration.getName();
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServer() {
        return this.server;
    }

    public String toString() {
        return String.format("%s://%s:%d:%s:%s", this.scheme, this.server, this.port, this.projectConfiguration.getName(), this.apiKey);
    }
}

