/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.commands;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.streaming.writers.JsonWriter;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.openstreetmap.atlas.utilities.runtime.FlexibleSubCommand;

public abstract class JSONFlagDiffSubCommand
implements FlexibleSubCommand {
    static final String CHECK_COUNT_FORMAT = "%s: %d%n";
    static final String FEATURE_PROPERTIES = "feature_properties";
    static final String GENERATOR = "generator";
    static final String NAME = "name";
    static final String IDENTIFIERS = "identifiers";
    private static final Command.Switch<File> REFERENCE_FILE_PARAMETER = new Command.Switch("reference", "A file or directory of files containing atlas-checks flags to use as a baseline for comparison.", File::new, Command.Optionality.REQUIRED);
    private static final Command.Switch<File> INPUT_FILE_PARAMETER = new Command.Switch("input", "A file or directory of files containing atlas-checks flags to compare changes from the baseline.", File::new, Command.Optionality.REQUIRED);
    private static final Command.Switch<String> OUTPUT_FOLDER_PARAMETER = new Command.Switch("output", "A directory to place output log files in. If not included no outputs files will be written.", String::new, Command.Optionality.OPTIONAL);
    private final Gson gson = new Gson();
    private Map<String, Map<Set<String>, JsonObject>> reference = new HashMap<String, Map<Set<String>, JsonObject>>();
    private Map<String, Map<Set<String>, JsonObject>> input = new HashMap<String, Map<Set<String>, JsonObject>>();
    private final String commandName;
    private final String description;
    private final String fileExtension;

    public JSONFlagDiffSubCommand(String name, String description, String fileExtension) {
        this.commandName = name;
        this.description = description;
        this.fileExtension = fileExtension;
    }

    public int execute(CommandMap command) {
        this.getFilesOfType((File)command.get(REFERENCE_FILE_PARAMETER)).forEach(path -> {
            this.reference = this.mergeMaps(this.mapFeatures((File)path), this.reference);
        });
        this.getFilesOfType((File)command.get(INPUT_FILE_PARAMETER)).forEach(path -> {
            this.input = this.mergeMaps(this.mapFeatures((File)path), this.input);
        });
        Map<String, Set<JsonObject>> additions = this.getDiff(this.input, this.reference);
        Map<String, Set<JsonObject>> subtractions = this.getDiff(this.reference, this.input);
        System.out.printf("%nTotal Items: %d%n", (long)this.getReferenceSize() + this.countMapValues(additions));
        System.out.printf("%nAdditions: %d%n", this.countMapValues(additions));
        additions.forEach((check, set) -> System.out.printf(CHECK_COUNT_FORMAT, check, set.size()));
        System.out.printf("%nSubtractions: %d%n", this.countMapValues(subtractions));
        subtractions.forEach((check, set) -> System.out.printf(CHECK_COUNT_FORMAT, check, set.size()));
        Optional output = command.getOption(OUTPUT_FOLDER_PARAMETER);
        if (output.isPresent()) {
            this.writeSetToGeoJSON(additions, new File(String.format("%s/additions-%d-%d.%s", output.get(), new Date().getTime(), this.countMapValues(additions), this.fileExtension)));
            this.writeSetToGeoJSON(subtractions, new File(String.format("%s/subtractions-%d-%d.%s", output.get(), new Date().getTime(), this.countMapValues(subtractions), this.fileExtension)));
        }
        return 0;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.commandName;
    }

    public Command.SwitchList switches() {
        return new Command.SwitchList().with(new Command.Switch[]{REFERENCE_FILE_PARAMETER, INPUT_FILE_PARAMETER, OUTPUT_FOLDER_PARAMETER});
    }

    public void usage(PrintStream writer) {
        writer.print("-reference=path/to/first/flag/file,path/to/second/flag/file : file of flags to use as a baseline\n");
        writer.print("-input=path/to/first/flag/file,path/to/second/flag/file : file of flags to compare changes from the baseline\n");
        writer.print("-output=path/to/output/folder : optional directory to write output files to\n");
    }

    protected Map<String, Set<JsonObject>> getDiff(Map<String, Map<Set<String>, JsonObject>> reference, Map<String, Map<Set<String>, JsonObject>> input) {
        HashMap<String, Set<JsonObject>> diff = new HashMap<String, Set<JsonObject>>();
        reference.forEach((check, flags) -> flags.forEach((identifier, flag) -> {
            if (!input.containsKey(check) || !((Map)input.get(check)).containsKey(identifier)) {
                diff.putIfAbsent((String)check, new HashSet());
                ((Set)diff.get(check)).add(flag);
            }
        }));
        return diff;
    }

    protected Gson getGson() {
        return this.gson;
    }

    protected Map<String, Map<Set<String>, JsonObject>> getInput() {
        return this.input;
    }

    protected Map<String, Map<Set<String>, JsonObject>> getReference() {
        return this.reference;
    }

    protected int getReferenceSize() {
        int sourceSize = 0;
        for (String check : this.getReference().keySet()) {
            sourceSize += this.getReference().get(check).size();
        }
        return sourceSize;
    }

    protected abstract Map<String, Map<Set<String>, JsonObject>> mapFeatures(File var1);

    protected void writeSetToGeoJSON(Map<String, Set<JsonObject>> flags, File output) {
        JsonWriter writer = new JsonWriter((WritableResource)output);
        flags.values().stream().flatMap(Collection::stream).forEach(arg_0 -> ((JsonWriter)writer).writeLine(arg_0));
        writer.close();
    }

    private boolean checkFileExtension(File file) {
        return FilenameUtils.getExtension((String)(file.isGzipped() ? FilenameUtils.getBaseName((String)file.getName()) : file.getName())).equalsIgnoreCase(this.fileExtension);
    }

    private long countMapValues(Map<String, Set<JsonObject>> map) {
        return map.values().stream().mapToLong(Collection::size).sum();
    }

    private Set<File> getFilesOfType(File file) {
        String fileName;
        String string = fileName = file.isGzipped() ? FilenameUtils.getBaseName((String)file.getName()) : file.getName();
        if (FilenameUtils.getExtension((String)fileName).equalsIgnoreCase(this.fileExtension)) {
            return Collections.singleton(file);
        }
        if (file.isDirectory()) {
            return file.listFilesRecursively().stream().filter(this::checkFileExtension).collect(Collectors.toSet());
        }
        return new HashSet<File>();
    }

    private Map<String, Map<Set<String>, JsonObject>> mergeMaps(Map<String, Map<Set<String>, JsonObject>> put, Map<String, Map<Set<String>, JsonObject>> place) {
        HashMap<String, Map<Set<String>, JsonObject>> mergedMap = new HashMap<String, Map<Set<String>, JsonObject>>(place);
        put.forEach((check, flags) -> {
            mergedMap.putIfAbsent((String)check, new HashMap());
            ((Map)mergedMap.get(check)).putAll(flags);
        });
        return mergedMap;
    }
}

