/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.tag;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.walker.OsmWayWalker;
import org.openstreetmap.atlas.tags.BridgeTag;
import org.openstreetmap.atlas.tags.CoveredTag;
import org.openstreetmap.atlas.tags.MaxHeightTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.TunnelTag;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.tags.filters.TaggableFilter;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class TunnelBridgeHeightLimitCheck
extends BaseCheck<Long> {
    private static final long serialVersionUID = 7912181047816225229L;
    private static final String FALLBACK_INSTRUCTION_TEMPLATE = "Way {0,number,#} %s but vehicle height limit is not specified. Add a 'maxheight' or 'maxheight:physical' tag according to an existing legal or physical restriction.";
    private static final int TUNNEL_CASE_INDEX = 0;
    private static final int COVERED_CASE_INDEX = 1;
    private static final int BRIDGE_CASE_INDEX = 2;
    private static final List<String> FALLBACK_CASES = Arrays.asList("is a tunnel", "is covered", "passes under bridge ({1,number,#})");
    private static final List<String> FALLBACK_INSTRUCTIONS = FALLBACK_CASES.stream().map(caseDescription -> String.format(FALLBACK_INSTRUCTION_TEMPLATE, caseDescription)).collect(Collectors.toList());
    private static final String MAXHEIGHT_PHYSICAL = "maxheight:physical";
    private static final String HIGHWAY_FILTER_DEFAULT = "highway->motorway_link,trunk_link,primary,primary_link,secondary,secondary_link";
    private final TaggableFilter highwayFilter;

    public TunnelBridgeHeightLimitCheck(Configuration configuration) {
        super(configuration);
        this.highwayFilter = this.configurationValue(configuration, "highway.filter", HIGHWAY_FILTER_DEFAULT, TaggableFilter::forDefinition);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Edge && ((Edge)object).isMainEdge() && !this.isFlagged(object.getOsmIdentifier());
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        if ((TunnelTag.isTunnel((Taggable)object) || this.isCovered(object)) && this.isHighwayWithoutMaxHeight(object)) {
            Long osmId = object.getOsmIdentifier();
            this.markAsFlagged(osmId);
            Set edgesToFlag = new OsmWayWalker((Edge)object).collectEdges();
            int instructionIndex = TunnelTag.isTunnel((Taggable)object) ? 0 : 1;
            String instruction = this.getLocalizedInstruction(instructionIndex, osmId);
            CheckFlag flag = this.createFlag((Set<AtlasObject>)edgesToFlag, instruction);
            return Optional.of(flag);
        }
        if (BridgeTag.isBridge((Taggable)object)) {
            Edge bridge = (Edge)object;
            PolyLine bridgeAsPolyLine = bridge.asPolyLine();
            HashSet wayIdsToFlag = new HashSet();
            HashSet edgesToFlag = new HashSet();
            Iterables.stream((Iterable)bridge.getAtlas().edgesIntersecting((GeometricSurface)bridge.bounds())).filter(edge -> edge.isMainEdge() && edge.getOsmIdentifier() != bridge.getOsmIdentifier() && !this.isFlagged(edge.getOsmIdentifier()) && this.isHighwayWithoutMaxHeight((AtlasObject)edge) && this.edgeCrossesBridge(edge.asPolyLine(), bridgeAsPolyLine)).forEach(edge -> {
                long wayId = edge.getOsmIdentifier();
                this.markAsFlagged(wayId);
                wayIdsToFlag.add(wayId);
                edgesToFlag.addAll(new OsmWayWalker(edge).collectEdges());
            });
            if (!wayIdsToFlag.isEmpty()) {
                CheckFlag checkFlag = new CheckFlag(this.getTaskIdentifier((AtlasObject)bridge));
                wayIdsToFlag.forEach(wayId -> checkFlag.addInstruction(this.getLocalizedInstruction(2, wayId, bridge.getOsmIdentifier())));
                checkFlag.addObjects(edgesToFlag);
                return Optional.of(checkFlag);
            }
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean edgeCrossesBridge(PolyLine edge, PolyLine bridge) {
        return edge.intersections(bridge).stream().anyMatch(loc -> !loc.equals((Object)bridge.first()) && !loc.equals((Object)bridge.last()));
    }

    private boolean isCovered(AtlasObject object) {
        return Validators.isOfType((Taggable)object, CoveredTag.class, (Enum[])new CoveredTag[]{CoveredTag.YES, CoveredTag.ARCADE, CoveredTag.COLONNADE});
    }

    private boolean isHighwayWithoutMaxHeight(AtlasObject object) {
        return this.highwayFilter.test((Taggable)object) && !Validators.hasValuesFor((Taggable)object, (Class[])new Class[]{MaxHeightTag.class}) && object.getTag(MAXHEIGHT_PHYSICAL).isEmpty();
    }
}

