/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.tag;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.checks.validation.tag.RoadNameSpellingConsistencyCheckWalker;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.LocationItem;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public class RoadNameSpellingConsistencyCheck
extends BaseCheck<Long> {
    private static final long serialVersionUID = 1L;
    private static final HighwayTag MINIMUM_NAME_PRIORITY_DEFAULT = HighwayTag.SERVICE;
    private static final double MAXIMUM_SEARCH_DISTANCE_DEFAULT = 500.0;
    private static final List<String> FALLBACK_INSTRUCTIONS = Collections.singletonList("These road segments have spelling inconsistencies. Spellings are: {0}. Examine all flagged road segments to determine the best spelling, and apply this spelling to all of those segments.");
    private final Distance maximumSearchDistance;

    public RoadNameSpellingConsistencyCheck(Configuration configuration) {
        super(configuration);
        this.maximumSearchDistance = this.configurationValue(configuration, "distance.search.maximum", 500.0, Distance::meters);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Edge && ((Edge)object).highwayTag().isMoreImportantThanOrEqualTo(MINIMUM_NAME_PRIORITY_DEFAULT) && ((Edge)object).isMainEdge() && !this.isFlagged(object.getIdentifier()) && ((Edge)object).getName().isPresent();
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Edge edge = (Edge)object;
        Set<Edge> inconsistentEdgeSet = new RoadNameSpellingConsistencyCheckWalker(edge, this.maximumSearchDistance).collectEdges().stream().filter(incomingEdge -> !this.isFlagged(incomingEdge.getIdentifier())).filter(RoadNameSpellingConsistencyCheckWalker.isEdgeWithInconsistentSpelling(edge)).collect(Collectors.toSet());
        if (!inconsistentEdgeSet.isEmpty()) {
            inconsistentEdgeSet.add(edge);
            String startingEdgeName = (String)edge.getName().get();
            StringBuilder inconsistentSpellingsCommaDelimited = new StringBuilder("\"").append(startingEdgeName).append("\"");
            HashMap<String, Boolean> nameMap = new HashMap<String, Boolean>();
            nameMap.put(startingEdgeName, true);
            inconsistentEdgeSet.forEach(inconsistentEdge -> {
                this.markAsFlagged(inconsistentEdge.getIdentifier());
                String flaggedInconsistentName = (String)inconsistentEdge.getName().get();
                if (nameMap.get(flaggedInconsistentName) == null) {
                    nameMap.put(flaggedInconsistentName, true);
                    inconsistentSpellingsCommaDelimited.append(" , \"").append(flaggedInconsistentName).append("\"");
                }
            });
            List<Location> inconsistencyLocations = inconsistentEdgeSet.stream().map(Edge::start).map(LocationItem::getLocation).collect(Collectors.toList());
            return Optional.of(this.createFlag(inconsistentEdgeSet, this.getLocalizedInstruction(0, inconsistentSpellingsCommaDelimited.toString()), inconsistencyLocations));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }
}

