/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.tag;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.tags.BridgeTag;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.JunctionTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.direction.EdgeDirectionComparator;

public class RoadNameGapCheck
extends BaseCheck<Long> {
    private static final long serialVersionUID = 7104778218412127847L;
    private static final List<String> VALID_HIGHWAY_TAG_DEFAULT = Arrays.asList("primary", "secondary", "tertiary", "trunk", "motorway");
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("Road name is empty for way with id {0,number,#}.", "The name, ''{0}'', for way id {1,number,#} is different from the ways it is connected to, ''{2}''. Consider setting the name so that it is consistent with the other ways.", "The name, ''{0}'', for bridge with id {1,number,#} is different from the ways it is connected to, ''{2}''. Consider setting the name of this way to ''{2}'' so that it is consistent with the other ways, setting ''bridge:name={0}'' to save the original name of the bridge.");
    private final List<String> validHighwayTag;

    public RoadNameGapCheck(Configuration configuration) {
        super(configuration);
        this.validHighwayTag = this.configurationValue(configuration, "valid.highway.tag", VALID_HIGHWAY_TAG_DEFAULT).stream().map(String::toLowerCase).collect(Collectors.toList());
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Edge && Edge.isMainEdgeIdentifier((long)object.getIdentifier()) && !JunctionTag.isRoundabout((Taggable)object) && Validators.hasValuesFor((Taggable)object, (Class[])new Class[]{HighwayTag.class}) && this.validHighwayTag.contains(object.tag("highway"));
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Edge edge = (Edge)object;
        EdgePredicate edgePredicate = new EdgePredicate(edge);
        Set<Edge> inEdges = edge.inEdges().stream().filter(obj -> this.validCheckForObject((AtlasObject)obj) && edgePredicate.isSameHeading((AtlasObject)obj)).collect(Collectors.toSet());
        Set<Edge> outEdges = edge.outEdges().stream().filter(obj -> this.validCheckForObject((AtlasObject)obj) && edgePredicate.isSameHeading((AtlasObject)obj)).collect(Collectors.toSet());
        if (inEdges.isEmpty() || outEdges.isEmpty()) {
            return Optional.empty();
        }
        Set<String> matchingInAndOutEdgeNames = this.getMatchingInAndOutEdgeNames(inEdges, outEdges);
        if (matchingInAndOutEdgeNames.isEmpty()) {
            return Optional.empty();
        }
        String nameSuggestion = matchingInAndOutEdgeNames.iterator().next();
        if (edge.getName().isEmpty()) {
            return Optional.of(this.createFlag(object, this.getLocalizedInstruction(0, edge.getOsmIdentifier())).addFixSuggestion(FeatureChange.add((AtlasEntity)((AtlasEntity)((CompleteEntity)CompleteEntity.from((AtlasEntity)((AtlasEntity)object))).withAddedTag("name", nameSuggestion)), (Atlas)object.getAtlas())));
        }
        Optional edgeName = edge.getName();
        if (edgeName.isPresent() && !matchingInAndOutEdgeNames.contains(edgeName.get())) {
            Set<Edge> connectedEdges = edge.connectedEdges().stream().filter(this::validCheckForObject).collect(Collectors.toSet());
            int instructionIndex = BridgeTag.isBridge((Taggable)object) ? 2 : 1;
            return this.findMatchingEdgeNameWithConnectedEdges(connectedEdges, (String)edgeName.get()) ? Optional.empty() : Optional.of(this.createFlag(object, this.getLocalizedInstruction(instructionIndex, edgeName.get(), edge.getOsmIdentifier(), nameSuggestion)));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean findMatchingEdgeNameWithConnectedEdges(Set<Edge> connectedEdges, String edgeName) {
        return connectedEdges.stream().anyMatch(connectedEdge -> connectedEdge.getName().isPresent() && ((String)connectedEdge.getName().get()).equals(edgeName));
    }

    private Set<String> getMatchingInAndOutEdgeNames(Set<Edge> inEdges, Set<Edge> outEdges) {
        return inEdges.stream().filter(inEdge -> outEdges.stream().anyMatch(outEdge -> outEdge.getName().isPresent() && inEdge.getName().isPresent() && ((String)outEdge.getName().get()).equals(inEdge.getName().get()) && inEdge.getOsmIdentifier() != outEdge.getOsmIdentifier())).map(edge -> (String)edge.getName().get()).collect(Collectors.toSet());
    }

    static class EdgePredicate {
        private final Edge edge;
        private final EdgeDirectionComparator edgeDirectionComparator = new EdgeDirectionComparator();

        EdgePredicate(Edge edge) {
            this.edge = edge;
        }

        boolean isSameHeading(AtlasObject object) {
            Edge otherEdge = (Edge)object;
            return object != null && this.edgeDirectionComparator.isSameDirection(this.edge, otherEdge, false);
        }
    }
}

