/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.tag;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.walker.OsmWayWalker;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.tags.names.NameFinder;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class LongNameCheck
extends BaseCheck<String> {
    private static final long serialVersionUID = -8395117392888327533L;
    private static final long NAME_MAX_DEFAULT = 40L;
    private static final Set<String> NAME_TAG_KEYS = NameFinder.STANDARD_TAGS_NON_REFERENCE.stream().map(Validators::findTagNameIn).collect(Collectors.toSet());
    private static final List<String> FALLBACK_INSTRUCTIONS = Collections.singletonList("Feature {0,number,#} has the following tags with over {1,number,#} characters: {2}.");
    private final long nameMax;

    public LongNameCheck(Configuration configuration) {
        super(configuration);
        this.nameMax = this.configurationValue(configuration, "name.max", 40L);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return !this.isFlagged(this.getUniqueOSMIdentifier(object)) && object.getTags().keySet().stream().anyMatch(this::isNameTag);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Set invalidNameTags = object.getTags().entrySet().stream().filter(entry -> this.isNameTag((String)entry.getKey())).filter(entry -> (long)((String)entry.getValue()).length() >= this.nameMax).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (!invalidNameTags.isEmpty()) {
            this.markAsFlagged(this.getUniqueOSMIdentifier(object));
            String instruction = this.getLocalizedInstruction(0, object.getOsmIdentifier(), this.nameMax, String.join((CharSequence)", ", invalidNameTags));
            return Optional.of(object instanceof Edge ? this.createFlag((Set<AtlasObject>)new OsmWayWalker((Edge)object).collectEdges(), instruction) : this.createFlag(object, instruction));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean isNameTag(String key) {
        return NAME_TAG_KEYS.contains(key.split(":")[0]);
    }
}

