/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.tag;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.walker.OsmWayWalker;
import org.openstreetmap.atlas.tags.BarrierTag;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.LanesTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.tags.filters.TaggableFilter;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class InvalidLanesTagCheck
extends BaseCheck<Long> {
    private static final long serialVersionUID = -1459761692833694715L;
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("Way {0,number,#} has an invalid lanes value.");
    private static final int MAX_TOLL_PLAZA_EDGES = 20;
    private static final String LANES_FILTER_DEFAULT = "lanes->1,1.5,2,3,4,5,6,7,8,9,10";
    private final TaggableFilter lanesFilter;
    private final HashSet<Long> isChecked = new HashSet();

    public InvalidLanesTagCheck(Configuration configuration) {
        super(configuration);
        this.lanesFilter = this.configurationValue(configuration, "lanes.filter", LANES_FILTER_DEFAULT, value -> TaggableFilter.forDefinition((String)value.toString()));
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return Validators.hasValuesFor((Taggable)object, (Class[])new Class[]{LanesTag.class}) && HighwayTag.isCarNavigableHighway((Taggable)object) && object instanceof Edge && ((Edge)object).isMainEdge() && !this.lanesFilter.test((Taggable)object) && !this.isFlagged(object.getOsmIdentifier());
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        if (this.isChecked.contains(object.getIdentifier()) || !this.partOfTollBooth(object)) {
            this.markAsFlagged(object.getOsmIdentifier());
            return Optional.of(this.createFlag((Set<AtlasObject>)new OsmWayWalker((Edge)object).collectEdges(), this.getLocalizedInstruction(0, object.getOsmIdentifier())));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private HashSet<Edge> connectedInvalidLanes(AtlasObject object) {
        HashSet<Edge> connectedEdges = new HashSet<Edge>();
        ArrayDeque<Edge> toProcess = new ArrayDeque<Edge>();
        connectedEdges.add((Edge)object);
        toProcess.add((Edge)object);
        for (int count = 0; !toProcess.isEmpty() && count < 20; ++count) {
            Edge polledEdge = (Edge)toProcess.poll();
            for (Edge edge : polledEdge.connectedEdges()) {
                if (connectedEdges.contains(edge) || !((Edge)object).isMainEdge() || !Validators.hasValuesFor((Taggable)edge, (Class[])new Class[]{LanesTag.class}) || !HighwayTag.isCarNavigableHighway((Taggable)edge) || this.lanesFilter.test((Taggable)edge)) continue;
                toProcess.add(edge);
                connectedEdges.add(edge);
            }
        }
        return connectedEdges;
    }

    private boolean partOfTollBooth(AtlasObject object) {
        HashSet<Edge> connectedInvalidEdges = this.connectedInvalidLanes(object);
        for (Edge edge : connectedInvalidEdges) {
            for (Node node : edge.connectedNodes()) {
                if (!Validators.isOfType((Taggable)node, BarrierTag.class, (Enum[])new BarrierTag[]{BarrierTag.TOLL_BOOTH})) continue;
                connectedInvalidEdges.forEach(validEdge -> this.markAsFlagged(validEdge.getOsmIdentifier()));
                return true;
            }
        }
        connectedInvalidEdges.forEach(invalidEdge -> this.isChecked.add(invalidEdge.getIdentifier()));
        return false;
    }
}

