/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.tag;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.atlas.predicates.TypePredicates;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.walker.OsmWayWalker;
import org.openstreetmap.atlas.tags.FerryTag;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.RouteTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class HighwayToFerryTagCheck
extends BaseCheck<Long> {
    private static final String MINIMUM_HIGHWAY_TYPE_DEFAULT = HighwayTag.PATH.toString();
    private static final String FERRY_TAG_IF_SAME_AS_HIGHWAY_INSTRUCTION = "This way {0,number,#} has a Ferry and a Highway tag for a ferry route. Please verify and remove the highway tag.";
    private static final String FERRY_TAG_IF_ABSENT_INSTRUCTION = "This way {0,number,#} has a Highway tag for a ferry route instead of a Ferry tag. Please verify and add a Ferry tag with the Highway tag value and remove the highway tag.";
    private static final String FERRY_TAG_IF_DIFFERENT_FROM_HIGHWAY_INSTRUCTION = "This way {0,number,#} has a Ferry and a Highway tag for a ferry route. Please verify and update the Ferry tag with the Highway tag value and remove the highway tag.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("This way {0,number,#} has a Ferry and a Highway tag for a ferry route. Please verify and update the Ferry tag with the Highway tag value and remove the highway tag.", "This way {0,number,#} has a Ferry and a Highway tag for a ferry route. Please verify and remove the highway tag.", "This way {0,number,#} has a Highway tag for a ferry route instead of a Ferry tag. Please verify and add a Ferry tag with the Highway tag value and remove the highway tag.");
    private static final long serialVersionUID = 2166377913919285833L;
    private final HighwayTag minimumHighwayType;

    public HighwayToFerryTagCheck(Configuration configuration) {
        super(configuration);
        this.minimumHighwayType = this.configurationValue(configuration, "highway.type.minimum", MINIMUM_HIGHWAY_TYPE_DEFAULT, value -> HighwayTag.valueOf((String)value.toUpperCase()));
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return TypePredicates.IS_EDGE.test(object) && ((Edge)object).isMainEdge() && Validators.isOfType((Taggable)object, RouteTag.class, (Enum[])new RouteTag[]{RouteTag.FERRY}) && this.isMinimumHighwayType(object) && !this.isFlagged(object.getOsmIdentifier());
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        this.markAsFlagged(object.getOsmIdentifier());
        boolean hasSameHighwayClassification = this.hasSameClassificationAsHighwayTag(object);
        Set edges = new OsmWayWalker((Edge)object).collectEdges();
        if (Validators.hasValuesFor((Taggable)object, (Class[])new Class[]{FerryTag.class})) {
            int instructionIndex = hasSameHighwayClassification ? 1 : 0;
            return Optional.of(this.createFlag((Set<AtlasObject>)edges, this.getLocalizedInstruction(instructionIndex, object.getOsmIdentifier())).addFixSuggestions(edges.stream().map(edge -> this.getFixSuggestion((AtlasObject)edge, true, hasSameHighwayClassification)).collect(Collectors.toSet())));
        }
        return Optional.of(this.createFlag((Set<AtlasObject>)edges, this.getLocalizedInstruction(2, object.getOsmIdentifier())).addFixSuggestions(edges.stream().map(edge -> this.getFixSuggestion((AtlasObject)edge, false, hasSameHighwayClassification)).collect(Collectors.toSet())));
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private FeatureChange getFixSuggestion(AtlasObject object, boolean hasFerryTag, boolean hasSameHighwayClassification) {
        CompleteEntity completeEntity = ((CompleteEntity)CompleteEntity.shallowFrom((AtlasEntity)((AtlasEntity)object))).withTags(object.getTags());
        if (hasFerryTag && !hasSameHighwayClassification) {
            completeEntity.withReplacedTag("ferry", "ferry", object.tag("highway"));
        } else if (!hasFerryTag) {
            completeEntity.withAddedTag("ferry", object.tag("highway"));
        }
        completeEntity.withRemovedTag("highway");
        return FeatureChange.add((AtlasEntity)((AtlasEntity)completeEntity), (Atlas)object.getAtlas());
    }

    private boolean hasSameClassificationAsHighwayTag(AtlasObject object) {
        return object.getTag("ferry").equals(object.getTag("highway"));
    }

    private boolean isMinimumHighwayType(AtlasObject object) {
        return HighwayTag.highwayTag((Taggable)object).map(highwayTag -> highwayTag.isMoreImportantThanOrEqualTo(this.minimumHighwayType)).orElse(false);
    }
}

