/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.tag;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.Heading;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.walker.OsmWayWalker;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.JunctionTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Angle;

public class HighwayMissingNameAndRefTagCheck
extends BaseCheck<Long> {
    private static final long serialVersionUID = 8198312161814763037L;
    private static final String MISSING_BOTH_NAME_AND_REF_TAG_INSTRUCTIONS = "Way {0, number, #} is missing both name and ref tag. Way must contain either one.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Collections.singletonList("Way {0, number, #} is missing both name and ref tag. Way must contain either one.");
    private final double minAngleForNonContiguousWays;
    private final HighwayTag minHighwayTag;
    private static final String MIN_HIGHWAY_TAG_DEFAULT = "tertiary";
    private static final double MIN_ANGLE_NON_CONTIGUOUS_WAYS = 30.0;

    public HighwayMissingNameAndRefTagCheck(Configuration configuration) {
        super(configuration);
        this.minAngleForNonContiguousWays = this.configurationValue(configuration, "min.nonContiguous.angle", 30.0);
        this.minHighwayTag = Enum.valueOf(HighwayTag.class, this.configurationValue(configuration, "min.highway.type", MIN_HIGHWAY_TAG_DEFAULT).toUpperCase());
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Edge && ((Edge)object).isMainEdge() && !this.isFlagged(object.getOsmIdentifier()) && ((Edge)object).highwayTag().isMoreImportantThanOrEqualTo(this.minHighwayTag) && !HighwayTag.isLinkHighway((HighwayTag)((Edge)object).highwayTag()) && !JunctionTag.isRoundabout((Taggable)object) && !JunctionTag.isCircular((Taggable)object);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        this.markAsFlagged(object.getOsmIdentifier());
        Map tags = object.getTags();
        if (this.highwayMissingBothNameAndRefTag(tags) && !this.isConnectorWayToIgnore(((Edge)object).getMainEdge())) {
            return Optional.of(this.createFlag((Set<AtlasObject>)new OsmWayWalker((Edge)object).collectEdges(), this.getLocalizedInstruction(0, object.getOsmIdentifier())));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private Angle angleDiffBetweenEdges(Edge edge1, Edge edge2) {
        Optional edge2heading;
        Optional edge1heading;
        if (edge1.outEdges().contains(edge2)) {
            edge1heading = edge1.asPolyLine().finalHeading();
            edge2heading = edge2.asPolyLine().initialHeading();
        } else {
            edge1heading = edge2.asPolyLine().finalHeading();
            edge2heading = edge1.asPolyLine().initialHeading();
        }
        if (edge1heading.isPresent() && edge2heading.isPresent()) {
            return ((Heading)edge1heading.get()).difference((Angle)edge2heading.get());
        }
        return Angle.NONE;
    }

    private Set<String> collectEdgeNameTags(Set<Edge> edges) {
        HashSet<String> edgeNames = new HashSet<String>();
        for (Edge edge : edges) {
            Map tags = edge.getTags();
            if (!tags.containsKey("name")) continue;
            edgeNames.add((String)tags.get("name"));
        }
        return edgeNames;
    }

    private Set<String> collectEdgeRefTags(Set<Edge> edges) {
        HashSet<String> edgeRefs = new HashSet<String>();
        for (Edge edge : edges) {
            Map tags = edge.getTags();
            if (!tags.containsKey("ref")) continue;
            edgeRefs.add((String)tags.get("ref"));
        }
        return edgeRefs;
    }

    private void contiguousEdgeLogic(Edge edge, Set<Edge> someEdges, Set<String> someEdgeNames, Set<String> someEdgeRefs) {
        for (Edge someEdge : someEdges) {
            Map someEdgeTags = someEdge.getTags();
            if (!(this.angleDiffBetweenEdges(someEdge, edge).asDegrees() <= this.minAngleForNonContiguousWays) || !someEdgeTags.containsKey("name") && !someEdgeTags.containsKey("ref")) continue;
            if (someEdgeTags.containsKey("name")) {
                someEdgeNames.add((String)someEdgeTags.get("name"));
            }
            if (!someEdgeTags.containsKey("ref")) continue;
            someEdgeRefs.add((String)someEdgeTags.get("ref"));
        }
    }

    private boolean edgesShareTags(Set<String> tagSet1, Set<String> tagSet2) {
        for (String tag : tagSet1) {
            if (!tagSet2.contains(tag)) continue;
            return true;
        }
        return false;
    }

    private boolean highwayMissingBothNameAndRefTag(Map<String, String> tags) {
        return !tags.containsKey("name".toLowerCase()) && !tags.containsKey("ref".toLowerCase());
    }

    private boolean inconsistentTagsWithContiguousEdges(Edge edge, Set<Edge> inEdges, Set<Edge> outEdges) {
        HashSet<String> inEdgeNames = new HashSet<String>();
        HashSet<String> outEdgeNames = new HashSet<String>();
        HashSet<String> inEdgeRefs = new HashSet<String>();
        HashSet<String> outEdgeRefs = new HashSet<String>();
        this.contiguousEdgeLogic(edge, inEdges, inEdgeNames, inEdgeRefs);
        this.contiguousEdgeLogic(edge, outEdges, outEdgeNames, outEdgeRefs);
        return this.edgesShareTags(inEdgeNames, outEdgeNames) || this.edgesShareTags(inEdgeRefs, outEdgeRefs);
    }

    private boolean isConnectorWayToIgnore(Edge edge) {
        Set completeWay = new OsmWayWalker(edge).collectEdges();
        if (completeWay.size() == 1) {
            Set outEdges;
            Node startNode = edge.start();
            Node endNode = edge.end();
            Set inEdges = edge.inEdges();
            if (this.inconsistentTagsWithContiguousEdges(edge, inEdges, outEdges = edge.outEdges())) {
                return false;
            }
            Set<Edge> startNodeConnectedEdges = startNode.connectedEdges().stream().filter(someEdge -> someEdge.getOsmIdentifier() != edge.getOsmIdentifier() && this.angleDiffBetweenEdges((Edge)someEdge, edge).asDegrees() >= this.minAngleForNonContiguousWays).collect(Collectors.toSet());
            Set<Edge> endNodeConnectedEdges = endNode.connectedEdges().stream().filter(someEdge -> someEdge.getOsmIdentifier() != edge.getOsmIdentifier() && this.angleDiffBetweenEdges(edge, (Edge)someEdge).asDegrees() >= this.minAngleForNonContiguousWays).collect(Collectors.toSet());
            Set<String> startNodeConnectedEdgeNames = this.collectEdgeNameTags(startNodeConnectedEdges);
            Set<String> endNodeConnectedEdgeNames = this.collectEdgeNameTags(endNodeConnectedEdges);
            Set<String> startNodeConnectedEdgeRefs = this.collectEdgeRefTags(startNodeConnectedEdges);
            Set<String> endNodeConnectedEdgeRefs = this.collectEdgeRefTags(endNodeConnectedEdges);
            return this.edgesShareTags(startNodeConnectedEdgeNames, endNodeConnectedEdgeNames) || this.edgesShareTags(startNodeConnectedEdgeRefs, endNodeConnectedEdgeRefs);
        }
        return false;
    }
}

